/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.sentenceiterator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;
import org.deeplearning4j.text.documentiterator.DocumentIterator;
import org.deeplearning4j.text.sentenceiterator.SentenceIterator;
import org.deeplearning4j.text.sentenceiterator.SentencePreProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamLineIterator
implements SentenceIterator {
    private DocumentIterator iterator;
    private int linesToFetch;
    private final LinkedBlockingQueue<String> buffer = new LinkedBlockingQueue();
    private SentencePreProcessor preProcessor;
    private BufferedReader currentReader;
    protected Logger logger = LoggerFactory.getLogger(StreamLineIterator.class);

    private StreamLineIterator(DocumentIterator iterator) {
        this.iterator = iterator;
    }

    private void fetchLines(int linesToFetch) {
        String line = "";
        try {
            for (int cnt = 0; cnt < linesToFetch && (line = this.currentReader.readLine()) != null; ++cnt) {
                this.buffer.add(line);
            }
            if (line == null) {
                this.currentReader.close();
                this.currentReader = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public String nextSentence() {
        if (this.buffer.size() < this.linesToFetch) {
            if (this.currentReader != null) {
                this.fetchLines(this.linesToFetch);
            } else if (this.iterator.hasNext()) {
                this.currentReader = new BufferedReader(new InputStreamReader(this.iterator.nextDocument()));
                this.fetchLines(this.linesToFetch);
            }
        }
        if (this.buffer.isEmpty()) {
            return null;
        }
        return this.buffer.poll();
    }

    @Override
    public boolean hasNext() {
        try {
            return !this.buffer.isEmpty() || this.iterator.hasNext() || this.currentReader != null && this.currentReader.ready();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void reset() {
        this.iterator.reset();
    }

    @Override
    public void finish() {
        this.buffer.clear();
    }

    @Override
    public SentencePreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    @Override
    public void setPreProcessor(SentencePreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public static class Builder {
        private DocumentIterator iterator;
        private int linesToFetch = 50;
        private SentencePreProcessor preProcessor;

        public Builder(final @NonNull InputStream stream) {
            this(new DocumentIterator(){
                private final InputStream onlyStream;
                private AtomicBoolean isConsumed;
                {
                    this.onlyStream = stream;
                    this.isConsumed = new AtomicBoolean(false);
                }

                @Override
                public boolean hasNext() {
                    return !this.isConsumed.get();
                }

                @Override
                public InputStream nextDocument() {
                    this.isConsumed.set(true);
                    return this.onlyStream;
                }

                @Override
                public void reset() {
                    this.isConsumed.set(false);
                    try {
                        this.onlyStream.reset();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
            });
            if (stream == null) {
                throw new NullPointerException("stream");
            }
        }

        public Builder(@NonNull DocumentIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator");
            }
            this.iterator = iterator;
        }

        public Builder setFetchSize(int linesToFetch) {
            this.linesToFetch = linesToFetch;
            return this;
        }

        public Builder setPreProcessor(SentencePreProcessor preProcessor) {
            this.preProcessor = preProcessor;
            return this;
        }

        public StreamLineIterator build() {
            StreamLineIterator lineIterator = new StreamLineIterator(this.iterator);
            lineIterator.linesToFetch = this.linesToFetch;
            lineIterator.setPreProcessor(this.preProcessor);
            return lineIterator;
        }
    }
}

