/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.paragraphvectors;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.deeplearning4j.berkeley.Counter;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.models.embeddings.WeightLookupTable;
import org.deeplearning4j.models.embeddings.inmemory.InMemoryLookupTable;
import org.deeplearning4j.models.embeddings.learning.ElementsLearningAlgorithm;
import org.deeplearning4j.models.embeddings.learning.SequenceLearningAlgorithm;
import org.deeplearning4j.models.embeddings.learning.impl.sequence.DM;
import org.deeplearning4j.models.embeddings.loader.VectorsConfiguration;
import org.deeplearning4j.models.embeddings.reader.ModelUtils;
import org.deeplearning4j.models.embeddings.reader.impl.BasicModelUtils;
import org.deeplearning4j.models.embeddings.wordvectors.WordVectors;
import org.deeplearning4j.models.sequencevectors.interfaces.SequenceIterator;
import org.deeplearning4j.models.sequencevectors.interfaces.VectorsListener;
import org.deeplearning4j.models.sequencevectors.iterators.AbstractSequenceIterator;
import org.deeplearning4j.models.sequencevectors.sequence.Sequence;
import org.deeplearning4j.models.sequencevectors.transformers.impl.SentenceTransformer;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.Word2Vec;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.text.documentiterator.DocumentIterator;
import org.deeplearning4j.text.documentiterator.LabelAwareDocumentIterator;
import org.deeplearning4j.text.documentiterator.LabelAwareIterator;
import org.deeplearning4j.text.documentiterator.LabelledDocument;
import org.deeplearning4j.text.documentiterator.LabelsSource;
import org.deeplearning4j.text.documentiterator.interoperability.DocumentIteratorConverter;
import org.deeplearning4j.text.invertedindex.InvertedIndex;
import org.deeplearning4j.text.sentenceiterator.SentenceIterator;
import org.deeplearning4j.text.sentenceiterator.interoperability.SentenceIteratorConverter;
import org.deeplearning4j.text.sentenceiterator.labelaware.LabelAwareSentenceIterator;
import org.deeplearning4j.text.tokenization.tokenizerfactory.TokenizerFactory;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;

public class ParagraphVectors
extends Word2Vec {
    private static final long serialVersionUID = 78249242142L;
    protected LabelsSource labelsSource;
    protected transient LabelAwareIterator labelAwareIterator;
    protected INDArray labelsMatrix;
    protected List<VocabWord> labelsList = new ArrayList<VocabWord>();
    protected boolean normalizedLabels = false;
    protected final transient Object inferenceLocker = new Object();
    protected transient ExecutorService inferenceExecutor;
    protected transient AtomicLong countSubmitted;
    protected transient AtomicLong countFinished;

    protected ParagraphVectors() {
    }

    protected synchronized void initInference() {
        if (this.countSubmitted == null || this.countFinished == null || this.inferenceExecutor == null) {
            this.inferenceExecutor = Executors.newFixedThreadPool(Math.max(Runtime.getRuntime().availableProcessors() - 2, 2), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setName("ParagraphVectors inference thread");
                    t.setDaemon(true);
                    return t;
                }
            });
            this.countSubmitted = new AtomicLong(0L);
            this.countFinished = new AtomicLong(0L);
        }
    }

    @Deprecated
    public String predict(String rawText) {
        if (this.tokenizerFactory == null) {
            throw new IllegalStateException("TokenizerFactory should be defined, prior to predict() call");
        }
        List<String> tokens = this.tokenizerFactory.create(rawText).getTokens();
        ArrayList<VocabWord> document = new ArrayList<VocabWord>();
        for (String token : tokens) {
            if (!this.vocab.containsWord(token)) continue;
            document.add((VocabWord)this.vocab.wordFor(token));
        }
        return this.predict(document);
    }

    @Override
    public void setSequenceIterator(@NonNull SequenceIterator<VocabWord> iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        this.iterator = iterator;
    }

    @Deprecated
    public String predict(LabelledDocument document) {
        if (document.getReferencedContent() != null) {
            return this.predict(document.getReferencedContent());
        }
        return this.predict(document.getContent());
    }

    public void extractLabels() {
        Collection vocabWordCollection = this.vocab.vocabWords();
        ArrayList<VocabWord> vocabWordList = new ArrayList<VocabWord>();
        for (VocabWord vWord : vocabWordCollection) {
            if (!vWord.isLabel()) continue;
            vocabWordList.add(vWord);
        }
        int[] indexArray = new int[vocabWordList.size()];
        int i = 0;
        for (VocabWord vWord : vocabWordList) {
            indexArray[i] = vWord.getIndex();
            ++i;
        }
        if (i > 0) {
            this.labelsMatrix = Nd4j.pullRows((INDArray)this.lookupTable.getWeights(), (int)1, (int[])indexArray);
            this.labelsList = vocabWordList;
        }
    }

    public INDArray inferVector(String text, double learningRate, double minLearningRate, int iterations) {
        if (this.tokenizerFactory == null) {
            throw new IllegalStateException("TokenizerFactory should be defined, prior to predict() call");
        }
        if (this.vocab == null || this.vocab.numWords() == 0) {
            this.reassignExistingModel();
        }
        List<String> tokens = this.tokenizerFactory.create(text).getTokens();
        ArrayList<VocabWord> document = new ArrayList<VocabWord>();
        for (String token : tokens) {
            if (!this.vocab.containsWord(token)) continue;
            document.add((VocabWord)this.vocab.wordFor(token));
        }
        if (document.isEmpty()) {
            throw new ND4JIllegalStateException("Text passed for inference has no matches in model vocabulary.");
        }
        return this.inferVector(document, learningRate, minLearningRate, iterations);
    }

    protected synchronized void reassignExistingModel() {
        if ((this.vocab == null || this.vocab.numWords() == 0) && this.existingModel != null) {
            this.vocab = this.existingModel.vocab();
            this.lookupTable = this.existingModel.lookupTable();
        }
    }

    public INDArray inferVector(LabelledDocument document, double learningRate, double minLearningRate, int iterations) {
        if (document.getReferencedContent() != null && !document.getReferencedContent().isEmpty()) {
            return this.inferVector(document.getReferencedContent(), learningRate, minLearningRate, iterations);
        }
        return this.inferVector(document.getContent(), learningRate, minLearningRate, iterations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INDArray inferVector(@NonNull List<VocabWord> document, double learningRate, double minLearningRate, int iterations) {
        DM<VocabWord> learner;
        if (document == null) {
            throw new NullPointerException("document");
        }
        if (this.vocab == null || this.vocab.numWords() == 0) {
            this.reassignExistingModel();
        }
        if ((learner = this.sequenceLearningAlgorithm) == null) {
            ParagraphVectors paragraphVectors = this;
            synchronized (paragraphVectors) {
                if (this.sequenceLearningAlgorithm == null) {
                    log.info("Creating new PV-DM learner...");
                    learner = new DM<VocabWord>();
                    learner.configure(this.vocab, this.lookupTable, this.configuration);
                    this.sequenceLearningAlgorithm = learner;
                } else {
                    learner = this.sequenceLearningAlgorithm;
                }
            }
        }
        learner = this.sequenceLearningAlgorithm;
        if (document.isEmpty()) {
            throw new ND4JIllegalStateException("Impossible to apply inference to empty list of words");
        }
        Sequence<VocabWord> sequence = new Sequence<VocabWord>();
        sequence.addElements(document);
        sequence.setSequenceLabel(new VocabWord(1.0, String.valueOf(new Random().nextInt())));
        this.initLearners();
        INDArray inf = learner.inferSequence(sequence, this.seed, learningRate, minLearningRate, iterations);
        return inf;
    }

    public INDArray inferVector(String text) {
        return this.inferVector(text, this.learningRate.get(), this.minLearningRate, this.numEpochs * this.numIterations);
    }

    public INDArray inferVector(LabelledDocument document) {
        return this.inferVector(document, this.learningRate.get(), this.minLearningRate, this.numEpochs * this.numIterations);
    }

    public INDArray inferVector(@NonNull List<VocabWord> document) {
        if (document == null) {
            throw new NullPointerException("document");
        }
        return this.inferVector(document, this.learningRate.get(), this.minLearningRate, this.numEpochs * this.numIterations);
    }

    public Future<Pair<String, INDArray>> inferVectorBatched(@NonNull LabelledDocument document) {
        if (document == null) {
            throw new NullPointerException("document");
        }
        if (this.countSubmitted == null) {
            this.initInference();
        }
        if (this.vocab == null || this.vocab.numWords() == 0) {
            this.reassignExistingModel();
        }
        while (this.countSubmitted.get() - this.countFinished.get() > 1024L) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        InferenceCallable callable = new InferenceCallable(this.vocab, this.tokenizerFactory, document);
        Future<Pair<String, INDArray>> future = this.inferenceExecutor.submit(callable);
        this.countSubmitted.incrementAndGet();
        return future;
    }

    public Future<INDArray> inferVectorBatched(@NonNull String document) {
        if (document == null) {
            throw new NullPointerException("document");
        }
        if (this.countSubmitted == null) {
            this.initInference();
        }
        if (this.vocab == null || this.vocab.numWords() == 0) {
            this.reassignExistingModel();
        }
        while (this.countSubmitted.get() - this.countFinished.get() > 1024L) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        BlindInferenceCallable callable = new BlindInferenceCallable(this.vocab, this.tokenizerFactory, document);
        Future<INDArray> future = this.inferenceExecutor.submit(callable);
        this.countSubmitted.incrementAndGet();
        return future;
    }

    public List<INDArray> inferVectorBatched(@NonNull List<String> documents) {
        int i;
        if (documents == null) {
            throw new NullPointerException("documents");
        }
        if (this.countSubmitted == null) {
            this.initInference();
        }
        if (this.vocab == null || this.vocab.numWords() == 0) {
            this.reassignExistingModel();
        }
        ArrayList<Future<INDArray>> futuresList = new ArrayList<Future<INDArray>>();
        ArrayList<INDArray> results = new ArrayList<INDArray>();
        AtomicLong flag = new AtomicLong(0L);
        for (i = 0; i < documents.size(); ++i) {
            BlindInferenceCallable callable = new BlindInferenceCallable(this.vocab, this.tokenizerFactory, documents.get(i), flag);
            futuresList.add(this.inferenceExecutor.submit(callable));
        }
        for (i = 0; i < documents.size(); ++i) {
            Future future = (Future)futuresList.get(i);
            while (!future.isDone()) {
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {}
            }
            try {
                results.add((INDArray)future.get());
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return results;
    }

    @Deprecated
    public String predict(List<VocabWord> document) {
        if (document.isEmpty()) {
            throw new IllegalStateException("Document has no words inside");
        }
        INDArray arr = Nd4j.create((int)document.size(), (int)this.layerSize);
        for (int i = 0; i < document.size(); ++i) {
            arr.putRow(i, this.getWordVectorMatrix(document.get(i).getWord()));
        }
        INDArray docMean = arr.mean(new int[]{0});
        Counter distances = new Counter();
        for (String s : this.labelsSource.getLabels()) {
            INDArray otherVec = this.getWordVectorMatrix(s);
            double sim = Transforms.cosineSim((INDArray)docMean, (INDArray)otherVec);
            distances.incrementCount((Object)s, (float)sim);
        }
        return (String)distances.argMax();
    }

    @Deprecated
    public Collection<String> predictSeveral(@NonNull LabelledDocument document, int limit) {
        if (document == null) {
            throw new NullPointerException("document");
        }
        if (document.getReferencedContent() != null) {
            return this.predictSeveral(document.getReferencedContent(), limit);
        }
        return this.predictSeveral(document.getContent(), limit);
    }

    @Deprecated
    public Collection<String> predictSeveral(String rawText, int limit) {
        if (this.tokenizerFactory == null) {
            throw new IllegalStateException("TokenizerFactory should be defined, prior to predict() call");
        }
        List<String> tokens = this.tokenizerFactory.create(rawText).getTokens();
        ArrayList<VocabWord> document = new ArrayList<VocabWord>();
        for (String token : tokens) {
            if (!this.vocab.containsWord(token)) continue;
            document.add((VocabWord)this.vocab.wordFor(token));
        }
        return this.predictSeveral(document, limit);
    }

    @Deprecated
    public Collection<String> predictSeveral(List<VocabWord> document, int limit) {
        if (document.isEmpty()) {
            throw new IllegalStateException("Document has no words inside");
        }
        INDArray arr = Nd4j.create((int)document.size(), (int)this.layerSize);
        for (int i = 0; i < document.size(); ++i) {
            arr.putRow(i, this.getWordVectorMatrix(document.get(i).getWord()));
        }
        INDArray docMean = arr.mean(new int[]{0});
        Counter distances = new Counter();
        for (String s : this.labelsSource.getLabels()) {
            INDArray otherVec = this.getWordVectorMatrix(s);
            double sim = Transforms.cosineSim((INDArray)docMean, (INDArray)otherVec);
            log.debug("Similarity inside: [" + s + "] -> " + sim);
            distances.incrementCount((Object)s, (float)sim);
        }
        return distances.getSortedKeys().subList(0, limit);
    }

    public Collection<String> nearestLabels(LabelledDocument document, int topN) {
        if (document.getReferencedContent() != null) {
            return this.nearestLabels(document.getReferencedContent(), topN);
        }
        return this.nearestLabels(document.getContent(), topN);
    }

    public Collection<String> nearestLabels(@NonNull String rawText, int topN) {
        if (rawText == null) {
            throw new NullPointerException("rawText");
        }
        List<String> tokens = this.tokenizerFactory.create(rawText).getTokens();
        ArrayList<VocabWord> document = new ArrayList<VocabWord>();
        for (String token : tokens) {
            if (!this.vocab.containsWord(token)) continue;
            document.add((VocabWord)this.vocab.wordFor(token));
        }
        if (document.isEmpty()) {
            log.info("Document passed to nearestLabels() has no matches in model vocabulary");
            return new ArrayList<String>();
        }
        return this.nearestLabels(document, topN);
    }

    public Collection<String> nearestLabels(@NonNull Collection<VocabWord> document, int topN) {
        if (document == null) {
            throw new NullPointerException("document");
        }
        if (document.isEmpty()) {
            throw new ND4JIllegalStateException("Impossible to get nearestLabels for empty list of words");
        }
        INDArray vector = this.inferVector(new ArrayList<VocabWord>(document));
        return this.nearestLabels(vector, topN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> nearestLabels(INDArray labelVector, int topN) {
        if (this.labelsMatrix == null || this.labelsList == null || this.labelsList.isEmpty()) {
            this.extractLabels();
        }
        ArrayList<BasicModelUtils.WordSimilarity> result = new ArrayList<BasicModelUtils.WordSimilarity>();
        if (this.labelsMatrix == null || this.labelsList == null || this.labelsList.isEmpty()) {
            log.warn("Labels list is empty!");
            return new ArrayList<String>();
        }
        if (!this.normalizedLabels) {
            ParagraphVectors paragraphVectors = this;
            synchronized (paragraphVectors) {
                if (!this.normalizedLabels) {
                    this.labelsMatrix.diviColumnVector(this.labelsMatrix.norm1(new int[]{1}));
                    this.normalizedLabels = true;
                }
            }
        }
        INDArray similarity = Transforms.unitVec((INDArray)labelVector).mmul(this.labelsMatrix.transpose());
        List<Double> highToLowSimList = this.getTopN(similarity, topN + 20);
        for (int i = 0; i < highToLowSimList.size(); ++i) {
            String word = this.labelsList.get(highToLowSimList.get(i).intValue()).getLabel();
            if (word == null || word.equals("UNK") || word.equals("STOP")) continue;
            INDArray otherVec = this.lookupTable.vector(word);
            double sim = Transforms.cosineSim((INDArray)labelVector, (INDArray)otherVec);
            result.add(new BasicModelUtils.WordSimilarity(word, sim));
        }
        Collections.sort(result, new BasicModelUtils.SimilarityComparator());
        return BasicModelUtils.getLabels(result, topN);
    }

    private List<Double> getTopN(INDArray vec, int N) {
        BasicModelUtils.ArrayComparator comparator = new BasicModelUtils.ArrayComparator();
        PriorityQueue<Double[]> queue = new PriorityQueue<Double[]>(vec.rows(), comparator);
        for (int j = 0; j < vec.length(); ++j) {
            Double[] pair = new Double[]{vec.getDouble(j), j};
            if (queue.size() < N) {
                queue.add(pair);
                continue;
            }
            Double[] head = queue.peek();
            if (comparator.compare(pair, head) <= 0) continue;
            queue.poll();
            queue.add(pair);
        }
        ArrayList<Double> lowToHighSimLst = new ArrayList<Double>();
        while (!queue.isEmpty()) {
            double ind = queue.poll()[1];
            lowToHighSimLst.add(ind);
        }
        return Lists.reverse(lowToHighSimLst);
    }

    @Deprecated
    public double similarityToLabel(String rawText, String label) {
        if (this.tokenizerFactory == null) {
            throw new IllegalStateException("TokenizerFactory should be defined, prior to predict() call");
        }
        List<String> tokens = this.tokenizerFactory.create(rawText).getTokens();
        ArrayList<VocabWord> document = new ArrayList<VocabWord>();
        for (String token : tokens) {
            if (!this.vocab.containsWord(token)) continue;
            document.add((VocabWord)this.vocab.wordFor(token));
        }
        return this.similarityToLabel(document, label);
    }

    @Override
    public void fit() {
        super.fit();
        this.extractLabels();
    }

    @Deprecated
    public double similarityToLabel(LabelledDocument document, String label) {
        if (document.getReferencedContent() != null) {
            return this.similarityToLabel(document.getReferencedContent(), label);
        }
        return this.similarityToLabel(document.getContent(), label);
    }

    @Deprecated
    public double similarityToLabel(List<VocabWord> document, String label) {
        if (document.isEmpty()) {
            throw new IllegalStateException("Document has no words inside");
        }
        INDArray arr = Nd4j.create((int)document.size(), (int)this.layerSize);
        for (int i = 0; i < document.size(); ++i) {
            arr.putRow(i, this.getWordVectorMatrix(document.get(i).getWord()));
        }
        INDArray docMean = arr.mean(new int[]{0});
        INDArray otherVec = this.getWordVectorMatrix(label);
        double sim = Transforms.cosineSim((INDArray)docMean, (INDArray)otherVec);
        return sim;
    }

    public LabelsSource getLabelsSource() {
        return this.labelsSource;
    }

    public LabelAwareIterator getLabelAwareIterator() {
        return this.labelAwareIterator;
    }

    public void setLabelAwareIterator(LabelAwareIterator labelAwareIterator) {
        this.labelAwareIterator = labelAwareIterator;
    }

    public class BlindInferenceCallable
    implements Callable<INDArray> {
        private final TokenizerFactory tokenizerFactory;
        private final VocabCache<VocabWord> vocab;
        private final String document;
        private AtomicLong flag;

        public BlindInferenceCallable(@NonNull VocabCache<VocabWord> vocabCache, @NonNull TokenizerFactory tokenizerFactory, String document) {
            if (vocabCache == null) {
                throw new NullPointerException("vocabCache");
            }
            if (tokenizerFactory == null) {
                throw new NullPointerException("tokenizerFactory");
            }
            if (document == null) {
                throw new NullPointerException("document");
            }
            this.tokenizerFactory = tokenizerFactory;
            this.vocab = vocabCache;
            this.document = document;
        }

        public BlindInferenceCallable(@NonNull VocabCache<VocabWord> vocabCache, @NonNull TokenizerFactory tokenizerFactory, @NonNull String document, AtomicLong flag) {
            this(vocabCache, tokenizerFactory, document);
            if (vocabCache == null) {
                throw new NullPointerException("vocabCache");
            }
            if (tokenizerFactory == null) {
                throw new NullPointerException("tokenizerFactory");
            }
            if (document == null) {
                throw new NullPointerException("document");
            }
            if (flag == null) {
                throw new NullPointerException("flag");
            }
            this.flag = flag;
        }

        @Override
        public INDArray call() throws Exception {
            List<String> tokens = this.tokenizerFactory.create(this.document).getTokens();
            ArrayList<VocabWord> documentAsWords = new ArrayList<VocabWord>();
            for (String token : tokens) {
                if (!this.vocab.containsWord(token)) continue;
                documentAsWords.add(this.vocab.wordFor(token));
            }
            if (documentAsWords.isEmpty()) {
                throw new ND4JIllegalStateException("Text passed for inference has no matches in model vocabulary.");
            }
            INDArray result = ParagraphVectors.this.inferVector(documentAsWords);
            ParagraphVectors.this.countFinished.incrementAndGet();
            if (this.flag != null) {
                this.flag.incrementAndGet();
            }
            return result;
        }
    }

    public class InferenceCallable
    implements Callable<Pair<String, INDArray>> {
        private final TokenizerFactory tokenizerFactory;
        private final VocabCache<VocabWord> vocab;
        private final LabelledDocument document;
        private AtomicLong flag;

        public InferenceCallable(@NonNull VocabCache<VocabWord> vocabCache, @NonNull TokenizerFactory tokenizerFactory, LabelledDocument document) {
            if (vocabCache == null) {
                throw new NullPointerException("vocabCache");
            }
            if (tokenizerFactory == null) {
                throw new NullPointerException("tokenizerFactory");
            }
            if (document == null) {
                throw new NullPointerException("document");
            }
            this.tokenizerFactory = tokenizerFactory;
            this.vocab = vocabCache;
            this.document = document;
        }

        public InferenceCallable(@NonNull VocabCache<VocabWord> vocabCache, @NonNull TokenizerFactory tokenizerFactory, @NonNull LabelledDocument document, AtomicLong flag) {
            this(vocabCache, tokenizerFactory, document);
            if (vocabCache == null) {
                throw new NullPointerException("vocabCache");
            }
            if (tokenizerFactory == null) {
                throw new NullPointerException("tokenizerFactory");
            }
            if (document == null) {
                throw new NullPointerException("document");
            }
            if (flag == null) {
                throw new NullPointerException("flag");
            }
            this.flag = flag;
        }

        @Override
        public Pair<String, INDArray> call() throws Exception {
            List<String> tokens = this.tokenizerFactory.create(this.document.getContent()).getTokens();
            ArrayList<VocabWord> documentAsWords = new ArrayList<VocabWord>();
            for (String token : tokens) {
                if (!this.vocab.containsWord(token)) continue;
                documentAsWords.add(this.vocab.wordFor(token));
            }
            if (documentAsWords.isEmpty()) {
                throw new ND4JIllegalStateException("Text passed for inference has no matches in model vocabulary.");
            }
            Pair result = Pair.makePair((Object)this.document.getId(), (Object)ParagraphVectors.this.inferVector(documentAsWords));
            ParagraphVectors.this.countFinished.incrementAndGet();
            if (this.flag != null) {
                this.flag.incrementAndGet();
            }
            return result;
        }
    }

    public static class Builder
    extends Word2Vec.Builder {
        protected LabelAwareIterator labelAwareIterator;
        protected LabelsSource labelsSource;
        protected DocumentIterator docIter;

        @Override
        public Builder useExistingWordVectors(@NonNull WordVectors vec) {
            if (vec == null) {
                throw new NullPointerException("vec");
            }
            if (((InMemoryLookupTable)vec.lookupTable()).getSyn1() == null && ((InMemoryLookupTable)vec.lookupTable()).getSyn1Neg() == null) {
                throw new ND4JIllegalStateException("Model being passed as existing has no syn1/syn1Neg available");
            }
            this.existingVectors = vec;
            return this;
        }

        public Builder trainWordVectors(boolean trainElements) {
            this.trainElementsRepresentation(trainElements);
            return this;
        }

        public Builder labelsSource(@NonNull LabelsSource source) {
            if (source == null) {
                throw new NullPointerException("source");
            }
            this.labelsSource = source;
            return this;
        }

        @Deprecated
        public Builder labels(@NonNull List<String> labels) {
            if (labels == null) {
                throw new NullPointerException("labels");
            }
            this.labelsSource = new LabelsSource(labels);
            return this;
        }

        public Builder iterate(@NonNull LabelAwareDocumentIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator");
            }
            this.docIter = iterator;
            return this;
        }

        public Builder iterate(@NonNull LabelAwareSentenceIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator");
            }
            this.sentenceIterator = iterator;
            return this;
        }

        @Override
        public Builder iterate(@NonNull LabelAwareIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator");
            }
            this.labelAwareIterator = iterator;
            return this;
        }

        @Override
        public Builder iterate(@NonNull DocumentIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator");
            }
            this.docIter = iterator;
            return this;
        }

        @Override
        public Builder iterate(@NonNull SentenceIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator");
            }
            this.sentenceIterator = iterator;
            return this;
        }

        @Override
        public Builder modelUtils(@NonNull ModelUtils<VocabWord> modelUtils) {
            if (modelUtils == null) {
                throw new NullPointerException("modelUtils");
            }
            super.modelUtils((ModelUtils)modelUtils);
            return this;
        }

        @Override
        public Builder unknownElement(VocabWord element) {
            super.unknownElement(element);
            return this;
        }

        @Override
        public Builder allowParallelTokenization(boolean allow) {
            super.allowParallelTokenization(allow);
            return this;
        }

        @Override
        public Builder useUnknown(boolean reallyUse) {
            super.useUnknown(reallyUse);
            if (this.unknownElement == null) {
                this.unknownElement(new VocabWord(1.0, "UNK"));
            }
            return this;
        }

        @Override
        public Builder enableScavenger(boolean reallyEnable) {
            super.enableScavenger(reallyEnable);
            return this;
        }

        @Override
        public ParagraphVectors build() {
            this.presetTables();
            ParagraphVectors ret = new ParagraphVectors();
            if (this.existingVectors != null) {
                this.trainWordVectors(false);
                this.trainElementsRepresentation(false);
                this.elementsLearningAlgorithm = null;
            }
            if (this.labelsSource == null) {
                this.labelsSource = new LabelsSource();
            }
            if (this.docIter != null) {
                this.labelAwareIterator = this.docIter instanceof LabelAwareDocumentIterator ? new DocumentIteratorConverter((LabelAwareDocumentIterator)this.docIter, this.labelsSource) : new DocumentIteratorConverter(this.docIter, this.labelsSource);
            } else if (this.sentenceIterator != null) {
                this.labelAwareIterator = this.sentenceIterator instanceof LabelAwareSentenceIterator ? new SentenceIteratorConverter((LabelAwareSentenceIterator)this.sentenceIterator, this.labelsSource) : new SentenceIteratorConverter(this.sentenceIterator, this.labelsSource);
            } else if (this.labelAwareIterator != null) {
                this.labelsSource = this.labelAwareIterator.getLabelsSource();
            }
            if (this.labelAwareIterator != null) {
                SentenceTransformer transformer = new SentenceTransformer.Builder().iterator(this.labelAwareIterator).tokenizerFactory(this.tokenizerFactory).allowMultithreading(this.allowParallelTokenization).build();
                this.iterator = new AbstractSequenceIterator.Builder<VocabWord>(transformer).build();
            }
            ret.numEpochs = this.numEpochs;
            ret.numIterations = this.iterations;
            ret.vocab = this.vocabCache;
            ret.minWordFrequency = this.minWordFrequency;
            ret.learningRate.set(this.learningRate);
            ret.minLearningRate = this.minLearningRate;
            ret.sampling = this.sampling;
            ret.negative = this.negative;
            ret.layerSize = this.layerSize;
            ret.batchSize = this.batchSize;
            ret.learningRateDecayWords = this.learningRateDecayWords;
            ret.window = this.window;
            ret.resetModel = this.resetModel;
            ret.useAdeGrad = this.useAdaGrad;
            ret.stopWords = this.stopWords;
            ret.workers = this.workers;
            ret.useUnknown = this.useUnknown;
            ret.unknownElement = this.unknownElement;
            ret.seed = this.seed;
            ret.enableScavenger = this.enableScavenger;
            ret.trainElementsVectors = this.trainElementsVectors;
            ret.trainSequenceVectors = this.trainSequenceVectors;
            ret.elementsLearningAlgorithm = this.elementsLearningAlgorithm;
            ret.sequenceLearningAlgorithm = this.sequenceLearningAlgorithm;
            ret.tokenizerFactory = this.tokenizerFactory;
            ret.existingModel = this.existingVectors;
            ret.lookupTable = this.lookupTable;
            ret.modelUtils = this.modelUtils;
            ret.eventListeners = this.vectorsListeners;
            this.configuration.setLearningRate(this.learningRate);
            this.configuration.setLayersSize(this.layerSize);
            this.configuration.setHugeModelExpected(this.hugeModelExpected);
            this.configuration.setWindow(this.window);
            this.configuration.setMinWordFrequency(this.minWordFrequency);
            this.configuration.setIterations(this.iterations);
            this.configuration.setSeed(this.seed);
            this.configuration.setBatchSize(this.batchSize);
            this.configuration.setLearningRateDecayWords(this.learningRateDecayWords);
            this.configuration.setMinLearningRate(this.minLearningRate);
            this.configuration.setSampling(this.sampling);
            this.configuration.setUseAdaGrad(this.useAdaGrad);
            this.configuration.setNegative(this.negative);
            this.configuration.setEpochs(this.numEpochs);
            this.configuration.setStopList(this.stopWords);
            this.configuration.setUseHierarchicSoftmax(this.useHierarchicSoftmax);
            this.configuration.setTrainElementsVectors(this.trainElementsVectors);
            this.configuration.setPreciseWeightInit(this.preciseWeightInit);
            this.configuration.setSequenceLearningAlgorithm(this.sequenceLearningAlgorithm.getClass().getCanonicalName());
            this.configuration.setModelUtils(this.modelUtils.getClass().getCanonicalName());
            this.configuration.setAllowParallelTokenization(this.allowParallelTokenization);
            if (this.tokenizerFactory != null) {
                this.configuration.setTokenizerFactory(this.tokenizerFactory.getClass().getCanonicalName());
                if (this.tokenizerFactory.getTokenPreProcessor() != null) {
                    this.configuration.setTokenPreProcessor(this.tokenizerFactory.getTokenPreProcessor().getClass().getCanonicalName());
                }
            }
            ret.configuration = this.configuration;
            ret.trainElementsVectors = this.trainElementsVectors;
            ret.trainSequenceVectors = true;
            ret.labelsSource = this.labelsSource;
            ret.labelAwareIterator = this.labelAwareIterator;
            ret.iterator = this.iterator;
            return ret;
        }

        public Builder() {
        }

        public Builder(@NonNull VectorsConfiguration configuration) {
            super(configuration);
            if (configuration == null) {
                throw new NullPointerException("configuration");
            }
        }

        @Override
        public Builder tokenizerFactory(@NonNull TokenizerFactory tokenizerFactory) {
            if (tokenizerFactory == null) {
                throw new NullPointerException("tokenizerFactory");
            }
            super.tokenizerFactory(tokenizerFactory);
            return this;
        }

        @Override
        public Builder index(@NonNull InvertedIndex<VocabWord> index) {
            if (index == null) {
                throw new NullPointerException("index");
            }
            super.index(index);
            return this;
        }

        @Override
        public Builder iterate(@NonNull SequenceIterator<VocabWord> iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator");
            }
            super.iterate((SequenceIterator)iterator);
            return this;
        }

        @Override
        public Builder batchSize(int batchSize) {
            super.batchSize(batchSize);
            return this;
        }

        @Override
        public Builder iterations(int iterations) {
            super.iterations(iterations);
            return this;
        }

        @Override
        public Builder epochs(int numEpochs) {
            super.epochs(numEpochs);
            return this;
        }

        @Override
        public Builder layerSize(int layerSize) {
            super.layerSize(layerSize);
            return this;
        }

        @Override
        public Builder setVectorsListeners(@NonNull Collection<VectorsListener<VocabWord>> vectorsListeners) {
            if (vectorsListeners == null) {
                throw new NullPointerException("vectorsListeners");
            }
            super.setVectorsListeners((Collection)vectorsListeners);
            return this;
        }

        @Override
        public Builder learningRate(double learningRate) {
            super.learningRate(learningRate);
            return this;
        }

        @Override
        public Builder minWordFrequency(int minWordFrequency) {
            super.minWordFrequency(minWordFrequency);
            return this;
        }

        @Override
        public Builder minLearningRate(double minLearningRate) {
            super.minLearningRate(minLearningRate);
            return this;
        }

        @Override
        public Builder resetModel(boolean reallyReset) {
            super.resetModel(reallyReset);
            return this;
        }

        @Override
        public Builder vocabCache(@NonNull VocabCache<VocabWord> vocabCache) {
            if (vocabCache == null) {
                throw new NullPointerException("vocabCache");
            }
            super.vocabCache((VocabCache)vocabCache);
            return this;
        }

        @Override
        public Builder lookupTable(@NonNull WeightLookupTable<VocabWord> lookupTable) {
            if (lookupTable == null) {
                throw new NullPointerException("lookupTable");
            }
            super.lookupTable((WeightLookupTable)lookupTable);
            return this;
        }

        @Override
        public Builder sampling(double sampling) {
            super.sampling(sampling);
            return this;
        }

        @Override
        public Builder useAdaGrad(boolean reallyUse) {
            super.useAdaGrad(reallyUse);
            return this;
        }

        @Override
        public Builder negativeSample(double negative) {
            super.negativeSample(negative);
            return this;
        }

        @Override
        public Builder stopWords(@NonNull List<String> stopList) {
            if (stopList == null) {
                throw new NullPointerException("stopList");
            }
            super.stopWords((List)stopList);
            return this;
        }

        @Override
        public Builder trainElementsRepresentation(boolean trainElements) {
            this.trainElementsVectors = trainElements;
            return this;
        }

        @Override
        public Builder trainSequencesRepresentation(boolean trainSequences) {
            this.trainSequenceVectors = trainSequences;
            return this;
        }

        @Override
        public Builder stopWords(@NonNull Collection<VocabWord> stopList) {
            if (stopList == null) {
                throw new NullPointerException("stopList");
            }
            super.stopWords((Collection)stopList);
            return this;
        }

        @Override
        public Builder windowSize(int windowSize) {
            super.windowSize(windowSize);
            return this;
        }

        @Override
        public Builder workers(int numWorkers) {
            super.workers(numWorkers);
            return this;
        }

        public Builder sequenceLearningAlgorithm(SequenceLearningAlgorithm<VocabWord> algorithm) {
            super.sequenceLearningAlgorithm(algorithm);
            return this;
        }

        public Builder sequenceLearningAlgorithm(String algorithm) {
            super.sequenceLearningAlgorithm(algorithm);
            return this;
        }

        @Override
        public Builder useHierarchicSoftmax(boolean reallyUse) {
            super.useHierarchicSoftmax(reallyUse);
            return this;
        }

        @Override
        public Builder useVariableWindow(int ... windows) {
            return this;
        }

        @Override
        public Builder elementsLearningAlgorithm(ElementsLearningAlgorithm<VocabWord> algorithm) {
            super.elementsLearningAlgorithm((ElementsLearningAlgorithm)algorithm);
            return this;
        }

        @Override
        public Builder elementsLearningAlgorithm(String algorithm) {
            super.elementsLearningAlgorithm(algorithm);
            return this;
        }

        @Override
        public Builder usePreciseWeightInit(boolean reallyUse) {
            super.usePreciseWeightInit(reallyUse);
            return this;
        }

        @Override
        public Builder seed(long randomSeed) {
            super.seed(randomSeed);
            return this;
        }
    }
}

