/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.bagofwords.vectorizer;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.deeplearning4j.bagofwords.vectorizer.BaseTextVectorizer;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.models.word2vec.wordstore.inmemory.AbstractCache;
import org.deeplearning4j.text.documentiterator.DocumentIterator;
import org.deeplearning4j.text.documentiterator.LabelAwareIterator;
import org.deeplearning4j.text.documentiterator.LabelsSource;
import org.deeplearning4j.text.documentiterator.interoperability.DocumentIteratorConverter;
import org.deeplearning4j.text.sentenceiterator.SentenceIterator;
import org.deeplearning4j.text.sentenceiterator.interoperability.SentenceIteratorConverter;
import org.deeplearning4j.text.tokenization.tokenizer.Tokenizer;
import org.deeplearning4j.text.tokenization.tokenizerfactory.TokenizerFactory;
import org.deeplearning4j.util.MathUtils;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.FeatureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TfidfVectorizer
extends BaseTextVectorizer {
    private static final Logger log = LoggerFactory.getLogger(TfidfVectorizer.class);

    @Override
    public DataSet vectorize(InputStream is, String label) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String line = "";
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            return this.vectorize(builder.toString(), label);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DataSet vectorize(String text, String label) {
        INDArray input = this.transform(text);
        INDArray labelMatrix = FeatureUtil.toOutcomeVector((int)this.labelsSource.indexOf(label), (int)this.labelsSource.size());
        return new DataSet(input, labelMatrix);
    }

    @Override
    public DataSet vectorize(File input, String label) {
        try {
            String string = FileUtils.readFileToString((File)input);
            return this.vectorize(string, label);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public INDArray transform(String text) {
        Tokenizer tokenizer = this.tokenizerFactory.create(text);
        List<String> tokens = tokenizer.getTokens();
        return this.transform(tokens);
    }

    @Override
    public INDArray transform(List<String> tokens) {
        INDArray ret = Nd4j.create((int)1, (int)this.vocabCache.numWords());
        HashMap<String, AtomicLong> counts = new HashMap<String, AtomicLong>();
        for (String token : tokens) {
            if (!counts.containsKey(token)) {
                counts.put(token, new AtomicLong(0L));
            }
            ((AtomicLong)counts.get(token)).incrementAndGet();
        }
        for (int i = 0; i < tokens.size(); ++i) {
            int idx = this.vocabCache.indexOf(tokens.get(i));
            if (idx < 0) continue;
            double tf_idf = this.tfidfWord(tokens.get(i), ((AtomicLong)counts.get(tokens.get(i))).longValue(), tokens.size());
            ret.putScalar(idx, tf_idf);
        }
        return ret;
    }

    public double tfidfWord(String word, long wordCount, long documentLength) {
        return MathUtils.tfidf((double)this.tfForWord(wordCount, documentLength), (double)this.idfForWord(word));
    }

    private double tfForWord(long wordCount, long documentLength) {
        return (double)wordCount / (double)documentLength;
    }

    private double idfForWord(String word) {
        return MathUtils.idf((double)this.vocabCache.totalNumberOfDocs(), (double)this.vocabCache.docAppearedIn(word));
    }

    public DataSet vectorize() {
        return null;
    }

    public static class Builder {
        protected TokenizerFactory tokenizerFactory;
        protected LabelAwareIterator iterator;
        protected int minWordFrequency;
        protected VocabCache<VocabWord> vocabCache;
        protected LabelsSource labelsSource = new LabelsSource();
        protected Collection<String> stopWords = new ArrayList<String>();
        protected boolean isParallel = true;

        public Builder allowParallelTokenization(boolean reallyAllow) {
            this.isParallel = reallyAllow;
            return this;
        }

        public Builder setTokenizerFactory(@NonNull TokenizerFactory tokenizerFactory) {
            if (tokenizerFactory == null) {
                throw new NullPointerException("tokenizerFactory");
            }
            this.tokenizerFactory = tokenizerFactory;
            return this;
        }

        public Builder setIterator(@NonNull LabelAwareIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator");
            }
            this.iterator = iterator;
            return this;
        }

        public Builder setIterator(@NonNull DocumentIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator");
            }
            this.iterator = new DocumentIteratorConverter(iterator, this.labelsSource);
            return this;
        }

        public Builder setIterator(@NonNull SentenceIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator");
            }
            this.iterator = new SentenceIteratorConverter(iterator, this.labelsSource);
            return this;
        }

        public Builder setVocab(@NonNull VocabCache<VocabWord> vocab) {
            if (vocab == null) {
                throw new NullPointerException("vocab");
            }
            this.vocabCache = vocab;
            return this;
        }

        public Builder setMinWordFrequency(int minWordFrequency) {
            this.minWordFrequency = minWordFrequency;
            return this;
        }

        public Builder setStopWords(Collection<String> stopWords) {
            this.stopWords = stopWords;
            return this;
        }

        public TfidfVectorizer build() {
            TfidfVectorizer vectorizer = new TfidfVectorizer();
            vectorizer.tokenizerFactory = this.tokenizerFactory;
            vectorizer.iterator = this.iterator;
            vectorizer.minWordFrequency = this.minWordFrequency;
            vectorizer.labelsSource = this.labelsSource;
            vectorizer.isParallel = this.isParallel;
            if (this.vocabCache == null) {
                this.vocabCache = new AbstractCache.Builder().build();
            }
            vectorizer.vocabCache = this.vocabCache;
            vectorizer.stopWords = this.stopWords;
            return vectorizer;
        }
    }
}

