/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.glove.count;

import java.io.File;
import java.io.PrintWriter;
import lombok.NonNull;
import org.deeplearning4j.models.glove.count.CoOccurenceReader;
import org.deeplearning4j.models.glove.count.CoOccurrenceWeight;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.text.sentenceiterator.BasicLineIterator;
import org.deeplearning4j.text.sentenceiterator.PrefetchingSentenceIterator;
import org.deeplearning4j.text.sentenceiterator.SentenceIterator;

public class ASCIICoOccurrenceReader<T extends SequenceElement>
implements CoOccurenceReader<T> {
    private File file;
    private PrintWriter writer;
    private SentenceIterator iterator;
    private VocabCache<T> vocabCache;

    public ASCIICoOccurrenceReader(@NonNull File file, @NonNull VocabCache<T> vocabCache) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (vocabCache == null) {
            throw new NullPointerException("vocabCache");
        }
        this.vocabCache = vocabCache;
        this.file = file;
        try {
            this.iterator = new PrefetchingSentenceIterator.Builder(new BasicLineIterator(file)).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasMoreObjects() {
        return this.iterator.hasNext();
    }

    @Override
    public CoOccurrenceWeight<T> nextObject() {
        String line = this.iterator.nextSentence();
        if (line == null || line.isEmpty()) {
            return null;
        }
        String[] strings = line.split(" ");
        CoOccurrenceWeight<T> object = new CoOccurrenceWeight<T>();
        object.setElement1(this.vocabCache.elementAtIndex(Integer.valueOf(strings[0])));
        object.setElement2(this.vocabCache.elementAtIndex(Integer.valueOf(strings[1])));
        object.setWeight(Double.parseDouble(strings[2]));
        return object;
    }

    @Override
    public void finish() {
        try {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

