/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.sequencevectors.sequence;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.util.concurrent.AtomicDouble;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.AdaGrad;

public abstract class SequenceElement
implements Comparable<SequenceElement>,
Serializable {
    private static final long serialVersionUID = 2223750736522624732L;
    protected AtomicDouble elementFrequency = new AtomicDouble(0.0);
    protected int index = -1;
    protected List<Integer> codes = new ArrayList<Integer>();
    protected INDArray historicalGradient;
    protected List<Integer> points = new ArrayList<Integer>();
    protected int codeLength = 0;
    protected boolean special;
    protected boolean isLabel;
    protected AtomicLong sequencesCount = new AtomicLong(0L);
    protected AdaGrad adaGrad;
    protected Long storageId;

    public abstract String getLabel();

    public long getSequencesCount() {
        return this.sequencesCount.get();
    }

    public void setSequencesCount(long count) {
        this.sequencesCount.set(count);
    }

    public void incrementSequencesCount() {
        this.sequencesCount.incrementAndGet();
    }

    public void incrementSequencesCount(long count) {
        this.sequencesCount.addAndGet(count);
    }

    public boolean isLabel() {
        return this.isLabel;
    }

    public void markAsLabel(boolean isLabel) {
        this.isLabel = isLabel;
    }

    public double getElementFrequency() {
        return this.elementFrequency.get();
    }

    public void setElementFrequency(long value) {
        this.elementFrequency.set((double)value);
    }

    public void incrementElementFrequency() {
        this.increaseElementFrequency(1);
    }

    public void increaseElementFrequency(int by) {
        this.elementFrequency.getAndAdd((double)by);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof SequenceElement)) {
            return false;
        }
        return this.getLabel().equals(((SequenceElement)object).getLabel());
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public List<Integer> getCodes() {
        return this.codes;
    }

    public void setCodes(List<Integer> codes) {
        this.codes = codes;
    }

    public List<Integer> getPoints() {
        return this.points;
    }

    public void setPoints(List<Integer> points) {
        this.points = points;
    }

    @JsonIgnore
    public void setPoints(int[] points) {
        this.points = new ArrayList<Integer>();
        for (int i = 0; i < points.length; ++i) {
            this.points.add(points[i]);
        }
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public void setCodeLength(int codeLength) {
        int i;
        this.codeLength = codeLength;
        if (this.codes.size() < codeLength) {
            for (i = 0; i < codeLength; ++i) {
                this.codes.add(0);
            }
        }
        if (this.points.size() < codeLength) {
            for (i = 0; i < codeLength; ++i) {
                this.points.add(0);
            }
        }
    }

    public double getGradient(int index, double g, double lr) {
        if (this.adaGrad == null) {
            this.adaGrad = new AdaGrad(1, this.getCodeLength(), lr);
        }
        return this.adaGrad.getGradient(g, index, new int[]{1, this.getCodeLength()});
    }

    public void setHistoricalGradient(INDArray gradient) {
        if (this.adaGrad == null) {
            this.adaGrad = new AdaGrad(1, this.getCodeLength(), 0.025);
        }
        this.adaGrad.setHistoricalGradient(gradient);
    }

    public INDArray getHistoricalGradient() {
        if (this.adaGrad == null) {
            this.adaGrad = new AdaGrad(1, this.getCodeLength(), 0.025);
        }
        return this.adaGrad.getHistoricalGradient();
    }

    public int hashCode() {
        if (this.getLabel() == null) {
            throw new IllegalStateException("Label should not be null");
        }
        return this.getLabel().hashCode();
    }

    @Override
    public int compareTo(SequenceElement o) {
        return Double.compare(this.elementFrequency.get(), o.elementFrequency.get());
    }

    public String toString() {
        return "SequenceElement: {label: '" + this.getLabel() + "', freq: '" + this.elementFrequency.get() + "', codes: " + this.codes.toString() + " points: " + this.points.toString() + " index: '" + this.index + "'}";
    }

    public abstract String toJSON();

    public static ObjectMapper mapper() {
        ObjectMapper ret = new ObjectMapper();
        ret.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ret.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ret.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        return ret;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public void setSpecial(boolean special) {
        this.special = special;
    }

    public Long getStorageId() {
        return this.storageId;
    }

    public void setStorageId(Long storageId) {
        this.storageId = storageId;
    }
}

