/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.tokenization.tokenizerfactory;

import java.io.InputStream;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.resource.ResourceInitializationException;
import org.deeplearning4j.text.annotator.SentenceAnnotator;
import org.deeplearning4j.text.annotator.TokenizerAnnotator;
import org.deeplearning4j.text.tokenization.tokenizer.TokenPreProcess;
import org.deeplearning4j.text.tokenization.tokenizer.Tokenizer;
import org.deeplearning4j.text.tokenization.tokenizer.UimaTokenizer;
import org.deeplearning4j.text.tokenization.tokenizerfactory.TokenizerFactory;
import org.deeplearning4j.text.uima.UimaResource;

public class UimaTokenizerFactory
implements TokenizerFactory {
    private UimaResource uimaResource;
    private boolean checkForLabel;
    private static AnalysisEngine defaultAnalysisEngine;
    private TokenPreProcess preProcess;

    public UimaTokenizerFactory() throws ResourceInitializationException {
        this(UimaTokenizerFactory.defaultAnalysisEngine(), true);
    }

    public UimaTokenizerFactory(UimaResource resource) {
        this(resource, true);
    }

    public UimaTokenizerFactory(AnalysisEngine tokenizer) {
        this(tokenizer, true);
    }

    public UimaTokenizerFactory(UimaResource resource, boolean checkForLabel) {
        this.uimaResource = resource;
        this.checkForLabel = checkForLabel;
    }

    public UimaTokenizerFactory(boolean checkForLabel) throws ResourceInitializationException {
        this(UimaTokenizerFactory.defaultAnalysisEngine(), checkForLabel);
    }

    public UimaTokenizerFactory(AnalysisEngine tokenizer, boolean checkForLabel) {
        this.checkForLabel = checkForLabel;
        try {
            this.uimaResource = new UimaResource(tokenizer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Tokenizer create(String toTokenize) {
        if (toTokenize == null) {
            throw new IllegalArgumentException("Unable to proceed; on sentence to tokenize");
        }
        UimaTokenizer ret = new UimaTokenizer(toTokenize, this.uimaResource, this.checkForLabel);
        ret.setTokenPreProcessor(this.preProcess);
        return ret;
    }

    public UimaResource getUimaResource() {
        return this.uimaResource;
    }

    public static AnalysisEngine defaultAnalysisEngine() {
        try {
            if (defaultAnalysisEngine == null) {
                defaultAnalysisEngine = AnalysisEngineFactory.createEngine((AnalysisEngineDescription)AnalysisEngineFactory.createEngineDescription((AnalysisEngineDescription[])new AnalysisEngineDescription[]{SentenceAnnotator.getDescription(), TokenizerAnnotator.getDescription()}), (Object[])new Object[0]);
            }
            return defaultAnalysisEngine;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Tokenizer create(InputStream toTokenize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTokenPreProcessor(TokenPreProcess preProcessor) {
        this.preProcess = preProcessor;
    }
}

