/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.tokenization.tokenizerfactory;

import java.io.InputStream;
import org.deeplearning4j.text.tokenization.tokenizer.NGramTokenizer;
import org.deeplearning4j.text.tokenization.tokenizer.TokenPreProcess;
import org.deeplearning4j.text.tokenization.tokenizer.Tokenizer;
import org.deeplearning4j.text.tokenization.tokenizerfactory.TokenizerFactory;

public class NGramTokenizerFactory
implements TokenizerFactory {
    private TokenPreProcess preProcess;
    private Integer minN = 1;
    private Integer maxN = 1;
    private TokenizerFactory tokenizerFactory;

    public NGramTokenizerFactory(TokenizerFactory tokenizerFactory, Integer minN, Integer maxN) {
        this.tokenizerFactory = tokenizerFactory;
        this.minN = minN;
        this.maxN = maxN;
    }

    @Override
    public Tokenizer create(String toTokenize) {
        if (toTokenize == null || toTokenize.isEmpty()) {
            throw new IllegalArgumentException("Unable to proceed; no sentence to tokenize");
        }
        Tokenizer t1 = this.tokenizerFactory.create(toTokenize);
        t1.setTokenPreProcessor(this.preProcess);
        NGramTokenizer ret = new NGramTokenizer(t1, this.minN, this.maxN);
        return ret;
    }

    @Override
    public Tokenizer create(InputStream toTokenize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTokenPreProcessor(TokenPreProcess preProcessor) {
        this.preProcess = preProcessor;
    }
}

