/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.sentenceiterator;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.token.type.Sentence;
import org.cleartk.util.cr.FilesCollectionReader;
import org.deeplearning4j.text.annotator.SentenceAnnotator;
import org.deeplearning4j.text.annotator.TokenizerAnnotator;
import org.deeplearning4j.text.sentenceiterator.BaseSentenceIterator;
import org.deeplearning4j.text.sentenceiterator.SentenceIterator;
import org.deeplearning4j.text.sentenceiterator.SentencePreProcessor;
import org.deeplearning4j.text.uima.UimaResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UimaSentenceIterator
extends BaseSentenceIterator {
    protected volatile CollectionReader reader;
    protected volatile Iterator<String> sentences;
    protected String path;
    private static final Logger log = LoggerFactory.getLogger(UimaSentenceIterator.class);
    private static AnalysisEngine defaultAnalysisEngine;
    private UimaResource resource;

    public UimaSentenceIterator(SentencePreProcessor preProcessor, String path, UimaResource resource) {
        super(preProcessor);
        this.path = path;
        File f = new File(path);
        if (f.isFile()) {
            try {
                this.reader = FilesCollectionReader.getCollectionReader((String)path);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.reader = FilesCollectionReader.getCollectionReader((String)path);
        }
        catch (ResourceInitializationException e) {
            throw new RuntimeException(e);
        }
        this.resource = resource;
    }

    public UimaSentenceIterator(SentencePreProcessor preProcessor, CollectionReader cr, UimaResource resource) {
        super(preProcessor);
        this.reader = cr;
        this.resource = resource;
    }

    public UimaSentenceIterator(String path, UimaResource resource) {
        this(null, path, resource);
    }

    @Override
    public synchronized String nextSentence() {
        if (this.sentences == null || !this.sentences.hasNext()) {
            try {
                if (this.getReader().hasNext()) {
                    CAS cas = this.resource.retrieve();
                    try {
                        this.getReader().getNext(cas);
                    }
                    catch (Exception e) {
                        log.warn("Done iterating returning an empty string");
                        return "";
                    }
                    this.resource.getAnalysisEngine().process(cas);
                    ArrayList<String> list = new ArrayList<String>();
                    for (Sentence sentence : JCasUtil.select((JCas)cas.getJCas(), Sentence.class)) {
                        list.add(sentence.getCoveredText());
                    }
                    this.sentences = list.iterator();
                    while (!this.sentences.hasNext()) {
                        if (this.reader.hasNext()) {
                            cas.reset();
                            this.getReader().getNext(cas);
                            this.resource.getAnalysisEngine().process(cas);
                            for (Sentence sentence : JCasUtil.select((JCas)cas.getJCas(), Sentence.class)) {
                                list.add(sentence.getCoveredText());
                            }
                            this.sentences = list.iterator();
                            continue;
                        }
                        return null;
                    }
                    String ret = this.sentences.next();
                    if (this.getPreProcessor() != null) {
                        ret = this.getPreProcessor().preProcess(ret);
                    }
                    return ret;
                }
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        String ret = this.sentences.next();
        if (this.getPreProcessor() != null) {
            ret = this.getPreProcessor().preProcess(ret);
        }
        return ret;
    }

    public UimaResource getResource() {
        return this.resource;
    }

    public static SentenceIterator createWithPath(String path) throws Exception {
        return new UimaSentenceIterator(path, new UimaResource(AnalysisEngineFactory.createEngine((AnalysisEngineDescription)AnalysisEngineFactory.createEngineDescription((AnalysisEngineDescription[])new AnalysisEngineDescription[]{TokenizerAnnotator.getDescription(), SentenceAnnotator.getDescription()}), (Object[])new Object[0])));
    }

    @Override
    public synchronized boolean hasNext() {
        try {
            return this.getReader().hasNext() || this.sentences != null && this.sentences.hasNext();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized CollectionReader getReader() {
        return this.reader;
    }

    @Override
    public void reset() {
        try {
            this.reader = FilesCollectionReader.getCollectionReader((String)this.path);
        }
        catch (ResourceInitializationException e) {
            throw new RuntimeException(e);
        }
    }

    public static AnalysisEngine segmenter() {
        try {
            if (defaultAnalysisEngine == null) {
                defaultAnalysisEngine = AnalysisEngineFactory.createEngine((AnalysisEngineDescription)AnalysisEngineFactory.createEngineDescription((AnalysisEngineDescription[])new AnalysisEngineDescription[]{SentenceAnnotator.getDescription()}), (Object[])new Object[0]);
            }
            return defaultAnalysisEngine;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

