/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.movingwindow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Window
implements Serializable {
    private static final long serialVersionUID = 6359906393699230579L;
    private List<String> words;
    private String label = "NONE";
    private boolean beginLabel;
    private boolean endLabel;
    private int windowSize;
    private int median;
    private static String BEGIN_LABEL = "<([A-Z]+|\\d+)>";
    private static String END_LABEL = "</([A-Z]+|\\d+)>";
    private int begin;
    private int end;

    public Window(Collection<String> words, int begin, int end) {
        this(words, 5, begin, end);
    }

    public String asTokens() {
        return StringUtils.join(this.words, (String)" ");
    }

    public Window(Collection<String> words, int windowSize, int begin, int end) {
        if (words == null) {
            throw new IllegalArgumentException("Words must be a list of size 3");
        }
        this.words = new ArrayList<String>(words);
        this.windowSize = windowSize;
        this.begin = begin;
        this.end = end;
        this.initContext();
    }

    private void initContext() {
        int median = (int)Math.floor(this.words.size() / 2);
        List<String> begin = this.words.subList(0, median);
        List<String> after = this.words.subList(median + 1, this.words.size());
        for (String s : begin) {
            if (s.matches(BEGIN_LABEL)) {
                this.label = s.replaceAll("(<|>)", "").replace("/", "");
                this.beginLabel = true;
                continue;
            }
            if (!s.matches(END_LABEL)) continue;
            this.endLabel = true;
            this.label = s.replaceAll("(<|>|/)", "").replace("/", "");
        }
        for (String s1 : after) {
            if (s1.matches(BEGIN_LABEL)) {
                this.label = s1.replaceAll("(<|>)", "").replace("/", "");
                this.beginLabel = true;
            }
            if (!s1.matches(END_LABEL)) continue;
            this.endLabel = true;
            this.label = s1.replaceAll("(<|>)", "");
        }
        this.median = median;
    }

    public String toString() {
        return this.words.toString();
    }

    public List<String> getWords() {
        return this.words;
    }

    public void setWords(List<String> words) {
        this.words = words;
    }

    public String getWord(int i) {
        return this.words.get(i);
    }

    public String getFocusWord() {
        return this.words.get(this.median);
    }

    public boolean isBeginLabel() {
        return !this.label.equals("NONE") && this.beginLabel;
    }

    public boolean isEndLabel() {
        return !this.label.equals("NONE") && this.endLabel;
    }

    public String getLabel() {
        return this.label.replace("/", "");
    }

    public int getWindowSize() {
        return this.words.size();
    }

    public int getMedian() {
        return this.median;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getBegin() {
        return this.begin;
    }

    public void setBegin(int begin) {
        this.begin = begin;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }
}

