/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.plot.dropwizard;

import io.dropwizard.Application;
import io.dropwizard.Bundle;
import io.dropwizard.assets.AssetsBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.views.ViewBundle;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.deeplearning4j.plot.dropwizard.ApiConfiguration;
import org.deeplearning4j.plot.dropwizard.ApiResource;
import org.deeplearning4j.plot.dropwizard.RenderResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class RenderApplication
extends Application<ApiConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(RenderApplication.class);

    public void initialize(Bootstrap<ApiConfiguration> apiConfigurationBootstrap) {
        apiConfigurationBootstrap.addBundle((Bundle)new ViewBundle());
        apiConfigurationBootstrap.addBundle((Bundle)new AssetsBundle());
    }

    public void run(ApiConfiguration apiConfiguration, Environment environment) throws Exception {
        environment.jersey().register((Object)new ApiResource("coords.csv"));
        environment.jersey().register((Object)new RenderResource());
    }

    public static void main(String[] args) throws Exception {
        ClassPathResource resource = new ClassPathResource("/render/dropwizard.yml");
        InputStream is = resource.getInputStream();
        File tmpConfig = new File("dropwizard-render.yml");
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpConfig));
        IOUtils.copy((InputStream)is, (OutputStream)bos);
        bos.flush();
        bos.close();
        is.close();
        tmpConfig.deleteOnExit();
        new RenderApplication().run(new String[]{"server", tmpConfig.getAbsolutePath()});
    }
}

