/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.word2vec;

import com.google.common.util.concurrent.AtomicDouble;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class VocabWord
implements Comparable<VocabWord>,
Serializable {
    private static final long serialVersionUID = 2223750736522624256L;
    private AtomicDouble wordFrequency = new AtomicDouble(0.0);
    private int index = -1;
    private VocabWord left;
    private VocabWord right;
    private VocabWord parent;
    private int[] codes = new int[40];
    private String word;
    public static final String PARENT_NODE = "parent";
    private INDArray historicalGradient;
    private int[] points = new int[40];
    private int codeLength = 0;

    public static VocabWord none() {
        return new VocabWord(0.0, "none");
    }

    public VocabWord(double wordFrequency, String word) {
        this.wordFrequency.set(wordFrequency);
        if (word == null || word.isEmpty()) {
            throw new IllegalArgumentException("Word must not be null or empty");
        }
        this.word = word;
    }

    public VocabWord() {
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeDouble(this.wordFrequency.get());
    }

    public VocabWord read(DataInputStream dos) throws IOException {
        this.wordFrequency.set(dos.readDouble());
        return this;
    }

    public String getWord() {
        return this.word;
    }

    public void setWord(String word) {
        this.word = word;
    }

    public int[] getCodes() {
        return this.codes;
    }

    public void setCodes(int[] codes) {
        this.codes = codes;
    }

    public void setParent(VocabWord parent) {
        this.parent = parent;
    }

    public VocabWord getLeft() {
        return this.left;
    }

    public void setLeft(VocabWord left) {
        this.left = left;
    }

    public VocabWord getRight() {
        return this.right;
    }

    public void setRight(VocabWord right) {
        this.right = right;
    }

    public void increment() {
        this.increment(1);
    }

    public void increment(int by) {
        this.wordFrequency.getAndAdd((double)by);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public double getWordFrequency() {
        if (this.wordFrequency == null) {
            return 0.0;
        }
        return this.wordFrequency.get();
    }

    @Override
    public int compareTo(VocabWord o) {
        return Double.compare(this.wordFrequency.get(), o.wordFrequency.get());
    }

    public double getLearningRate(int index, double g) {
        if (this.historicalGradient == null) {
            this.historicalGradient = Nd4j.zeros((int)this.getCodes().length);
        }
        double pow = Math.pow(g, 2.0);
        this.historicalGradient.putScalar(index, this.historicalGradient.getDouble(index) + pow);
        double sqrt = FastMath.sqrt((double)this.historicalGradient.getDouble(index));
        double abs = FastMath.abs((double)g) / (sqrt + (double)1.0E-6f);
        double ret = abs * (double)0.1f;
        return ret;
    }

    public int[] getPoints() {
        return this.points;
    }

    public void setPoints(int[] points) {
        this.points = points;
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public void setCodeLength(int codeLength) {
        this.codeLength = codeLength;
    }

    public String toString() {
        return "VocabWord{wordFrequency=" + this.wordFrequency + ", index=" + this.index + ", codes=" + Arrays.toString(this.codes) + ", word='" + this.word + '\'' + ", historicalGradient=" + this.historicalGradient + ", points=" + Arrays.toString(this.points) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VocabWord)) {
            return false;
        }
        VocabWord vocabWord = (VocabWord)o;
        if (this.index != vocabWord.index) {
            return false;
        }
        if (!Arrays.equals(this.codes, vocabWord.codes)) {
            return false;
        }
        if (this.historicalGradient != null ? !this.historicalGradient.equals(vocabWord.historicalGradient) : vocabWord.historicalGradient != null) {
            return false;
        }
        if (this.left != null ? !this.left.equals(vocabWord.left) : vocabWord.left != null) {
            return false;
        }
        if (this.parent != null ? !this.parent.equals(vocabWord.parent) : vocabWord.parent != null) {
            return false;
        }
        if (!Arrays.equals(this.points, vocabWord.points)) {
            return false;
        }
        if (this.right != null ? !this.right.equals(vocabWord.right) : vocabWord.right != null) {
            return false;
        }
        if (this.word != null ? !this.word.equals(vocabWord.word) : vocabWord.word != null) {
            return false;
        }
        return !(this.wordFrequency != null ? !this.wordFrequency.equals(vocabWord.wordFrequency) : vocabWord.wordFrequency != null);
    }

    public int hashCode() {
        int result = this.wordFrequency != null ? this.wordFrequency.hashCode() : 0;
        result = 31 * result + this.index;
        result = 31 * result + (this.left != null ? this.left.hashCode() : 0);
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        result = 31 * result + (this.codes != null ? Arrays.hashCode(this.codes) : 0);
        result = 31 * result + (this.word != null ? this.word.hashCode() : 0);
        result = 31 * result + (this.historicalGradient != null ? this.historicalGradient.hashCode() : 0);
        result = 31 * result + (this.points != null ? Arrays.hashCode(this.points) : 0);
        return result;
    }
}

