/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.invertedindex;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.deeplearning4j.berkeley.StringUtils;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.text.invertedindex.InvertedIndex;
import org.deeplearning4j.text.stopwords.StopWords;

public class LuceneInvertedIndex
implements InvertedIndex {
    private transient Directory dir;
    private transient IndexReader reader;
    private transient Analyzer analyzer;
    private transient IndexSearcher searcher;
    private transient IndexWriter writer;
    private transient IndexWriterConfig iwc;
    private VocabCache vocabCache;
    public static final String WORD_FIELD = "word";
    private int numDocs;
    private Map<Integer, List<VocabWord>> words;
    private boolean cache;

    public LuceneInvertedIndex(VocabCache vocabCache, boolean cache) {
        this.iwc = new IndexWriterConfig(Version.LATEST, this.analyzer);
        this.numDocs = 0;
        this.words = new HashMap<Integer, List<VocabWord>>();
        this.cache = true;
        try {
            this.index("word2vec-index", true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.vocabCache = vocabCache;
        this.cache = cache;
    }

    private LuceneInvertedIndex() {
        this.iwc = new IndexWriterConfig(Version.LATEST, this.analyzer);
        this.numDocs = 0;
        this.words = new HashMap<Integer, List<VocabWord>>();
        this.cache = true;
    }

    @Override
    public List<VocabWord> document(int index) {
        if (this.cache) {
            return this.words.get(index);
        }
        CopyOnWriteArrayList<VocabWord> ret = new CopyOnWriteArrayList<VocabWord>();
        try {
            String[] values;
            Document doc = this.reader.document(index);
            for (String s : values = doc.getValues(WORD_FIELD)) {
                ret.add(this.vocabCache.wordFor(s));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public List<Integer> documents(VocabWord vocabWord) {
        try {
            TermQuery query = new TermQuery(new Term(WORD_FIELD, vocabWord.getWord()));
            TopDocs topdocs = this.searcher.search((Query)query, Integer.MAX_VALUE);
            ArrayList<Integer> ret = new ArrayList<Integer>();
            for (int i = 0; i < topdocs.totalHits; ++i) {
                ret.add(topdocs.scoreDocs[i].doc);
            }
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int numDocuments() {
        if (this.numDocs > 0) {
            return this.numDocs;
        }
        int ret = 0;
        try {
            this.initReader();
            ret = this.reader.numDocs();
        }
        catch (Exception e) {
            return 0;
        }
        return ret;
    }

    @Override
    public Collection<Integer> allDocs() {
        ArrayList<Integer> docIds = new ArrayList<Integer>();
        for (int i = 0; i < this.reader.maxDoc(); ++i) {
            docIds.add(i);
        }
        return docIds;
    }

    @Override
    public void addWordToDoc(int doc, VocabWord word) {
        TextField f = new TextField(WORD_FIELD, word.getWord(), Field.Store.YES);
        try {
            this.initReader();
            Document doc2 = this.searcher.doc(doc);
            if (doc2 != null) {
                doc2.add((IndexableField)f);
            } else {
                Document d = new Document();
                d.add((IndexableField)f);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.initReader();
    }

    private void initReader() {
        if (this.reader == null) {
            try {
                this.writer.commit();
                this.reader = DirectoryReader.open((Directory)this.dir);
                this.searcher = new IndexSearcher(this.reader);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void addWordsToDoc(int doc, List<VocabWord> words) {
        Document d = new Document();
        for (VocabWord word : words) {
            d.add((IndexableField)new TextField(WORD_FIELD, word.getWord(), Field.Store.YES));
        }
        try {
            this.writer.addDocument((Iterable)d, this.analyzer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.cache) {
            this.words.put(doc, words);
        }
        this.initReader();
    }

    @Override
    public void finish() {
        try {
            this.writer.forceMerge(1);
            this.writer.commit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.initReader();
        this.numDocs = this.reader.numDocs();
    }

    private void index(String indexPath, boolean create) throws IOException {
        File dir2 = new File(indexPath);
        if (!dir2.exists()) {
            dir2.mkdir();
        }
        this.analyzer = new StandardAnalyzer((Reader)new InputStreamReader(new ByteArrayInputStream("".getBytes())));
        if (create) {
            this.iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        } else {
            this.iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        }
        this.iwc.setRAMBufferSizeMB(5000.0);
        this.dir = FSDirectory.open((File)dir2);
        this.writer = new IndexWriter(this.dir, this.iwc);
        this.initReader();
    }

    public static class Builder {
        private File indexDir;
        private Directory dir;
        private IndexReader reader;
        private Analyzer analyzer;
        private IndexSearcher searcher;
        private IndexWriter writer;
        private IndexWriterConfig iwc;
        private VocabCache vocabCache;
        private List<String> stopWords;
        private boolean cache;

        public Builder() {
            this.iwc = new IndexWriterConfig(Version.LUCENE_4_10_0, this.analyzer);
            this.stopWords = StopWords.getStopWords();
            this.cache = true;
        }

        public Builder cacheDocsInMemory(boolean cache) {
            this.cache = cache;
            return this;
        }

        public Builder indexDir(File indexDir) {
            this.indexDir = indexDir;
            return this;
        }

        public Builder cache(VocabCache cache) {
            this.vocabCache = cache;
            return this;
        }

        public Builder stopWords(List<String> stopWords) {
            this.stopWords = stopWords;
            return this;
        }

        public Builder dir(Directory dir) {
            this.dir = dir;
            return this;
        }

        public Builder reader(IndexReader reader) {
            this.reader = reader;
            return this;
        }

        public Builder writer(IndexWriter writer) {
            this.writer = writer;
            return this;
        }

        public Builder analyzer(Analyzer analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public InvertedIndex build() {
            LuceneInvertedIndex ret = new LuceneInvertedIndex();
            try {
                if (this.analyzer == null) {
                    this.analyzer = new StandardAnalyzer((Reader)new InputStreamReader(new ByteArrayInputStream(StringUtils.join(this.stopWords, (String)"\n").getBytes())));
                }
                if (this.indexDir != null && this.dir != null) {
                    throw new IllegalStateException("Please define only a directory or a file directory");
                }
                if (this.iwc == null) {
                    this.iwc = new IndexWriterConfig(Version.LATEST, this.analyzer);
                }
                if (this.indexDir != null) {
                    if (!this.indexDir.exists()) {
                        this.indexDir.mkdirs();
                    }
                    this.dir = FSDirectory.open((File)this.indexDir);
                    if (this.writer == null) {
                        this.writer = new IndexWriter(this.dir, this.iwc);
                    }
                }
                if (this.vocabCache == null) {
                    throw new IllegalStateException("Vocab cache must not be null");
                }
                ret.vocabCache = this.vocabCache;
                ret.dir = this.dir;
                ret.writer = this.writer;
                ret.cache = this.cache;
                ret.reader = this.reader;
                ret.searcher = this.searcher;
                ret.analyzer = this.analyzer;
                ret.vocabCache = this.vocabCache;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ret;
        }
    }
}

