/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.utils;

import java.io.File;
import java.util.Collections;
import lombok.NonNull;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.modelimport.keras.Hdf5Archive;
import org.deeplearning4j.nn.modelimport.keras.config.KerasModelConfiguration;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.nd4j.common.validation.Nd4jCommonValidator;
import org.nd4j.common.validation.ValidationResult;

public class DL4JKerasModelValidator {
    private DL4JKerasModelValidator() {
    }

    public static ValidationResult validateKerasSequential(@NonNull File f) {
        if (f == null) {
            throw new NullPointerException("f is marked non-null but is null");
        }
        return DL4JKerasModelValidator.validateKeras(f, "Keras Sequential Model HDF5", MultiLayerNetwork.class);
    }

    public static ValidationResult validateKerasFunctional(@NonNull File f) {
        if (f == null) {
            throw new NullPointerException("f is marked non-null but is null");
        }
        return DL4JKerasModelValidator.validateKeras(f, "Keras Functional Model HDF5", ComputationGraph.class);
    }

    protected static ValidationResult validateKeras(@NonNull File f, String format, Class<?> cl) {
        if (f == null) {
            throw new NullPointerException("f is marked non-null but is null");
        }
        ValidationResult vr = Nd4jCommonValidator.isValidFile((File)f, (String)format, (boolean)false);
        if (vr != null && !vr.isValid()) {
            return vr;
        }
        KerasModelConfiguration c = new KerasModelConfiguration();
        Hdf5Archive archive = null;
        try {
            archive = new Hdf5Archive(f.getPath());
            try {
                String json = archive.readAttributeAsJson(c.getTrainingModelConfigAttribute(), new String[0]);
                vr = Nd4jCommonValidator.isValidJSON((String)json);
                if (vr != null && !vr.isValid()) {
                    vr.setFormatType(format);
                    return vr;
                }
            }
            catch (Throwable t) {
                return ValidationResult.builder().formatType(format).formatClass(cl).valid(false).path(Nd4jCommonValidator.getPath((File)f)).issues(Collections.singletonList("Unable to read JSON configuration from Keras Sequential model HDF5 file")).exception(t).build();
            }
        }
        catch (Throwable t) {
            return ValidationResult.builder().formatType(format).formatClass(cl).valid(false).path(Nd4jCommonValidator.getPath((File)f)).issues(Collections.singletonList("Unable to read from " + format + " file - file is corrupt or not a valid Keras HDF5 archive?")).exception(t).build();
        }
        return ValidationResult.builder().formatType(format).formatClass(cl).valid(true).path(Nd4jCommonValidator.getPath((File)f)).build();
    }
}

