/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bytedeco.hdf5.Attribute;
import org.bytedeco.hdf5.DataSet;
import org.bytedeco.hdf5.DataSpace;
import org.bytedeco.hdf5.DataType;
import org.bytedeco.hdf5.Group;
import org.bytedeco.hdf5.H5File;
import org.bytedeco.hdf5.PredType;
import org.bytedeco.hdf5.VarLenType;
import org.bytedeco.hdf5.global.hdf5;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hdf5Archive
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(Hdf5Archive.class);
    public static final int MAX_BUFFER_SIZE_BYTES = (int)Math.pow(2.0, 28.0);
    public static final Object LOCK_OBJECT = new Object();
    private H5File file;
    private static DataType dataType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hdf5Archive(String archiveFilename) {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            this.file = new H5File(archiveFilename, hdf5.H5F_ACC_RDONLY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            this.file.deallocate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Group[] openGroups(String ... groups) {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            Group[] groupArray = new Group[groups.length];
            groupArray[0] = this.file.openGroup(groups[0]);
            for (int i = 1; i < groups.length; ++i) {
                groupArray[i] = groupArray[i - 1].openGroup(groups[i]);
            }
            return groupArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeGroups(Group[] groupArray) {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            for (int i = groupArray.length - 1; i >= 0; --i) {
                groupArray[i].deallocate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INDArray readDataSet(String datasetName, String ... groups) throws UnsupportedKerasConfigurationException {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            if (groups.length == 0) {
                return this.readDataSet((Group)this.file, datasetName);
            }
            Group[] groupArray = this.openGroups(groups);
            INDArray a = this.readDataSet(groupArray[groupArray.length - 1], datasetName);
            this.closeGroups(groupArray);
            return a;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readAttributeAsJson(String attributeName, String ... groups) throws UnsupportedKerasConfigurationException {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            if (groups.length == 0) {
                Attribute a = this.file.openAttribute(attributeName);
                String s = this.readAttributeAsJson(a);
                a.deallocate();
                return s;
            }
            Group[] groupArray = this.openGroups(groups);
            Attribute a = groupArray[groups.length - 1].openAttribute(attributeName);
            String s = this.readAttributeAsJson(a);
            a.deallocate();
            this.closeGroups(groupArray);
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readAttributeAsString(String attributeName, String ... groups) throws UnsupportedKerasConfigurationException {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            if (groups.length == 0) {
                Attribute a = this.file.openAttribute(attributeName);
                String s = this.readAttributeAsString(a);
                a.deallocate();
                return s;
            }
            Group[] groupArray = this.openGroups(groups);
            Attribute a = groupArray[groups.length - 1].openAttribute(attributeName);
            String s = this.readAttributeAsString(a);
            a.deallocate();
            this.closeGroups(groupArray);
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAttribute(String attributeName, String ... groups) {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            if (groups.length == 0) {
                return this.file.attrExists(attributeName);
            }
            Group[] groupArray = this.openGroups(groups);
            boolean b = groupArray[groupArray.length - 1].attrExists(attributeName);
            this.closeGroups(groupArray);
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDataSets(String ... groups) {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            if (groups.length == 0) {
                return this.getObjects((Group)this.file, 1);
            }
            Group[] groupArray = this.openGroups(groups);
            List<String> ls = this.getObjects(groupArray[groupArray.length - 1], 1);
            this.closeGroups(groupArray);
            return ls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getGroups(String ... groups) {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            if (groups.length == 0) {
                return this.getObjects((Group)this.file, 0);
            }
            Group[] groupArray = this.openGroups(groups);
            List<String> ls = this.getObjects(groupArray[groupArray.length - 1], 0);
            this.closeGroups(groupArray);
            return ls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private INDArray readDataSet(Group fileGroup, String datasetName) throws UnsupportedKerasConfigurationException {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            INDArray data;
            DataSet dataset = fileGroup.openDataSet(datasetName);
            DataSpace space = dataset.getSpace();
            int nbDims = space.getSimpleExtentNdims();
            long[] dims = new long[nbDims];
            space.getSimpleExtentDims(dims);
            switch (nbDims) {
                case 5: {
                    float[] dataBuffer = new float[(int)(dims[0] * dims[1] * dims[2] * dims[3] * dims[4])];
                    FloatPointer fp = new FloatPointer(dataBuffer);
                    dataset.read((Pointer)fp, dataType);
                    fp.get(dataBuffer);
                    data = Nd4j.create((int[])new int[]{(int)dims[0], (int)dims[1], (int)dims[2], (int)dims[3], (int)dims[4]});
                    int j = 0;
                    int i1 = 0;
                    while ((long)i1 < dims[0]) {
                        int i2 = 0;
                        while ((long)i2 < dims[1]) {
                            int i3 = 0;
                            while ((long)i3 < dims[2]) {
                                int i4 = 0;
                                while ((long)i4 < dims[3]) {
                                    int i5 = 0;
                                    while ((long)i5 < dims[4]) {
                                        data.putScalar(new int[]{i1, i2, i3, i4, i5++}, dataBuffer[j++]);
                                    }
                                    ++i4;
                                }
                                ++i3;
                            }
                            ++i2;
                        }
                        ++i1;
                    }
                    break;
                }
                case 4: {
                    float[] dataBuffer = new float[(int)(dims[0] * dims[1] * dims[2] * dims[3])];
                    FloatPointer fp = new FloatPointer(dataBuffer);
                    dataset.read((Pointer)fp, dataType);
                    fp.get(dataBuffer);
                    data = Nd4j.create((int[])new int[]{(int)dims[0], (int)dims[1], (int)dims[2], (int)dims[3]});
                    int j = 0;
                    int i1 = 0;
                    while ((long)i1 < dims[0]) {
                        int i2 = 0;
                        while ((long)i2 < dims[1]) {
                            int i3 = 0;
                            while ((long)i3 < dims[2]) {
                                int i4 = 0;
                                while ((long)i4 < dims[3]) {
                                    data.putScalar((long)i1, (long)i2, (long)i3, (long)i4, (double)dataBuffer[j++]);
                                    ++i4;
                                }
                                ++i3;
                            }
                            ++i2;
                        }
                        ++i1;
                    }
                    break;
                }
                case 3: {
                    float[] dataBuffer = new float[(int)(dims[0] * dims[1] * dims[2])];
                    FloatPointer fp = new FloatPointer(dataBuffer);
                    dataset.read((Pointer)fp, dataType);
                    fp.get(dataBuffer);
                    data = Nd4j.create((int[])new int[]{(int)dims[0], (int)dims[1], (int)dims[2]});
                    int j = 0;
                    int i1 = 0;
                    while ((long)i1 < dims[0]) {
                        int i2 = 0;
                        while ((long)i2 < dims[1]) {
                            int i3 = 0;
                            while ((long)i3 < dims[2]) {
                                data.putScalar((long)i1, (long)i2, (long)i3, (double)dataBuffer[j++]);
                                ++i3;
                            }
                            ++i2;
                        }
                        ++i1;
                    }
                    break;
                }
                case 2: {
                    float[] dataBuffer = new float[(int)(dims[0] * dims[1])];
                    FloatPointer fp = new FloatPointer(dataBuffer);
                    dataset.read((Pointer)fp, dataType);
                    fp.get(dataBuffer);
                    data = Nd4j.create((int[])new int[]{(int)dims[0], (int)dims[1]});
                    int j = 0;
                    int i1 = 0;
                    while ((long)i1 < dims[0]) {
                        int i2 = 0;
                        while ((long)i2 < dims[1]) {
                            data.putScalar((long)i1, (long)i2, (double)dataBuffer[j++]);
                            ++i2;
                        }
                        ++i1;
                    }
                    break;
                }
                case 1: {
                    float[] dataBuffer = new float[(int)dims[0]];
                    FloatPointer fp = new FloatPointer(dataBuffer);
                    dataset.read((Pointer)fp, dataType);
                    fp.get(dataBuffer);
                    data = Nd4j.create((int)((int)dims[0]));
                    int j = 0;
                    int i1 = 0;
                    while ((long)i1 < dims[0]) {
                        data.putScalar((long)i1, dataBuffer[j++]);
                        ++i1;
                    }
                    break;
                }
                default: {
                    throw new UnsupportedKerasConfigurationException("Cannot import weights with rank " + nbDims);
                }
            }
            space.deallocate();
            dataset.deallocate();
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getObjects(Group fileGroup, int objType) {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            ArrayList<String> groups = new ArrayList<String>();
            int i = 0;
            while ((long)i < fileGroup.getNumObjs()) {
                BytePointer objPtr = fileGroup.getObjnameByIdx((long)i);
                if (fileGroup.childObjType(objPtr) == objType) {
                    groups.add(fileGroup.getObjnameByIdx((long)i).getString());
                }
                ++i;
            }
            return groups;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readAttributeAsJson(Attribute attribute) throws UnsupportedKerasConfigurationException {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            String s;
            VarLenType vl = attribute.getVarLenType();
            int currBufferLength = 2048;
            while (true) {
                byte[] attrBuffer = new byte[currBufferLength];
                BytePointer attrPointer = new BytePointer((long)currBufferLength);
                attribute.read((DataType)vl, attrPointer);
                attrPointer.get(attrBuffer);
                s = new String(attrBuffer);
                ObjectMapper mapper = new ObjectMapper();
                mapper.enable(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY);
                try {
                    mapper.readTree(s);
                }
                catch (IOException iOException) {
                    if (currBufferLength == MAX_BUFFER_SIZE_BYTES) {
                        throw new UnsupportedKerasConfigurationException("Could not read abnormally long HDF5 attribute: size exceeds " + currBufferLength + " bytes");
                    }
                    currBufferLength = (int)Math.min((long)MAX_BUFFER_SIZE_BYTES, (long)currBufferLength * 4L);
                    continue;
                }
                break;
            }
            vl.deallocate();
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readAttributeAsString(Attribute attribute) throws UnsupportedKerasConfigurationException {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            String s;
            VarLenType vl;
            block4: {
                vl = attribute.getVarLenType();
                int bufferSizeMult = 1;
                s = null;
                do {
                    byte[] attrBuffer = new byte[bufferSizeMult * 2000];
                    BytePointer attrPointer = new BytePointer(attrBuffer);
                    attribute.read((DataType)vl, attrPointer);
                    attrPointer.get(attrBuffer);
                    s = new String(attrBuffer);
                    if (s.endsWith("\u0000")) break block4;
                } while (++bufferSizeMult <= 1000);
                throw new UnsupportedKerasConfigurationException("Could not read abnormally long HDF5 attribute");
            }
            s = s.replace("\u0000", "");
            vl.deallocate();
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readAttributeAsFixedLengthString(String attributeName, int bufferSize) throws UnsupportedKerasConfigurationException {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            Attribute a = this.file.openAttribute(attributeName);
            String s = this.readAttributeAsFixedLengthString(a, bufferSize);
            a.deallocate();
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readAttributeAsFixedLengthString(Attribute attribute, int bufferSize) throws UnsupportedKerasConfigurationException {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            VarLenType vl = attribute.getVarLenType();
            byte[] attrBuffer = new byte[bufferSize];
            BytePointer attrPointer = new BytePointer(attrBuffer);
            attribute.read((DataType)vl, attrPointer);
            attrPointer.get(attrBuffer);
            vl.deallocate();
            return new String(attrBuffer);
        }
    }

    static {
        try {
            Loader.load(hdf5.class);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        dataType = new DataType(PredType.NATIVE_FLOAT());
    }
}

