/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.recurrent;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.LSTM;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.recurrent.LastTimeStep;
import org.deeplearning4j.nn.conf.layers.util.MaskZeroLayer;
import org.deeplearning4j.nn.conf.layers.wrapper.BaseWrapperLayer;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.layers.recurrent.KerasRnnUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasActivationUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasConstraintUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasInitilizationUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;
import org.deeplearning4j.nn.weights.IWeightInit;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasLSTM
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasLSTM.class);
    private final String LSTM_FORGET_BIAS_INIT_ZERO = "zero";
    private final String LSTM_FORGET_BIAS_INIT_ONE = "one";
    private final int NUM_TRAINABLE_PARAMS_KERAS_2 = 3;
    private final int NUM_TRAINABLE_PARAMS = 12;
    private final String KERAS_PARAM_NAME_W_C = "W_c";
    private final String KERAS_PARAM_NAME_W_F = "W_f";
    private final String KERAS_PARAM_NAME_W_I = "W_i";
    private final String KERAS_PARAM_NAME_W_O = "W_o";
    private final String KERAS_PARAM_NAME_U_C = "U_c";
    private final String KERAS_PARAM_NAME_U_F = "U_f";
    private final String KERAS_PARAM_NAME_U_I = "U_i";
    private final String KERAS_PARAM_NAME_U_O = "U_o";
    private final String KERAS_PARAM_NAME_B_C = "b_c";
    private final String KERAS_PARAM_NAME_B_F = "b_f";
    private final String KERAS_PARAM_NAME_B_I = "b_i";
    private final String KERAS_PARAM_NAME_B_O = "b_o";
    private final int NUM_WEIGHTS_IN_KERAS_LSTM = 12;
    protected boolean unroll = false;
    protected boolean returnSequences;

    public KerasLSTM(Integer kerasVersion) throws UnsupportedKerasConfigurationException {
        super(kerasVersion);
    }

    public KerasLSTM(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasLSTM(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, enforceTrainingConfig, Collections.emptyMap());
    }

    public KerasLSTM(Map<String, Object> layerConfig, Map<String, ? extends KerasLayer> previousLayers) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true, previousLayers);
    }

    public KerasLSTM(Map<String, Object> layerConfig, boolean enforceTrainingConfig, Map<String, ? extends KerasLayer> previousLayers) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        IWeightInit init = KerasInitilizationUtils.getWeightInitFromConfig(layerConfig, this.conf.getLAYER_FIELD_INIT(), enforceTrainingConfig, this.conf, this.kerasMajorVersion);
        IWeightInit recurrentInit = KerasInitilizationUtils.getWeightInitFromConfig(layerConfig, this.conf.getLAYER_FIELD_INNER_INIT(), enforceTrainingConfig, this.conf, this.kerasMajorVersion);
        boolean hasBias = KerasLayerUtils.getHasBiasFromConfig(layerConfig, this.conf);
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, this.conf);
        this.returnSequences = (Boolean)innerConfig.get(this.conf.getLAYER_FIELD_RETURN_SEQUENCES());
        this.unroll = KerasRnnUtils.getUnrollRecurrentLayer(this.conf, layerConfig);
        LayerConstraint biasConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_B_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        LayerConstraint weightConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_W_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        LayerConstraint recurrentConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_RECURRENT_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        Pair<Boolean, Double> maskingConfig = KerasLayerUtils.getMaskingConfiguration(this.inboundLayerNames, previousLayers);
        LSTM.Builder builder = (LSTM.Builder)((LSTM.Builder)((LSTM.Builder)((LSTM.Builder)((LSTM.Builder)((LSTM.Builder)((LSTM.Builder)((LSTM.Builder)((LSTM.Builder)((LSTM.Builder)((LSTM.Builder)new LSTM.Builder().gateActivationFunction(this.getGateActivationFromConfig(layerConfig))).forgetGateBiasInit(this.getForgetBiasInitFromConfig(layerConfig, enforceTrainingConfig))).name(this.layerName)).nOut(KerasLayerUtils.getNOutFromConfig(layerConfig, this.conf))).dropOut(this.dropout)).activation(KerasActivationUtils.getIActivationFromConfig(layerConfig, this.conf))).weightInit(init)).weightInitRecurrent(recurrentInit)).biasInit(0.0)).l1(this.weightL1Regularization)).l2(this.weightL2Regularization);
        Integer nIn = KerasLayerUtils.getNInFromInputDim(layerConfig, this.conf);
        if (nIn != null) {
            builder.setNIn((long)nIn.intValue());
        }
        if (biasConstraint != null) {
            builder.constrainBias(new LayerConstraint[]{biasConstraint});
        }
        if (weightConstraint != null) {
            builder.constrainInputWeights(new LayerConstraint[]{weightConstraint});
        }
        if (recurrentConstraint != null) {
            builder.constrainRecurrent(new LayerConstraint[]{recurrentConstraint});
        }
        this.layer = builder.build();
        if (!this.returnSequences) {
            this.layer = new LastTimeStep(this.layer);
        }
        if (((Boolean)maskingConfig.getFirst()).booleanValue()) {
            this.layer = new MaskZeroLayer(this.layer, ((Double)maskingConfig.getSecond()).doubleValue());
        }
    }

    public Layer getLSTMLayer() {
        return this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1 && inputType.length != 3) {
            throw new InvalidKerasConfigurationException("Keras LSTM layer accepts only one single inputor three (input to LSTM and two states tensors, but received " + inputType.length + ".");
        }
        InputPreProcessor preProcessor = this.getInputPreprocessor(inputType);
        if (preProcessor != null) {
            if (this.returnSequences) {
                return preProcessor.getOutputType(inputType[0]);
            }
            return this.getLSTMLayer().getOutputType(-1, preProcessor.getOutputType(inputType[0]));
        }
        return this.getLSTMLayer().getOutputType(-1, inputType[0]);
    }

    @Override
    public int getNumParams() {
        return this.kerasMajorVersion == 2 ? 3 : 12;
    }

    @Override
    public InputPreProcessor getInputPreprocessor(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1 && inputType.length != 3) {
            throw new InvalidKerasConfigurationException("Keras LSTM layer accepts only one single inputor three (input to LSTM and two states tensors, but received " + inputType.length + ".");
        }
        return InputTypeUtil.getPreprocessorForInputTypeRnnLayers((InputType)inputType[0], (String)this.layerName);
    }

    @Override
    public void setWeights(Map<String, INDArray> weights) throws InvalidKerasConfigurationException {
        FeedForwardLayer ffl;
        INDArray b_o;
        INDArray b_c;
        INDArray b_f;
        INDArray b_i;
        INDArray U_o;
        INDArray U_c;
        INDArray U_f;
        INDArray U_i;
        INDArray W_o;
        INDArray W_c;
        INDArray W_f;
        INDArray W_i;
        this.weights = new HashMap();
        if (this.kerasMajorVersion == 2) {
            if (!weights.containsKey(this.conf.getKERAS_PARAM_NAME_W())) {
                throw new InvalidKerasConfigurationException("Keras LSTM layer does not contain parameter " + this.conf.getKERAS_PARAM_NAME_W());
            }
            INDArray W = weights.get(this.conf.getKERAS_PARAM_NAME_W());
            if (!weights.containsKey(this.conf.getKERAS_PARAM_NAME_RW())) {
                throw new InvalidKerasConfigurationException("Keras LSTM layer does not contain parameter " + this.conf.getKERAS_PARAM_NAME_RW());
            }
            INDArray U = weights.get(this.conf.getKERAS_PARAM_NAME_RW());
            if (!weights.containsKey(this.conf.getKERAS_PARAM_NAME_B())) {
                throw new InvalidKerasConfigurationException("Keras LSTM layer does not contain parameter " + this.conf.getKERAS_PARAM_NAME_B());
            }
            INDArray b = weights.get(this.conf.getKERAS_PARAM_NAME_B());
            long sliceInterval = b.length() / 4L;
            W_i = W.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((long)0L, (long)sliceInterval)});
            W_f = W.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((long)sliceInterval, (long)(2L * sliceInterval))});
            W_c = W.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((long)(2L * sliceInterval), (long)(3L * sliceInterval))});
            W_o = W.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((long)(3L * sliceInterval), (long)(4L * sliceInterval))});
            U_i = U.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((long)0L, (long)sliceInterval)});
            U_f = U.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((long)sliceInterval, (long)(2L * sliceInterval))});
            U_c = U.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((long)(2L * sliceInterval), (long)(3L * sliceInterval))});
            U_o = U.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((long)(3L * sliceInterval), (long)(4L * sliceInterval))});
            b_i = b.get(new INDArrayIndex[]{NDArrayIndex.interval((long)0L, (long)sliceInterval)});
            b_f = b.get(new INDArrayIndex[]{NDArrayIndex.interval((long)sliceInterval, (long)(2L * sliceInterval))});
            b_c = b.get(new INDArrayIndex[]{NDArrayIndex.interval((long)(2L * sliceInterval), (long)(3L * sliceInterval))});
            b_o = b.get(new INDArrayIndex[]{NDArrayIndex.interval((long)(3L * sliceInterval), (long)(4L * sliceInterval))});
        } else {
            if (!weights.containsKey("W_c")) {
                throw new InvalidKerasConfigurationException("Keras LSTM layer does not contain parameter W_c");
            }
            W_c = weights.get("W_c");
            if (!weights.containsKey("W_f")) {
                throw new InvalidKerasConfigurationException("Keras LSTM layer does not contain parameter W_f");
            }
            W_f = weights.get("W_f");
            if (!weights.containsKey("W_o")) {
                throw new InvalidKerasConfigurationException("Keras LSTM layer does not contain parameter W_o");
            }
            W_o = weights.get("W_o");
            if (!weights.containsKey("W_i")) {
                throw new InvalidKerasConfigurationException("Keras LSTM layer does not contain parameter W_i");
            }
            W_i = weights.get("W_i");
            if (!weights.containsKey("U_c")) {
                throw new InvalidKerasConfigurationException("Keras LSTM layer does not contain parameter U_c");
            }
            U_c = weights.get("U_c");
            if (!weights.containsKey("U_f")) {
                throw new InvalidKerasConfigurationException("Keras LSTM layer does not contain parameter U_f");
            }
            U_f = weights.get("U_f");
            if (!weights.containsKey("U_o")) {
                throw new InvalidKerasConfigurationException("Keras LSTM layer does not contain parameter U_o");
            }
            U_o = weights.get("U_o");
            if (!weights.containsKey("U_i")) {
                throw new InvalidKerasConfigurationException("Keras LSTM layer does not contain parameter U_i");
            }
            U_i = weights.get("U_i");
            if (!weights.containsKey("b_c")) {
                throw new InvalidKerasConfigurationException("Keras LSTM layer does not contain parameter b_c");
            }
            b_c = weights.get("b_c");
            if (!weights.containsKey("b_f")) {
                throw new InvalidKerasConfigurationException("Keras LSTM layer does not contain parameter b_f");
            }
            b_f = weights.get("b_f");
            if (!weights.containsKey("b_o")) {
                throw new InvalidKerasConfigurationException("Keras LSTM layer does not contain parameter b_o");
            }
            b_o = weights.get("b_o");
            if (weights.containsKey("b_i")) {
                b_i = weights.get("b_i");
            } else {
                throw new InvalidKerasConfigurationException("Keras LSTM layer does not contain parameter b_i");
            }
        }
        int wCols = W_c.columns();
        int wRows = W_c.rows();
        INDArray W = Nd4j.zeros((long)wRows, (long)(4 * wCols));
        W.put(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)wRows), NDArrayIndex.interval((int)0, (int)wCols)}, W_c);
        W.put(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)wRows), NDArrayIndex.interval((int)wCols, (int)(2 * wCols))}, W_f);
        W.put(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)wRows), NDArrayIndex.interval((int)(2 * wCols), (int)(3 * wCols))}, W_o);
        W.put(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)wRows), NDArrayIndex.interval((int)(3 * wCols), (int)(4 * wCols))}, W_i);
        this.weights.put("W", W);
        int uCols = U_c.columns();
        int uRows = U_c.rows();
        INDArray U = Nd4j.zeros((long)uRows, (long)(4 * uCols));
        U.put(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)U.rows()), NDArrayIndex.interval((int)0, (int)uCols)}, U_c);
        U.put(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)U.rows()), NDArrayIndex.interval((int)uCols, (int)(2 * uCols))}, U_f);
        U.put(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)U.rows()), NDArrayIndex.interval((int)(2 * uCols), (int)(3 * uCols))}, U_o);
        U.put(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)U.rows()), NDArrayIndex.interval((int)(3 * uCols), (int)(4 * uCols))}, U_i);
        this.weights.put("RW", U);
        int bCols = b_c.columns();
        int bRows = b_c.rows();
        INDArray b = Nd4j.zeros((long)bRows, (long)(4 * bCols));
        b.put(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)b.rows()), NDArrayIndex.interval((int)0, (int)bCols)}, b_c);
        b.put(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)b.rows()), NDArrayIndex.interval((int)bCols, (int)(2 * bCols))}, b_f);
        b.put(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)b.rows()), NDArrayIndex.interval((int)(2 * bCols), (int)(3 * bCols))}, b_o);
        b.put(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)b.rows()), NDArrayIndex.interval((int)(3 * bCols), (int)(4 * bCols))}, b_i);
        this.weights.put("b", b);
        if (weights.size() > 12) {
            Set<String> paramNames = weights.keySet();
            paramNames.remove("W_c");
            paramNames.remove("W_f");
            paramNames.remove("W_i");
            paramNames.remove("W_o");
            paramNames.remove("U_c");
            paramNames.remove("U_f");
            paramNames.remove("U_i");
            paramNames.remove("U_o");
            paramNames.remove("b_c");
            paramNames.remove("b_f");
            paramNames.remove("b_i");
            paramNames.remove("b_o");
            String unknownParamNames = paramNames.toString();
            log.warn("Attemping to set weights for unknown parameters: " + unknownParamNames.substring(1, unknownParamNames.length() - 1));
        }
        if (this.layer instanceof BaseWrapperLayer) {
            BaseWrapperLayer bwl = (BaseWrapperLayer)this.layer;
            ffl = (FeedForwardLayer)bwl.getUnderlying();
        } else {
            ffl = (FeedForwardLayer)this.layer;
        }
        if (ffl.getNIn() != (long)wRows) {
            ffl.setNIn((long)wRows);
        }
    }

    public boolean getUnroll() {
        return this.unroll;
    }

    public IActivation getGateActivationFromConfig(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, this.conf);
        if (!innerConfig.containsKey(this.conf.getLAYER_FIELD_INNER_ACTIVATION())) {
            throw new InvalidKerasConfigurationException("Keras LSTM layer config missing " + this.conf.getLAYER_FIELD_INNER_ACTIVATION() + " field");
        }
        return KerasActivationUtils.mapToIActivation((String)innerConfig.get(this.conf.getLAYER_FIELD_INNER_ACTIVATION()), this.conf);
    }

    public double getForgetBiasInitFromConfig(Map<String, Object> layerConfig, boolean train) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        double init;
        String kerasForgetBiasInit;
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, this.conf);
        if (innerConfig.containsKey(this.conf.getLAYER_FIELD_UNIT_FORGET_BIAS())) {
            kerasForgetBiasInit = "one";
        } else {
            if (!innerConfig.containsKey(this.conf.getLAYER_FIELD_FORGET_BIAS_INIT())) {
                throw new InvalidKerasConfigurationException("Keras LSTM layer config missing " + this.conf.getLAYER_FIELD_FORGET_BIAS_INIT() + " field");
            }
            kerasForgetBiasInit = (String)innerConfig.get(this.conf.getLAYER_FIELD_FORGET_BIAS_INIT());
        }
        switch (kerasForgetBiasInit) {
            case "zero": {
                init = 0.0;
                break;
            }
            case "one": {
                init = 1.0;
                break;
            }
            default: {
                if (train) {
                    throw new UnsupportedKerasConfigurationException("Unsupported LSTM forget gate bias initialization: " + kerasForgetBiasInit);
                }
                init = 1.0;
                log.warn("Unsupported LSTM forget gate bias initialization: " + kerasForgetBiasInit + " (using 1 instead)");
            }
        }
        return init;
    }

    public String getLSTM_FORGET_BIAS_INIT_ZERO() {
        return this.LSTM_FORGET_BIAS_INIT_ZERO;
    }

    public String getLSTM_FORGET_BIAS_INIT_ONE() {
        return this.LSTM_FORGET_BIAS_INIT_ONE;
    }

    public int getNUM_TRAINABLE_PARAMS_KERAS_2() {
        return this.NUM_TRAINABLE_PARAMS_KERAS_2;
    }

    public int getNUM_TRAINABLE_PARAMS() {
        this.getClass();
        return 12;
    }

    public String getKERAS_PARAM_NAME_W_C() {
        return this.KERAS_PARAM_NAME_W_C;
    }

    public String getKERAS_PARAM_NAME_W_F() {
        return this.KERAS_PARAM_NAME_W_F;
    }

    public String getKERAS_PARAM_NAME_W_I() {
        return this.KERAS_PARAM_NAME_W_I;
    }

    public String getKERAS_PARAM_NAME_W_O() {
        return this.KERAS_PARAM_NAME_W_O;
    }

    public String getKERAS_PARAM_NAME_U_C() {
        return this.KERAS_PARAM_NAME_U_C;
    }

    public String getKERAS_PARAM_NAME_U_F() {
        return this.KERAS_PARAM_NAME_U_F;
    }

    public String getKERAS_PARAM_NAME_U_I() {
        return this.KERAS_PARAM_NAME_U_I;
    }

    public String getKERAS_PARAM_NAME_U_O() {
        return this.KERAS_PARAM_NAME_U_O;
    }

    public String getKERAS_PARAM_NAME_B_C() {
        return this.KERAS_PARAM_NAME_B_C;
    }

    public String getKERAS_PARAM_NAME_B_F() {
        return this.KERAS_PARAM_NAME_B_F;
    }

    public String getKERAS_PARAM_NAME_B_I() {
        return this.KERAS_PARAM_NAME_B_I;
    }

    public String getKERAS_PARAM_NAME_B_O() {
        return this.KERAS_PARAM_NAME_B_O;
    }

    public int getNUM_WEIGHTS_IN_KERAS_LSTM() {
        this.getClass();
        return 12;
    }

    public boolean isReturnSequences() {
        return this.returnSequences;
    }

    public void setUnroll(boolean unroll) {
        this.unroll = unroll;
    }

    public void setReturnSequences(boolean returnSequences) {
        this.returnSequences = returnSequences;
    }

    public String toString() {
        return "KerasLSTM(LSTM_FORGET_BIAS_INIT_ZERO=" + this.getLSTM_FORGET_BIAS_INIT_ZERO() + ", LSTM_FORGET_BIAS_INIT_ONE=" + this.getLSTM_FORGET_BIAS_INIT_ONE() + ", NUM_TRAINABLE_PARAMS_KERAS_2=" + this.getNUM_TRAINABLE_PARAMS_KERAS_2() + ", NUM_TRAINABLE_PARAMS=" + this.getNUM_TRAINABLE_PARAMS() + ", KERAS_PARAM_NAME_W_C=" + this.getKERAS_PARAM_NAME_W_C() + ", KERAS_PARAM_NAME_W_F=" + this.getKERAS_PARAM_NAME_W_F() + ", KERAS_PARAM_NAME_W_I=" + this.getKERAS_PARAM_NAME_W_I() + ", KERAS_PARAM_NAME_W_O=" + this.getKERAS_PARAM_NAME_W_O() + ", KERAS_PARAM_NAME_U_C=" + this.getKERAS_PARAM_NAME_U_C() + ", KERAS_PARAM_NAME_U_F=" + this.getKERAS_PARAM_NAME_U_F() + ", KERAS_PARAM_NAME_U_I=" + this.getKERAS_PARAM_NAME_U_I() + ", KERAS_PARAM_NAME_U_O=" + this.getKERAS_PARAM_NAME_U_O() + ", KERAS_PARAM_NAME_B_C=" + this.getKERAS_PARAM_NAME_B_C() + ", KERAS_PARAM_NAME_B_F=" + this.getKERAS_PARAM_NAME_B_F() + ", KERAS_PARAM_NAME_B_I=" + this.getKERAS_PARAM_NAME_B_I() + ", KERAS_PARAM_NAME_B_O=" + this.getKERAS_PARAM_NAME_B_O() + ", NUM_WEIGHTS_IN_KERAS_LSTM=" + this.getNUM_WEIGHTS_IN_KERAS_LSTM() + ", unroll=" + this.getUnroll() + ", returnSequences=" + this.isReturnSequences() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KerasLSTM)) {
            return false;
        }
        KerasLSTM other = (KerasLSTM)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$LSTM_FORGET_BIAS_INIT_ZERO = this.getLSTM_FORGET_BIAS_INIT_ZERO();
        String other$LSTM_FORGET_BIAS_INIT_ZERO = other.getLSTM_FORGET_BIAS_INIT_ZERO();
        if (this$LSTM_FORGET_BIAS_INIT_ZERO == null ? other$LSTM_FORGET_BIAS_INIT_ZERO != null : !this$LSTM_FORGET_BIAS_INIT_ZERO.equals(other$LSTM_FORGET_BIAS_INIT_ZERO)) {
            return false;
        }
        String this$LSTM_FORGET_BIAS_INIT_ONE = this.getLSTM_FORGET_BIAS_INIT_ONE();
        String other$LSTM_FORGET_BIAS_INIT_ONE = other.getLSTM_FORGET_BIAS_INIT_ONE();
        if (this$LSTM_FORGET_BIAS_INIT_ONE == null ? other$LSTM_FORGET_BIAS_INIT_ONE != null : !this$LSTM_FORGET_BIAS_INIT_ONE.equals(other$LSTM_FORGET_BIAS_INIT_ONE)) {
            return false;
        }
        if (this.getNUM_TRAINABLE_PARAMS_KERAS_2() != other.getNUM_TRAINABLE_PARAMS_KERAS_2()) {
            return false;
        }
        if (this.getNUM_TRAINABLE_PARAMS() != other.getNUM_TRAINABLE_PARAMS()) {
            return false;
        }
        String this$KERAS_PARAM_NAME_W_C = this.getKERAS_PARAM_NAME_W_C();
        String other$KERAS_PARAM_NAME_W_C = other.getKERAS_PARAM_NAME_W_C();
        if (this$KERAS_PARAM_NAME_W_C == null ? other$KERAS_PARAM_NAME_W_C != null : !this$KERAS_PARAM_NAME_W_C.equals(other$KERAS_PARAM_NAME_W_C)) {
            return false;
        }
        String this$KERAS_PARAM_NAME_W_F = this.getKERAS_PARAM_NAME_W_F();
        String other$KERAS_PARAM_NAME_W_F = other.getKERAS_PARAM_NAME_W_F();
        if (this$KERAS_PARAM_NAME_W_F == null ? other$KERAS_PARAM_NAME_W_F != null : !this$KERAS_PARAM_NAME_W_F.equals(other$KERAS_PARAM_NAME_W_F)) {
            return false;
        }
        String this$KERAS_PARAM_NAME_W_I = this.getKERAS_PARAM_NAME_W_I();
        String other$KERAS_PARAM_NAME_W_I = other.getKERAS_PARAM_NAME_W_I();
        if (this$KERAS_PARAM_NAME_W_I == null ? other$KERAS_PARAM_NAME_W_I != null : !this$KERAS_PARAM_NAME_W_I.equals(other$KERAS_PARAM_NAME_W_I)) {
            return false;
        }
        String this$KERAS_PARAM_NAME_W_O = this.getKERAS_PARAM_NAME_W_O();
        String other$KERAS_PARAM_NAME_W_O = other.getKERAS_PARAM_NAME_W_O();
        if (this$KERAS_PARAM_NAME_W_O == null ? other$KERAS_PARAM_NAME_W_O != null : !this$KERAS_PARAM_NAME_W_O.equals(other$KERAS_PARAM_NAME_W_O)) {
            return false;
        }
        String this$KERAS_PARAM_NAME_U_C = this.getKERAS_PARAM_NAME_U_C();
        String other$KERAS_PARAM_NAME_U_C = other.getKERAS_PARAM_NAME_U_C();
        if (this$KERAS_PARAM_NAME_U_C == null ? other$KERAS_PARAM_NAME_U_C != null : !this$KERAS_PARAM_NAME_U_C.equals(other$KERAS_PARAM_NAME_U_C)) {
            return false;
        }
        String this$KERAS_PARAM_NAME_U_F = this.getKERAS_PARAM_NAME_U_F();
        String other$KERAS_PARAM_NAME_U_F = other.getKERAS_PARAM_NAME_U_F();
        if (this$KERAS_PARAM_NAME_U_F == null ? other$KERAS_PARAM_NAME_U_F != null : !this$KERAS_PARAM_NAME_U_F.equals(other$KERAS_PARAM_NAME_U_F)) {
            return false;
        }
        String this$KERAS_PARAM_NAME_U_I = this.getKERAS_PARAM_NAME_U_I();
        String other$KERAS_PARAM_NAME_U_I = other.getKERAS_PARAM_NAME_U_I();
        if (this$KERAS_PARAM_NAME_U_I == null ? other$KERAS_PARAM_NAME_U_I != null : !this$KERAS_PARAM_NAME_U_I.equals(other$KERAS_PARAM_NAME_U_I)) {
            return false;
        }
        String this$KERAS_PARAM_NAME_U_O = this.getKERAS_PARAM_NAME_U_O();
        String other$KERAS_PARAM_NAME_U_O = other.getKERAS_PARAM_NAME_U_O();
        if (this$KERAS_PARAM_NAME_U_O == null ? other$KERAS_PARAM_NAME_U_O != null : !this$KERAS_PARAM_NAME_U_O.equals(other$KERAS_PARAM_NAME_U_O)) {
            return false;
        }
        String this$KERAS_PARAM_NAME_B_C = this.getKERAS_PARAM_NAME_B_C();
        String other$KERAS_PARAM_NAME_B_C = other.getKERAS_PARAM_NAME_B_C();
        if (this$KERAS_PARAM_NAME_B_C == null ? other$KERAS_PARAM_NAME_B_C != null : !this$KERAS_PARAM_NAME_B_C.equals(other$KERAS_PARAM_NAME_B_C)) {
            return false;
        }
        String this$KERAS_PARAM_NAME_B_F = this.getKERAS_PARAM_NAME_B_F();
        String other$KERAS_PARAM_NAME_B_F = other.getKERAS_PARAM_NAME_B_F();
        if (this$KERAS_PARAM_NAME_B_F == null ? other$KERAS_PARAM_NAME_B_F != null : !this$KERAS_PARAM_NAME_B_F.equals(other$KERAS_PARAM_NAME_B_F)) {
            return false;
        }
        String this$KERAS_PARAM_NAME_B_I = this.getKERAS_PARAM_NAME_B_I();
        String other$KERAS_PARAM_NAME_B_I = other.getKERAS_PARAM_NAME_B_I();
        if (this$KERAS_PARAM_NAME_B_I == null ? other$KERAS_PARAM_NAME_B_I != null : !this$KERAS_PARAM_NAME_B_I.equals(other$KERAS_PARAM_NAME_B_I)) {
            return false;
        }
        String this$KERAS_PARAM_NAME_B_O = this.getKERAS_PARAM_NAME_B_O();
        String other$KERAS_PARAM_NAME_B_O = other.getKERAS_PARAM_NAME_B_O();
        if (this$KERAS_PARAM_NAME_B_O == null ? other$KERAS_PARAM_NAME_B_O != null : !this$KERAS_PARAM_NAME_B_O.equals(other$KERAS_PARAM_NAME_B_O)) {
            return false;
        }
        if (this.getNUM_WEIGHTS_IN_KERAS_LSTM() != other.getNUM_WEIGHTS_IN_KERAS_LSTM()) {
            return false;
        }
        if (this.getUnroll() != other.getUnroll()) {
            return false;
        }
        return this.isReturnSequences() == other.isReturnSequences();
    }

    protected boolean canEqual(Object other) {
        return other instanceof KerasLSTM;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $LSTM_FORGET_BIAS_INIT_ZERO = this.getLSTM_FORGET_BIAS_INIT_ZERO();
        result = result * 59 + ($LSTM_FORGET_BIAS_INIT_ZERO == null ? 43 : $LSTM_FORGET_BIAS_INIT_ZERO.hashCode());
        String $LSTM_FORGET_BIAS_INIT_ONE = this.getLSTM_FORGET_BIAS_INIT_ONE();
        result = result * 59 + ($LSTM_FORGET_BIAS_INIT_ONE == null ? 43 : $LSTM_FORGET_BIAS_INIT_ONE.hashCode());
        result = result * 59 + this.getNUM_TRAINABLE_PARAMS_KERAS_2();
        result = result * 59 + this.getNUM_TRAINABLE_PARAMS();
        String $KERAS_PARAM_NAME_W_C = this.getKERAS_PARAM_NAME_W_C();
        result = result * 59 + ($KERAS_PARAM_NAME_W_C == null ? 43 : $KERAS_PARAM_NAME_W_C.hashCode());
        String $KERAS_PARAM_NAME_W_F = this.getKERAS_PARAM_NAME_W_F();
        result = result * 59 + ($KERAS_PARAM_NAME_W_F == null ? 43 : $KERAS_PARAM_NAME_W_F.hashCode());
        String $KERAS_PARAM_NAME_W_I = this.getKERAS_PARAM_NAME_W_I();
        result = result * 59 + ($KERAS_PARAM_NAME_W_I == null ? 43 : $KERAS_PARAM_NAME_W_I.hashCode());
        String $KERAS_PARAM_NAME_W_O = this.getKERAS_PARAM_NAME_W_O();
        result = result * 59 + ($KERAS_PARAM_NAME_W_O == null ? 43 : $KERAS_PARAM_NAME_W_O.hashCode());
        String $KERAS_PARAM_NAME_U_C = this.getKERAS_PARAM_NAME_U_C();
        result = result * 59 + ($KERAS_PARAM_NAME_U_C == null ? 43 : $KERAS_PARAM_NAME_U_C.hashCode());
        String $KERAS_PARAM_NAME_U_F = this.getKERAS_PARAM_NAME_U_F();
        result = result * 59 + ($KERAS_PARAM_NAME_U_F == null ? 43 : $KERAS_PARAM_NAME_U_F.hashCode());
        String $KERAS_PARAM_NAME_U_I = this.getKERAS_PARAM_NAME_U_I();
        result = result * 59 + ($KERAS_PARAM_NAME_U_I == null ? 43 : $KERAS_PARAM_NAME_U_I.hashCode());
        String $KERAS_PARAM_NAME_U_O = this.getKERAS_PARAM_NAME_U_O();
        result = result * 59 + ($KERAS_PARAM_NAME_U_O == null ? 43 : $KERAS_PARAM_NAME_U_O.hashCode());
        String $KERAS_PARAM_NAME_B_C = this.getKERAS_PARAM_NAME_B_C();
        result = result * 59 + ($KERAS_PARAM_NAME_B_C == null ? 43 : $KERAS_PARAM_NAME_B_C.hashCode());
        String $KERAS_PARAM_NAME_B_F = this.getKERAS_PARAM_NAME_B_F();
        result = result * 59 + ($KERAS_PARAM_NAME_B_F == null ? 43 : $KERAS_PARAM_NAME_B_F.hashCode());
        String $KERAS_PARAM_NAME_B_I = this.getKERAS_PARAM_NAME_B_I();
        result = result * 59 + ($KERAS_PARAM_NAME_B_I == null ? 43 : $KERAS_PARAM_NAME_B_I.hashCode());
        String $KERAS_PARAM_NAME_B_O = this.getKERAS_PARAM_NAME_B_O();
        result = result * 59 + ($KERAS_PARAM_NAME_B_O == null ? 43 : $KERAS_PARAM_NAME_B_O.hashCode());
        result = result * 59 + this.getNUM_WEIGHTS_IN_KERAS_LSTM();
        result = result * 59 + (this.getUnroll() ? 79 : 97);
        result = result * 59 + (this.isReturnSequences() ? 79 : 97);
        return result;
    }
}

