/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.convolutional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.modelimport.keras.config.KerasLayerConfiguration;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;
import org.nd4j.linalg.util.ArrayUtil;

public class KerasConvolutionUtils {
    public static int[] getStrideFromConfig(Map<String, Object> layerConfig, int dimension, KerasLayerConfiguration conf) throws InvalidKerasConfigurationException {
        int[] strides;
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, conf);
        if (innerConfig.containsKey(conf.getLAYER_FIELD_CONVOLUTION_STRIDES()) && dimension >= 2) {
            List stridesList = (List)innerConfig.get(conf.getLAYER_FIELD_CONVOLUTION_STRIDES());
            strides = ArrayUtil.toArray((List)stridesList);
        } else if (innerConfig.containsKey(conf.getLAYER_FIELD_SUBSAMPLE_LENGTH()) && dimension == 1) {
            if ((Integer)layerConfig.get("keras_version") == 2) {
                List stridesList = (List)innerConfig.get(conf.getLAYER_FIELD_SUBSAMPLE_LENGTH());
                strides = ArrayUtil.toArray((List)stridesList);
            } else {
                int subsampleLength = (Integer)innerConfig.get(conf.getLAYER_FIELD_SUBSAMPLE_LENGTH());
                strides = new int[]{subsampleLength};
            }
        } else if (innerConfig.containsKey(conf.getLAYER_FIELD_POOL_STRIDES()) && dimension >= 2) {
            List stridesList = (List)innerConfig.get(conf.getLAYER_FIELD_POOL_STRIDES());
            strides = ArrayUtil.toArray((List)stridesList);
        } else if (innerConfig.containsKey(conf.getLAYER_FIELD_POOL_1D_STRIDES()) && dimension == 1) {
            int stride = (Integer)innerConfig.get(conf.getLAYER_FIELD_POOL_1D_STRIDES());
            strides = new int[]{stride};
        } else {
            throw new InvalidKerasConfigurationException("Could not determine layer stride: no " + conf.getLAYER_FIELD_CONVOLUTION_STRIDES() + " or " + conf.getLAYER_FIELD_POOL_STRIDES() + " field found");
        }
        return strides;
    }

    static int getDepthMultiplier(Map<String, Object> layerConfig, KerasLayerConfiguration conf) throws InvalidKerasConfigurationException {
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, conf);
        return (Integer)innerConfig.get(conf.getLAYER_FIELD_DEPTH_MULTIPLIER());
    }

    public static int[] getDilationRate(Map<String, Object> layerConfig, int dimension, KerasLayerConfiguration conf, boolean forceDilation) throws InvalidKerasConfigurationException {
        int[] atrousRate;
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, conf);
        if (innerConfig.containsKey(conf.getLAYER_FIELD_DILATION_RATE()) && dimension >= 2) {
            List atrousRateList = (List)innerConfig.get(conf.getLAYER_FIELD_DILATION_RATE());
            atrousRate = ArrayUtil.toArray((List)atrousRateList);
        } else if (innerConfig.containsKey(conf.getLAYER_FIELD_DILATION_RATE()) && dimension == 1) {
            if ((Integer)layerConfig.get("keras_version") == 2) {
                List atrousRateList = (List)innerConfig.get(conf.getLAYER_FIELD_DILATION_RATE());
                atrousRate = new int[]{(Integer)atrousRateList.get(0), (Integer)atrousRateList.get(0)};
            } else {
                int atrous = (Integer)innerConfig.get(conf.getLAYER_FIELD_DILATION_RATE());
                atrousRate = new int[]{atrous, atrous};
            }
        } else {
            if (forceDilation) {
                throw new InvalidKerasConfigurationException("Could not determine dilation rate: no " + conf.getLAYER_FIELD_DILATION_RATE() + " field found");
            }
            atrousRate = null;
        }
        return atrousRate;
    }

    static int[] getUpsamplingSizeFromConfig(Map<String, Object> layerConfig, int dimension, KerasLayerConfiguration conf) throws InvalidKerasConfigurationException {
        int[] size;
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, conf);
        if (innerConfig.containsKey(conf.getLAYER_FIELD_UPSAMPLING_2D_SIZE()) && dimension == 2 || innerConfig.containsKey(conf.getLAYER_FIELD_UPSAMPLING_3D_SIZE()) && dimension == 3) {
            List sizeList = (List)innerConfig.get(conf.getLAYER_FIELD_UPSAMPLING_2D_SIZE());
            size = ArrayUtil.toArray((List)sizeList);
        } else if (innerConfig.containsKey(conf.getLAYER_FIELD_UPSAMPLING_1D_SIZE()) && dimension == 1) {
            int upsamplingSize1D = (Integer)innerConfig.get(conf.getLAYER_FIELD_UPSAMPLING_1D_SIZE());
            size = new int[]{upsamplingSize1D};
        } else {
            throw new InvalidKerasConfigurationException("Could not determine kernel size: no " + conf.getLAYER_FIELD_UPSAMPLING_1D_SIZE() + ", " + conf.getLAYER_FIELD_UPSAMPLING_2D_SIZE());
        }
        return size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int[] getKernelSizeFromConfig(Map<String, Object> layerConfig, int dimension, KerasLayerConfiguration conf, int kerasMajorVersion) throws InvalidKerasConfigurationException {
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, conf);
        if (kerasMajorVersion != 2) {
            if (innerConfig.containsKey(conf.getLAYER_FIELD_NB_ROW()) && dimension == 2 && innerConfig.containsKey(conf.getLAYER_FIELD_NB_COL())) {
                ArrayList<Integer> kernelSizeList = new ArrayList<Integer>();
                kernelSizeList.add((Integer)innerConfig.get(conf.getLAYER_FIELD_NB_ROW()));
                kernelSizeList.add((Integer)innerConfig.get(conf.getLAYER_FIELD_NB_COL()));
                return ArrayUtil.toArray(kernelSizeList);
            }
            if (innerConfig.containsKey(conf.getLAYER_FIELD_3D_KERNEL_1()) && dimension == 3 && innerConfig.containsKey(conf.getLAYER_FIELD_3D_KERNEL_2()) && innerConfig.containsKey(conf.getLAYER_FIELD_3D_KERNEL_3())) {
                ArrayList<Integer> kernelSizeList = new ArrayList<Integer>();
                kernelSizeList.add((Integer)innerConfig.get(conf.getLAYER_FIELD_3D_KERNEL_1()));
                kernelSizeList.add((Integer)innerConfig.get(conf.getLAYER_FIELD_3D_KERNEL_2()));
                kernelSizeList.add((Integer)innerConfig.get(conf.getLAYER_FIELD_3D_KERNEL_3()));
                return ArrayUtil.toArray(kernelSizeList);
            }
            if (innerConfig.containsKey(conf.getLAYER_FIELD_FILTER_LENGTH()) && dimension == 1) {
                int filterLength = (Integer)innerConfig.get(conf.getLAYER_FIELD_FILTER_LENGTH());
                return new int[]{filterLength};
            }
            if (innerConfig.containsKey(conf.getLAYER_FIELD_POOL_SIZE()) && dimension >= 2) {
                List kernelSizeList = (List)innerConfig.get(conf.getLAYER_FIELD_POOL_SIZE());
                return ArrayUtil.toArray((List)kernelSizeList);
            }
            if (!innerConfig.containsKey(conf.getLAYER_FIELD_POOL_1D_SIZE())) throw new InvalidKerasConfigurationException("Could not determine kernel size: no " + conf.getLAYER_FIELD_NB_ROW() + ", " + conf.getLAYER_FIELD_NB_COL() + ", or " + conf.getLAYER_FIELD_FILTER_LENGTH() + ", or " + conf.getLAYER_FIELD_POOL_1D_SIZE() + ", or " + conf.getLAYER_FIELD_POOL_SIZE() + " field found");
            if (dimension != 1) throw new InvalidKerasConfigurationException("Could not determine kernel size: no " + conf.getLAYER_FIELD_NB_ROW() + ", " + conf.getLAYER_FIELD_NB_COL() + ", or " + conf.getLAYER_FIELD_FILTER_LENGTH() + ", or " + conf.getLAYER_FIELD_POOL_1D_SIZE() + ", or " + conf.getLAYER_FIELD_POOL_SIZE() + " field found");
            int poolSize1D = (Integer)innerConfig.get(conf.getLAYER_FIELD_POOL_1D_SIZE());
            return new int[]{poolSize1D};
        }
        if (innerConfig.containsKey(conf.getLAYER_FIELD_KERNEL_SIZE()) && dimension >= 2) {
            List kernelSizeList = (List)innerConfig.get(conf.getLAYER_FIELD_KERNEL_SIZE());
            return ArrayUtil.toArray((List)kernelSizeList);
        }
        if (innerConfig.containsKey(conf.getLAYER_FIELD_FILTER_LENGTH()) && dimension == 1) {
            List kernelSizeList = (List)innerConfig.get(conf.getLAYER_FIELD_FILTER_LENGTH());
            return ArrayUtil.toArray((List)kernelSizeList);
        }
        if (innerConfig.containsKey(conf.getLAYER_FIELD_POOL_SIZE()) && dimension >= 2) {
            List kernelSizeList = (List)innerConfig.get(conf.getLAYER_FIELD_POOL_SIZE());
            return ArrayUtil.toArray((List)kernelSizeList);
        }
        if (!innerConfig.containsKey(conf.getLAYER_FIELD_POOL_1D_SIZE())) throw new InvalidKerasConfigurationException("Could not determine kernel size: no " + conf.getLAYER_FIELD_KERNEL_SIZE() + ", or " + conf.getLAYER_FIELD_FILTER_LENGTH() + ", or " + conf.getLAYER_FIELD_POOL_SIZE() + " field found");
        if (dimension != 1) throw new InvalidKerasConfigurationException("Could not determine kernel size: no " + conf.getLAYER_FIELD_KERNEL_SIZE() + ", or " + conf.getLAYER_FIELD_FILTER_LENGTH() + ", or " + conf.getLAYER_FIELD_POOL_SIZE() + " field found");
        List kernelSizeList = (List)innerConfig.get(conf.getLAYER_FIELD_POOL_1D_SIZE());
        return ArrayUtil.toArray((List)kernelSizeList);
    }

    public static ConvolutionMode getConvolutionModeFromConfig(Map<String, Object> layerConfig, KerasLayerConfiguration conf) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        ConvolutionMode convolutionMode;
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, conf);
        if (!innerConfig.containsKey(conf.getLAYER_FIELD_BORDER_MODE())) {
            throw new InvalidKerasConfigurationException("Could not determine convolution border mode: no " + conf.getLAYER_FIELD_BORDER_MODE() + " field found");
        }
        String borderMode = (String)innerConfig.get(conf.getLAYER_FIELD_BORDER_MODE());
        if (borderMode.equals(conf.getLAYER_BORDER_MODE_SAME())) {
            convolutionMode = ConvolutionMode.Same;
        } else if (borderMode.equals(conf.getLAYER_BORDER_MODE_VALID()) || borderMode.equals(conf.getLAYER_BORDER_MODE_FULL())) {
            convolutionMode = ConvolutionMode.Truncate;
        } else {
            throw new UnsupportedKerasConfigurationException("Unsupported convolution border mode: " + borderMode);
        }
        return convolutionMode;
    }

    public static int[] getPaddingFromBorderModeConfig(Map<String, Object> layerConfig, int dimension, KerasLayerConfiguration conf, int kerasMajorVersion) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, conf);
        int[] padding = null;
        if (!innerConfig.containsKey(conf.getLAYER_FIELD_BORDER_MODE())) {
            throw new InvalidKerasConfigurationException("Could not determine convolution border mode: no " + conf.getLAYER_FIELD_BORDER_MODE() + " field found");
        }
        String borderMode = (String)innerConfig.get(conf.getLAYER_FIELD_BORDER_MODE());
        if (borderMode.equals(conf.getLAYER_FIELD_BORDER_MODE())) {
            padding = KerasConvolutionUtils.getKernelSizeFromConfig(layerConfig, dimension, conf, kerasMajorVersion);
            int i = 0;
            while (i < padding.length) {
                int n = i++;
                padding[n] = padding[n] - 1;
            }
        }
        return padding;
    }

    static int[] getPaddingFromConfig(Map<String, Object> layerConfig, KerasLayerConfiguration conf, String layerField, int dimension) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        int[] padding;
        block14: {
            Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, conf);
            if (!innerConfig.containsKey(layerField)) {
                throw new InvalidKerasConfigurationException("Field " + layerField + " not found in Keras cropping or padding layer");
            }
            if (dimension >= 2) {
                try {
                    ArrayList<Integer> paddingList;
                    boolean isNested;
                    List paddingNoCast = (List)innerConfig.get(layerField);
                    try {
                        List firstItem = (List)paddingNoCast.get(0);
                        isNested = true;
                        paddingList = new ArrayList<Integer>(2 * dimension);
                    }
                    catch (Exception e) {
                        int firstItem = (Integer)paddingNoCast.get(0);
                        isNested = false;
                        paddingList = new ArrayList(dimension);
                    }
                    if (paddingNoCast.size() == dimension && !isNested) {
                        for (int i = 0; i < dimension; ++i) {
                            paddingList.add((Integer)paddingNoCast.get(i));
                        }
                        padding = ArrayUtil.toArray(paddingList);
                        break block14;
                    }
                    if (paddingNoCast.size() == dimension && isNested) {
                        for (int j = 0; j < dimension; ++j) {
                            List item = (List)paddingNoCast.get(0);
                            paddingList.add((Integer)item.get(0));
                            paddingList.add((Integer)item.get(1));
                        }
                        padding = ArrayUtil.toArray(paddingList);
                        break block14;
                    }
                    throw new InvalidKerasConfigurationException("Found Keras ZeroPadding" + dimension + "D layer with invalid " + paddingList.size() + "D padding.");
                }
                catch (Exception e) {
                    int paddingInt = (Integer)innerConfig.get(layerField);
                    if (dimension == 2) {
                        padding = new int[]{paddingInt, paddingInt, paddingInt, paddingInt};
                        break block14;
                    }
                    padding = new int[]{paddingInt, paddingInt, paddingInt, paddingInt, paddingInt, paddingInt};
                }
            } else if (dimension == 1) {
                int paddingInt = (Integer)innerConfig.get(layerField);
                padding = new int[]{paddingInt, paddingInt};
            } else {
                throw new UnsupportedKerasConfigurationException("Keras padding layer not supported");
            }
        }
        return padding;
    }
}

