/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.utils;

import java.util.Map;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.nd4j.linalg.learning.config.AdaDelta;
import org.nd4j.linalg.learning.config.AdaGrad;
import org.nd4j.linalg.learning.config.AdaMax;
import org.nd4j.linalg.learning.config.Adam;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.learning.config.Nadam;
import org.nd4j.linalg.learning.config.Nesterovs;
import org.nd4j.linalg.learning.config.RmsProp;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.linalg.schedule.InverseSchedule;
import org.nd4j.linalg.schedule.ScheduleType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasOptimizerUtils {
    private static final Logger log = LoggerFactory.getLogger(KerasOptimizerUtils.class);

    public static IUpdater mapOptimizer(Map<String, Object> optimizerConfig) throws UnsupportedKerasConfigurationException, InvalidKerasConfigurationException {
        AdaDelta dl4jOptimizer;
        System.out.println(optimizerConfig);
        if (!optimizerConfig.containsKey("class_name")) {
            throw new InvalidKerasConfigurationException("Optimizer config does not contain a name field.");
        }
        String optimizerName = (String)optimizerConfig.get("class_name");
        if (!optimizerConfig.containsKey("config")) {
            throw new InvalidKerasConfigurationException("Field config missing from layer config");
        }
        Map optimizerParameters = (Map)optimizerConfig.get("config");
        switch (optimizerName) {
            case "Adam": {
                double lr = (Double)optimizerParameters.get("lr");
                double beta1 = (Double)optimizerParameters.get("beta_1");
                double beta2 = (Double)optimizerParameters.get("beta_2");
                double epsilon = (Double)optimizerParameters.get("epsilon");
                double decay = (Double)optimizerParameters.get("decay");
                dl4jOptimizer = new Adam.Builder().beta1(beta1).beta2(beta2).epsilon(epsilon).learningRate(lr).learningRateSchedule((ISchedule)new InverseSchedule(ScheduleType.ITERATION, 1.0, decay, 1.0)).build();
                break;
            }
            case "Adadelta": {
                double rho = (Double)optimizerParameters.get("rho");
                double epsilon = (Double)optimizerParameters.get("epsilon");
                dl4jOptimizer = new AdaDelta.Builder().epsilon(epsilon).rho(rho).build();
                break;
            }
            case "Adgrad": {
                double lr = (Double)optimizerParameters.get("lr");
                double epsilon = (Double)optimizerParameters.get("epsilon");
                double decay = (Double)optimizerParameters.get("decay");
                dl4jOptimizer = new AdaGrad.Builder().epsilon(epsilon).learningRate(lr).learningRateSchedule((ISchedule)new InverseSchedule(ScheduleType.ITERATION, 1.0, decay, 1.0)).build();
                break;
            }
            case "Adamax": {
                double lr = (Double)optimizerParameters.get("lr");
                double beta1 = (Double)optimizerParameters.get("beta_1");
                double beta2 = (Double)optimizerParameters.get("beta_2");
                double epsilon = (Double)optimizerParameters.get("epsilon");
                dl4jOptimizer = new AdaMax(lr, beta1, beta2, epsilon);
                break;
            }
            case "Nadam": {
                double lr = (Double)optimizerParameters.get("lr");
                double beta1 = (Double)optimizerParameters.get("beta_1");
                double beta2 = (Double)optimizerParameters.get("beta_2");
                double epsilon = (Double)optimizerParameters.get("epsilon");
                double decay = (Double)optimizerParameters.get("decay");
                dl4jOptimizer = new Nadam.Builder().beta1(beta1).beta2(beta2).epsilon(epsilon).learningRate(lr).learningRateSchedule((ISchedule)new InverseSchedule(ScheduleType.ITERATION, 1.0, decay, 1.0)).build();
                break;
            }
            case "SGD": {
                double lr = (Double)optimizerParameters.get("lr");
                double momentum = (Double)optimizerParameters.get("epsilon");
                double decay = (Double)optimizerParameters.get("decay");
                dl4jOptimizer = new Nesterovs.Builder().momentum(momentum).learningRate(lr).learningRateSchedule((ISchedule)new InverseSchedule(ScheduleType.ITERATION, 1.0, decay, 1.0)).build();
                break;
            }
            case "RMSprop": {
                double lr = (Double)optimizerParameters.get("lr");
                double rho = (Double)optimizerParameters.get("rho");
                double epsilon = (Double)optimizerParameters.get("epsilon");
                double decay = (Double)optimizerParameters.get("decay");
                dl4jOptimizer = new RmsProp.Builder().epsilon(epsilon).rmsDecay(rho).learningRate(lr).learningRateSchedule((ISchedule)new InverseSchedule(ScheduleType.ITERATION, 1.0, decay, 1.0)).build();
                break;
            }
            default: {
                throw new UnsupportedKerasConfigurationException("Optimizer with name " + optimizerName + "can not bematched to a DL4J optimizer. Note that custom TFOptimizers are not supported by model import");
            }
        }
        return dl4jOptimizer;
    }
}

