/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.conf.BackpropType;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.graph.PreprocessorVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.modelimport.keras.Hdf5Archive;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.config.KerasLayerConfiguration;
import org.deeplearning4j.nn.modelimport.keras.config.KerasModelConfiguration;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.layers.KerasInput;
import org.deeplearning4j.nn.modelimport.keras.layers.KerasLoss;
import org.deeplearning4j.nn.modelimport.keras.layers.recurrent.KerasLstm;
import org.deeplearning4j.nn.modelimport.keras.layers.recurrent.KerasSimpleRnn;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasModelBuilder;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasModelUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasOptimizerUtils;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasModel {
    private static final Logger log = LoggerFactory.getLogger(KerasModel.class);
    protected static KerasModelConfiguration config = new KerasModelConfiguration();
    protected KerasModelBuilder modelBuilder = new KerasModelBuilder(config);
    protected String className;
    protected boolean enforceTrainingConfig;
    protected Map<String, KerasLayer> layers;
    protected List<KerasLayer> layersOrdered;
    protected Map<String, InputType> outputTypes;
    protected ArrayList<String> inputLayerNames;
    protected ArrayList<String> outputLayerNames;
    protected boolean useTruncatedBPTT = false;
    protected int truncatedBPTT = 0;
    protected int kerasMajorVersion;
    protected String kerasBackend;
    protected KerasLayer.DimOrder dimOrder = null;
    protected IUpdater optimizer = null;

    public KerasModel() {
    }

    public KerasModelBuilder modelBuilder() {
        return this.modelBuilder;
    }

    public KerasModel(KerasModelBuilder modelBuilder) throws UnsupportedKerasConfigurationException, IOException, InvalidKerasConfigurationException {
        this(modelBuilder.getModelJson(), modelBuilder.getModelYaml(), modelBuilder.getWeightsArchive(), modelBuilder.getWeightsRoot(), modelBuilder.getTrainingJson(), modelBuilder.getTrainingArchive(), modelBuilder.isEnforceTrainingConfig(), modelBuilder.getInputShape(), modelBuilder.getDimOrder());
    }

    protected KerasModel(String modelJson, String modelYaml, Hdf5Archive weightsArchive, String weightsRoot, String trainingJson, Hdf5Archive trainingArchive, boolean enforceTrainingConfig, int[] inputShape, KerasLayer.DimOrder dimOrder) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        Map<String, Object> modelConfig = KerasModelUtils.parseModelConfig(modelJson, modelYaml);
        this.kerasMajorVersion = KerasModelUtils.determineKerasMajorVersion(modelConfig, config);
        this.kerasBackend = KerasModelUtils.determineKerasBackend(modelConfig, config);
        this.enforceTrainingConfig = enforceTrainingConfig;
        this.dimOrder = dimOrder;
        if (!modelConfig.containsKey(config.getFieldClassName())) {
            throw new InvalidKerasConfigurationException("Could not determine Keras model class (no " + config.getFieldClassName() + " field found)");
        }
        this.className = (String)modelConfig.get(config.getFieldClassName());
        if (!this.className.equals(config.getFieldClassNameModel())) {
            throw new InvalidKerasConfigurationException("Expected model class name " + config.getFieldClassNameModel() + " (found " + this.className + ")");
        }
        if (!modelConfig.containsKey(config.getModelFieldConfig())) {
            throw new InvalidKerasConfigurationException("Could not find model configuration details (no " + config.getModelFieldConfig() + " in model config)");
        }
        Map layerLists = (Map)modelConfig.get(config.getModelFieldConfig());
        if (!layerLists.containsKey(config.getModelFieldInputLayers())) {
            throw new InvalidKerasConfigurationException("Could not find list of input layers (no " + config.getModelFieldInputLayers() + " field found)");
        }
        this.inputLayerNames = new ArrayList();
        for (Object inputLayerNameObj : (List)layerLists.get(config.getModelFieldInputLayers())) {
            this.inputLayerNames.add((String)((List)inputLayerNameObj).get(0));
        }
        if (!layerLists.containsKey(config.getModelFieldOutputLayers())) {
            throw new InvalidKerasConfigurationException("Could not find list of output layers (no " + config.getModelFieldOutputLayers() + " field found)");
        }
        this.outputLayerNames = new ArrayList();
        for (Object outputLayerNameObj : (List)layerLists.get(config.getModelFieldOutputLayers())) {
            this.outputLayerNames.add((String)((List)outputLayerNameObj).get(0));
        }
        if (!layerLists.containsKey(config.getModelFieldLayers())) {
            throw new InvalidKerasConfigurationException("Could not find layer configurations (no " + config.getModelFieldLayers() + " field found)");
        }
        Pair<Map<String, KerasLayer>, List<KerasLayer>> layerPair = this.prepareLayers((List)layerLists.get(config.getModelFieldLayers()));
        this.layers = (Map)layerPair.getFirst();
        this.layersOrdered = (List)layerPair.getSecond();
        if (enforceTrainingConfig) {
            if (trainingJson != null) {
                this.importTrainingConfiguration(trainingJson);
            } else {
                log.warn("If enforceTrainingConfig is true, a training configuration object has to be provided. Usually the only practical way to do this is to store your keras model with `model.save('model_path.h5'. If you store model config and weights separately no training configuration is attached.");
            }
        }
        this.outputTypes = this.inferOutputTypes(inputShape);
        if (weightsArchive != null) {
            KerasModelUtils.importWeights(weightsArchive, weightsRoot, this.layers, this.kerasMajorVersion, this.kerasBackend);
        }
    }

    Pair<Map<String, KerasLayer>, List<KerasLayer>> prepareLayers(List<Object> layerConfigs) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        HashMap<String, KerasLayer> layers = new HashMap<String, KerasLayer>();
        ArrayList<KerasLayer> layersOrdered = new ArrayList<KerasLayer>();
        for (Object layerConfig : layerConfigs) {
            Map layerConfigMap = (Map)layerConfig;
            layerConfigMap.put(config.getFieldKerasVersion(), this.kerasMajorVersion);
            if (this.kerasMajorVersion == 2 && this.kerasBackend != null) {
                layerConfigMap.put(config.getFieldBackend(), this.kerasBackend);
            }
            KerasLayerConfiguration kerasLayerConf = new KerasLayer((Integer)Integer.valueOf((int)this.kerasMajorVersion)).conf;
            if (this.dimOrder != null) {
                String dimOrderString;
                if (this.dimOrder == KerasLayer.DimOrder.TENSORFLOW) {
                    dimOrderString = kerasLayerConf.getDIM_ORDERING_TENSORFLOW();
                } else if (this.dimOrder == KerasLayer.DimOrder.THEANO) {
                    dimOrderString = kerasLayerConf.getDIM_ORDERING_THEANO();
                } else {
                    throw new InvalidKerasConfigurationException("Invalid data format / dim ordering");
                }
                layerConfigMap.put(kerasLayerConf.getLAYER_FIELD_DIM_ORDERING(), dimOrderString);
            }
            KerasLayer layer = KerasLayerUtils.getKerasLayerFromConfig(layerConfigMap, this.enforceTrainingConfig, kerasLayerConf, KerasLayer.customLayers, KerasLayer.lambdaLayers, layers);
            layersOrdered.add(layer);
            layers.put(layer.getLayerName(), layer);
            if (layer instanceof KerasLstm) {
                boolean bl = this.useTruncatedBPTT = this.useTruncatedBPTT || ((KerasLstm)layer).getUnroll();
            }
            if (!(layer instanceof KerasSimpleRnn)) continue;
            this.useTruncatedBPTT = this.useTruncatedBPTT || ((KerasSimpleRnn)layer).getUnroll();
        }
        return new Pair(layers, layersOrdered);
    }

    Map<String, Object> getOptimizerConfig(Map<String, Object> trainingConfig) throws InvalidKerasConfigurationException {
        if (!trainingConfig.containsKey(config.getOptimizerConfig())) {
            throw new InvalidKerasConfigurationException("Field " + config.getOptimizerConfig() + " missing from layer config");
        }
        return (Map)trainingConfig.get(config.getOptimizerConfig());
    }

    void importTrainingConfiguration(String trainingConfigJson) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        Map<String, Object> trainingConfig = KerasModelUtils.parseJsonString(trainingConfigJson);
        Map<String, Object> optimizerConfig = this.getOptimizerConfig(trainingConfig);
        this.optimizer = KerasOptimizerUtils.mapOptimizer(optimizerConfig);
        ArrayList<KerasLoss> lossLayers = new ArrayList<KerasLoss>();
        if (!trainingConfig.containsKey(config.getTrainingLoss())) {
            throw new InvalidKerasConfigurationException("Could not determine training loss function (no " + config.getTrainingLoss() + " field found in training config)");
        }
        Object kerasLossObj = trainingConfig.get(config.getTrainingLoss());
        if (kerasLossObj instanceof String) {
            String kerasLoss = (String)kerasLossObj;
            for (String outputLayerName : this.outputLayerNames) {
                lossLayers.add(new KerasLoss(outputLayerName + "_loss", outputLayerName, kerasLoss));
            }
        } else if (kerasLossObj instanceof Map) {
            Map kerasLossMap = (Map)kerasLossObj;
            for (String outputLayerName : kerasLossMap.keySet()) {
                Object kerasLoss = kerasLossMap.get(outputLayerName);
                if (kerasLoss instanceof String) {
                    lossLayers.add(new KerasLoss(outputLayerName + "_loss", outputLayerName, (String)kerasLoss));
                    continue;
                }
                throw new InvalidKerasConfigurationException("Unknown Keras loss " + kerasLoss.toString());
            }
        }
        this.outputLayerNames.clear();
        for (KerasLayer kerasLayer : lossLayers) {
            this.layersOrdered.add(kerasLayer);
            this.layers.put(kerasLayer.getLayerName(), kerasLayer);
            this.outputLayerNames.add(kerasLayer.getLayerName());
        }
    }

    Map<String, InputType> inferOutputTypes(int[] inputShape) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        HashMap<String, InputType> outputTypes = new HashMap<String, InputType>();
        for (KerasLayer layer : this.layersOrdered) {
            InputType outputType;
            if (layer instanceof KerasInput) {
                if (inputShape != null) {
                    layer.inputShape = inputShape;
                }
                outputType = layer.getOutputType(new InputType[0]);
                this.truncatedBPTT = ((KerasInput)layer).getTruncatedBptt();
            } else {
                InputType[] inputTypes = new InputType[layer.getInboundLayerNames().size()];
                int i = 0;
                for (String inboundLayerName : layer.getInboundLayerNames()) {
                    inputTypes[i++] = (InputType)outputTypes.get(inboundLayerName);
                }
                outputType = layer.getOutputType(inputTypes);
            }
            outputTypes.put(layer.getLayerName(), outputType);
        }
        return outputTypes;
    }

    public ComputationGraphConfiguration getComputationGraphConfiguration() throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        if (!this.className.equals(config.getFieldClassNameModel()) && !this.className.equals(config.getFieldClassNameSequential())) {
            throw new InvalidKerasConfigurationException("Keras model class name " + this.className + " incompatible with ComputationGraph");
        }
        NeuralNetConfiguration.Builder modelBuilder = new NeuralNetConfiguration.Builder();
        if (this.optimizer != null) {
            modelBuilder.updater(this.optimizer);
        }
        ComputationGraphConfiguration.GraphBuilder graphBuilder = modelBuilder.graphBuilder();
        graphBuilder.allowDisconnected(true);
        String[] inputLayerNameArray = new String[this.inputLayerNames.size()];
        this.inputLayerNames.toArray(inputLayerNameArray);
        graphBuilder.addInputs(inputLayerNameArray);
        ArrayList<InputType> inputTypeList = new ArrayList<InputType>();
        for (String inputLayerName : this.inputLayerNames) {
            inputTypeList.add(this.layers.get(inputLayerName).getOutputType(new InputType[0]));
        }
        InputType[] inputTypes = new InputType[inputTypeList.size()];
        inputTypeList.toArray(inputTypes);
        graphBuilder.setInputTypes(inputTypes);
        String[] outputLayerNameArray = new String[this.outputLayerNames.size()];
        this.outputLayerNames.toArray(outputLayerNameArray);
        graphBuilder.setOutputs(outputLayerNameArray);
        HashMap<String, InputPreProcessor> preprocessors = new HashMap<String, InputPreProcessor>();
        for (KerasLayer layer : this.layersOrdered) {
            List<String> inboundLayerNames = layer.getInboundLayerNames();
            String[] inboundLayerNamesArray = new String[inboundLayerNames.size()];
            inboundLayerNames.toArray(inboundLayerNamesArray);
            ArrayList<InputType> inboundTypeList = new ArrayList<InputType>();
            for (String layerName : inboundLayerNames) {
                inboundTypeList.add(this.outputTypes.get(layerName));
            }
            InputType[] inboundTypeArray = new InputType[inboundTypeList.size()];
            inboundTypeList.toArray(inboundTypeArray);
            InputPreProcessor preprocessor = layer.getInputPreprocessor(inboundTypeArray);
            if (layer.isLayer()) {
                if (preprocessor != null) {
                    preprocessors.put(layer.getLayerName(), preprocessor);
                }
                graphBuilder.addLayer(layer.getLayerName(), layer.getLayer(), inboundLayerNamesArray);
                continue;
            }
            if (layer.isVertex()) {
                if (preprocessor != null) {
                    preprocessors.put(layer.getLayerName(), preprocessor);
                }
                graphBuilder.addVertex(layer.getLayerName(), layer.getVertex(), inboundLayerNamesArray);
                continue;
            }
            if (!layer.isInputPreProcessor()) continue;
            if (preprocessor == null) {
                throw new UnsupportedKerasConfigurationException("Layer " + layer.getLayerName() + " could not be mapped to Layer, Vertex, or InputPreProcessor");
            }
            graphBuilder.addVertex(layer.getLayerName(), (GraphVertex)new PreprocessorVertex(preprocessor), inboundLayerNamesArray);
        }
        graphBuilder.setInputPreProcessors(preprocessors);
        if (this.useTruncatedBPTT && this.truncatedBPTT > 0) {
            graphBuilder.backpropType(BackpropType.TruncatedBPTT).tBPTTForwardLength(this.truncatedBPTT).tBPTTBackwardLength(this.truncatedBPTT);
        } else {
            graphBuilder.backpropType(BackpropType.Standard);
        }
        return graphBuilder.build();
    }

    public ComputationGraph getComputationGraph() throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        return this.getComputationGraph(true);
    }

    public ComputationGraph getComputationGraph(boolean importWeights) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        ComputationGraph model = new ComputationGraph(this.getComputationGraphConfiguration());
        model.init();
        if (importWeights) {
            model = (ComputationGraph)KerasModelUtils.copyWeightsToModel((Model)model, this.layers);
        }
        return model;
    }

    public KerasModelBuilder getModelBuilder() {
        return this.modelBuilder;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isEnforceTrainingConfig() {
        return this.enforceTrainingConfig;
    }

    public Map<String, KerasLayer> getLayers() {
        return this.layers;
    }

    public List<KerasLayer> getLayersOrdered() {
        return this.layersOrdered;
    }

    public Map<String, InputType> getOutputTypes() {
        return this.outputTypes;
    }

    public ArrayList<String> getInputLayerNames() {
        return this.inputLayerNames;
    }

    public ArrayList<String> getOutputLayerNames() {
        return this.outputLayerNames;
    }

    public boolean isUseTruncatedBPTT() {
        return this.useTruncatedBPTT;
    }

    public int getTruncatedBPTT() {
        return this.truncatedBPTT;
    }

    public int getKerasMajorVersion() {
        return this.kerasMajorVersion;
    }

    public String getKerasBackend() {
        return this.kerasBackend;
    }

    public KerasLayer.DimOrder getDimOrder() {
        return this.dimOrder;
    }

    public IUpdater getOptimizer() {
        return this.optimizer;
    }

    public void setModelBuilder(KerasModelBuilder modelBuilder) {
        this.modelBuilder = modelBuilder;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setEnforceTrainingConfig(boolean enforceTrainingConfig) {
        this.enforceTrainingConfig = enforceTrainingConfig;
    }

    public void setLayers(Map<String, KerasLayer> layers) {
        this.layers = layers;
    }

    public void setLayersOrdered(List<KerasLayer> layersOrdered) {
        this.layersOrdered = layersOrdered;
    }

    public void setOutputTypes(Map<String, InputType> outputTypes) {
        this.outputTypes = outputTypes;
    }

    public void setInputLayerNames(ArrayList<String> inputLayerNames) {
        this.inputLayerNames = inputLayerNames;
    }

    public void setOutputLayerNames(ArrayList<String> outputLayerNames) {
        this.outputLayerNames = outputLayerNames;
    }

    public void setUseTruncatedBPTT(boolean useTruncatedBPTT) {
        this.useTruncatedBPTT = useTruncatedBPTT;
    }

    public void setTruncatedBPTT(int truncatedBPTT) {
        this.truncatedBPTT = truncatedBPTT;
    }

    public void setKerasMajorVersion(int kerasMajorVersion) {
        this.kerasMajorVersion = kerasMajorVersion;
    }

    public void setKerasBackend(String kerasBackend) {
        this.kerasBackend = kerasBackend;
    }

    public void setDimOrder(KerasLayer.DimOrder dimOrder) {
        this.dimOrder = dimOrder;
    }

    public void setOptimizer(IUpdater optimizer) {
        this.optimizer = optimizer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KerasModel)) {
            return false;
        }
        KerasModel other = (KerasModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        KerasModelBuilder this$modelBuilder = this.getModelBuilder();
        KerasModelBuilder other$modelBuilder = other.getModelBuilder();
        if (this$modelBuilder == null ? other$modelBuilder != null : !((Object)this$modelBuilder).equals(other$modelBuilder)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        if (this.isEnforceTrainingConfig() != other.isEnforceTrainingConfig()) {
            return false;
        }
        Map<String, KerasLayer> this$layers = this.getLayers();
        Map<String, KerasLayer> other$layers = other.getLayers();
        if (this$layers == null ? other$layers != null : !((Object)this$layers).equals(other$layers)) {
            return false;
        }
        List<KerasLayer> this$layersOrdered = this.getLayersOrdered();
        List<KerasLayer> other$layersOrdered = other.getLayersOrdered();
        if (this$layersOrdered == null ? other$layersOrdered != null : !((Object)this$layersOrdered).equals(other$layersOrdered)) {
            return false;
        }
        Map<String, InputType> this$outputTypes = this.getOutputTypes();
        Map<String, InputType> other$outputTypes = other.getOutputTypes();
        if (this$outputTypes == null ? other$outputTypes != null : !((Object)this$outputTypes).equals(other$outputTypes)) {
            return false;
        }
        ArrayList<String> this$inputLayerNames = this.getInputLayerNames();
        ArrayList<String> other$inputLayerNames = other.getInputLayerNames();
        if (this$inputLayerNames == null ? other$inputLayerNames != null : !((Object)this$inputLayerNames).equals(other$inputLayerNames)) {
            return false;
        }
        ArrayList<String> this$outputLayerNames = this.getOutputLayerNames();
        ArrayList<String> other$outputLayerNames = other.getOutputLayerNames();
        if (this$outputLayerNames == null ? other$outputLayerNames != null : !((Object)this$outputLayerNames).equals(other$outputLayerNames)) {
            return false;
        }
        if (this.isUseTruncatedBPTT() != other.isUseTruncatedBPTT()) {
            return false;
        }
        if (this.getTruncatedBPTT() != other.getTruncatedBPTT()) {
            return false;
        }
        if (this.getKerasMajorVersion() != other.getKerasMajorVersion()) {
            return false;
        }
        String this$kerasBackend = this.getKerasBackend();
        String other$kerasBackend = other.getKerasBackend();
        if (this$kerasBackend == null ? other$kerasBackend != null : !this$kerasBackend.equals(other$kerasBackend)) {
            return false;
        }
        KerasLayer.DimOrder this$dimOrder = this.getDimOrder();
        KerasLayer.DimOrder other$dimOrder = other.getDimOrder();
        if (this$dimOrder == null ? other$dimOrder != null : !((Object)((Object)this$dimOrder)).equals((Object)other$dimOrder)) {
            return false;
        }
        IUpdater this$optimizer = this.getOptimizer();
        IUpdater other$optimizer = other.getOptimizer();
        return !(this$optimizer == null ? other$optimizer != null : !this$optimizer.equals(other$optimizer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KerasModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KerasModelBuilder $modelBuilder = this.getModelBuilder();
        result = result * 59 + ($modelBuilder == null ? 43 : ((Object)$modelBuilder).hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        result = result * 59 + (this.isEnforceTrainingConfig() ? 79 : 97);
        Map<String, KerasLayer> $layers = this.getLayers();
        result = result * 59 + ($layers == null ? 43 : ((Object)$layers).hashCode());
        List<KerasLayer> $layersOrdered = this.getLayersOrdered();
        result = result * 59 + ($layersOrdered == null ? 43 : ((Object)$layersOrdered).hashCode());
        Map<String, InputType> $outputTypes = this.getOutputTypes();
        result = result * 59 + ($outputTypes == null ? 43 : ((Object)$outputTypes).hashCode());
        ArrayList<String> $inputLayerNames = this.getInputLayerNames();
        result = result * 59 + ($inputLayerNames == null ? 43 : ((Object)$inputLayerNames).hashCode());
        ArrayList<String> $outputLayerNames = this.getOutputLayerNames();
        result = result * 59 + ($outputLayerNames == null ? 43 : ((Object)$outputLayerNames).hashCode());
        result = result * 59 + (this.isUseTruncatedBPTT() ? 79 : 97);
        result = result * 59 + this.getTruncatedBPTT();
        result = result * 59 + this.getKerasMajorVersion();
        String $kerasBackend = this.getKerasBackend();
        result = result * 59 + ($kerasBackend == null ? 43 : $kerasBackend.hashCode());
        KerasLayer.DimOrder $dimOrder = this.getDimOrder();
        result = result * 59 + ($dimOrder == null ? 43 : ((Object)((Object)$dimOrder)).hashCode());
        IUpdater $optimizer = this.getOptimizer();
        result = result * 59 + ($optimizer == null ? 43 : $optimizer.hashCode());
        return result;
    }

    public String toString() {
        return "KerasModel(modelBuilder=" + this.getModelBuilder() + ", className=" + this.getClassName() + ", enforceTrainingConfig=" + this.isEnforceTrainingConfig() + ", layers=" + this.getLayers() + ", layersOrdered=" + this.getLayersOrdered() + ", outputTypes=" + this.getOutputTypes() + ", inputLayerNames=" + this.getInputLayerNames() + ", outputLayerNames=" + this.getOutputLayerNames() + ", useTruncatedBPTT=" + this.isUseTruncatedBPTT() + ", truncatedBPTT=" + this.getTruncatedBPTT() + ", kerasMajorVersion=" + this.getKerasMajorVersion() + ", kerasBackend=" + this.getKerasBackend() + ", dimOrder=" + (Object)((Object)this.getDimOrder()) + ", optimizer=" + this.getOptimizer() + ")";
    }
}

