/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.core;

import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.preprocessors.ReshapePreprocessor;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;
import org.nd4j.linalg.util.ArrayUtil;

public class KerasReshape
extends KerasLayer {
    private int[] targetShape;

    public KerasReshape(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasReshape(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, this.conf);
        String targetShape = "target_shape";
        if (innerConfig.containsKey(targetShape)) {
            List targetShapeList = (List)innerConfig.get(targetShape);
            this.targetShape = ArrayUtil.toArray((List)targetShapeList);
        }
    }

    @Override
    public boolean isInputPreProcessor() {
        return true;
    }

    @Override
    public InputPreProcessor getInputPreprocessor(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Reshape layer accepts only one input (received " + inputType.length + ")");
        }
        ReshapePreprocessor preprocessor = null;
        if (inputType[0] instanceof InputType.InputTypeConvolutional) {
            InputType.InputTypeConvolutional it = (InputType.InputTypeConvolutional)inputType[0];
            int[] inputShape = new int[]{it.getChannels(), it.getHeight(), it.getWidth()};
            switch (this.getDimOrder()) {
                case THEANO: {
                    if (this.kerasMajorVersion == 1) {
                        this.targetShape = new int[]{this.targetShape[1], this.targetShape[0], this.targetShape[2]};
                    }
                    preprocessor = new ReshapePreprocessor(inputShape, this.targetShape);
                    break;
                }
                case NONE: 
                case TENSORFLOW: {
                    if (inputShape[0] != this.targetShape[0]) {
                        this.targetShape = new int[]{this.targetShape[2], this.targetShape[0], this.targetShape[1]};
                    }
                    preprocessor = new ReshapePreprocessor(inputShape, this.targetShape);
                }
            }
        } else if (inputType[0] instanceof InputType.InputTypeRecurrent) {
            InputType.InputTypeRecurrent it = (InputType.InputTypeRecurrent)inputType[0];
            int[] inputShape = new int[]{it.getSize(), it.getTimeSeriesLength()};
            preprocessor = new ReshapePreprocessor(inputShape, this.targetShape);
        } else if (inputType[0] instanceof InputType.InputTypeFeedForward) {
            InputType.InputTypeFeedForward it = (InputType.InputTypeFeedForward)inputType[0];
            int[] inputShape = new int[]{it.getSize()};
            preprocessor = new ReshapePreprocessor(inputShape, this.targetShape);
        }
        return preprocessor;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Reshape layer accepts only one input (received " + inputType.length + ")");
        }
        ReshapePreprocessor reshape = (ReshapePreprocessor)this.getInputPreprocessor(inputType);
        return reshape.getOutputType(inputType[0]);
    }
}

