/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.pooling;

import java.util.Arrays;
import java.util.Map;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.GlobalPoolingLayer;
import org.deeplearning4j.nn.conf.preprocessor.FeedForwardToRnnPreProcessor;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.layers.pooling.KerasPoolingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasGlobalPooling
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasGlobalPooling.class);
    private final int[] dimensions;

    public KerasGlobalPooling(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasGlobalPooling(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        this.dimensions = KerasPoolingUtils.mapGlobalPoolingDimensions(this.className, this.conf);
        GlobalPoolingLayer.Builder builder = (GlobalPoolingLayer.Builder)((GlobalPoolingLayer.Builder)new GlobalPoolingLayer.Builder(KerasPoolingUtils.mapPoolingType(this.className, this.conf)).poolingDimensions(this.dimensions).collapseDimensions(true).name(this.layerName)).dropOut(this.dropout);
        this.layer = builder.build();
        this.vertex = null;
    }

    public GlobalPoolingLayer getGlobalPoolingLayer() {
        return (GlobalPoolingLayer)this.layer;
    }

    @Override
    public InputPreProcessor getInputPreprocessor(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras GlobalPooling layer accepts only one input (received " + inputType.length + ")");
        }
        Object preprocessor = inputType[0].getType() == InputType.Type.FF && this.dimensions.length == 1 ? new FeedForwardToRnnPreProcessor() : this.getGlobalPoolingLayer().getPreProcessorForInputType(inputType[0]);
        return preprocessor;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Subsampling layer accepts only one input (received " + inputType.length + ")");
        }
        InputPreProcessor preprocessor = this.getInputPreprocessor(inputType[0]);
        if (preprocessor != null) {
            return this.getGlobalPoolingLayer().getOutputType(-1, preprocessor.getOutputType(inputType[0]));
        }
        return this.getGlobalPoolingLayer().getOutputType(-1, inputType[0]);
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public String toString() {
        return "KerasGlobalPooling(dimensions=" + Arrays.toString(this.getDimensions()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KerasGlobalPooling)) {
            return false;
        }
        KerasGlobalPooling other = (KerasGlobalPooling)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getDimensions(), other.getDimensions());
    }

    protected boolean canEqual(Object other) {
        return other instanceof KerasGlobalPooling;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getDimensions());
        return result;
    }
}

