/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.convolutional;

import java.util.Map;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ZeroPaddingLayer;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolutionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasZeroPadding2D
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasZeroPadding2D.class);

    public KerasZeroPadding2D(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasZeroPadding2D(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        String paddingField = this.conf.getLAYER_FIELD_ZERO_PADDING();
        ZeroPaddingLayer.Builder builder = (ZeroPaddingLayer.Builder)((ZeroPaddingLayer.Builder)new ZeroPaddingLayer.Builder(KerasConvolutionUtils.getPaddingFromConfig(layerConfig, this.conf, paddingField, 2)).dataFormat(this.dimOrder == KerasLayer.DimOrder.TENSORFLOW ? CNN2DFormat.NHWC : CNN2DFormat.NCHW).name(this.layerName)).dropOut(this.dropout);
        this.layer = builder.build();
        this.vertex = null;
    }

    public ZeroPaddingLayer getZeroPadding2DLayer() {
        return (ZeroPaddingLayer)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras ZeroPadding layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getZeroPadding2DLayer().getOutputType(-1, inputType[0]);
    }

    public String toString() {
        return "KerasZeroPadding2D()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KerasZeroPadding2D)) {
            return false;
        }
        KerasZeroPadding2D other = (KerasZeroPadding2D)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof KerasZeroPadding2D;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

