/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers;

import java.util.Map;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.modelimport.keras.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.UnsupportedKerasConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasPooling
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasPooling.class);

    public KerasPooling(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasPooling(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        SubsamplingLayer.Builder builder = ((SubsamplingLayer.Builder)((SubsamplingLayer.Builder)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder(KerasPooling.mapPoolingType(this.className)).name(this.layerName)).dropOut(this.dropout)).convolutionMode(KerasPooling.getConvolutionModeFromConfig(layerConfig))).kernelSize(KerasPooling.getKernelSizeFromConfig(layerConfig)).stride(KerasPooling.getStrideFromConfig(layerConfig));
        int[] padding = this.getPaddingFromBorderModeConfig(layerConfig);
        if (padding != null) {
            builder.padding(padding);
        }
        this.layer = builder.build();
        this.vertex = null;
    }

    public SubsamplingLayer getSubsamplingLayer() {
        return (SubsamplingLayer)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Subsampling layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getSubsamplingLayer().getOutputType(-1, inputType[0]);
    }
}

