/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.keras;

import org.deeplearning4j.keras.EntryPointFitParameters;
import org.deeplearning4j.keras.HDF5MiniBatchDataSetIterator;
import org.deeplearning4j.keras.NeuralNetworkReader;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepLearning4jEntryPoint {
    private static final Logger log = LoggerFactory.getLogger(DeepLearning4jEntryPoint.class);
    private final NeuralNetworkReader neuralNetworkReader = new NeuralNetworkReader();

    public void fit(EntryPointFitParameters entryPointFitParameters) throws Exception {
        try {
            MultiLayerNetwork multiLayerNetwork = this.neuralNetworkReader.readNeuralNetwork(entryPointFitParameters);
            HDF5MiniBatchDataSetIterator dataSetIterator = new HDF5MiniBatchDataSetIterator(entryPointFitParameters.getTrainFeaturesDirectory(), entryPointFitParameters.getTrainLabelsDirectory());
            int i = 0;
            while ((long)i < entryPointFitParameters.getNbEpoch()) {
                log.info("Fitting: " + i);
                multiLayerNetwork.fit((DataSetIterator)dataSetIterator);
                ++i;
            }
            log.info("Learning model finished");
        }
        catch (Throwable e) {
            log.error("Error while handling request!", e);
            throw e;
        }
    }
}

