/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.graph.graph;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.deeplearning4j.graph.api.BaseGraph;
import org.deeplearning4j.graph.api.Edge;
import org.deeplearning4j.graph.api.Vertex;
import org.deeplearning4j.graph.exception.NoEdgesException;
import org.deeplearning4j.graph.vertexfactory.VertexFactory;

public class Graph<V, E>
extends BaseGraph<V, E> {
    private boolean allowMultipleEdges;
    private List<Edge<E>>[] edges;
    private List<Vertex<V>> vertices;

    public Graph(int numVertices, VertexFactory<V> vertexFactory) {
        this(numVertices, false, vertexFactory);
    }

    public Graph(int numVertices, boolean allowMultipleEdges, VertexFactory<V> vertexFactory) {
        if (numVertices <= 0) {
            throw new IllegalArgumentException();
        }
        this.allowMultipleEdges = allowMultipleEdges;
        this.vertices = new ArrayList<Vertex<V>>(numVertices);
        for (int i = 0; i < numVertices; ++i) {
            this.vertices.add(vertexFactory.create(i));
        }
        this.edges = (List[])Array.newInstance(List.class, numVertices);
    }

    public Graph(List<Vertex<V>> vertices, boolean allowMultipleEdges) {
        this.vertices = new ArrayList<Vertex<V>>(vertices);
        this.allowMultipleEdges = allowMultipleEdges;
        this.edges = (List[])Array.newInstance(List.class, vertices.size());
    }

    public Graph(List<Vertex<V>> vertices) {
        this(vertices, false);
    }

    @Override
    public int numVertices() {
        return this.vertices.size();
    }

    @Override
    public Vertex<V> getVertex(int idx) {
        if (idx < 0 || idx >= this.vertices.size()) {
            throw new IllegalArgumentException("Invalid index: " + idx);
        }
        return this.vertices.get(idx);
    }

    @Override
    public List<Vertex<V>> getVertices(int[] indexes) {
        ArrayList<Vertex<V>> out = new ArrayList<Vertex<V>>(indexes.length);
        for (int i : indexes) {
            out.add(this.getVertex(i));
        }
        return out;
    }

    @Override
    public List<Vertex<V>> getVertices(int from, int to) {
        if (to < from || from < 0 || to >= this.vertices.size()) {
            throw new IllegalArgumentException("Invalid range: from=" + from + ", to=" + to);
        }
        ArrayList<Vertex<V>> out = new ArrayList<Vertex<V>>(to - from + 1);
        for (int i = from; i <= to; ++i) {
            out.add(this.getVertex(i));
        }
        return out;
    }

    @Override
    public void addEdge(Edge<E> edge) {
        if (edge.getFrom() < 0 || edge.getTo() >= this.vertices.size()) {
            throw new IllegalArgumentException("Invalid edge: " + edge + ", from/to indexes out of range");
        }
        List<Edge<Edge<Edge<Edge<E>>>>> fromList = this.edges[edge.getFrom()];
        if (fromList == null) {
            fromList = new ArrayList<Edge<E>>();
            this.edges[edge.getFrom()] = fromList;
        }
        this.addEdgeHelper(edge, fromList);
        if (edge.isDirected()) {
            return;
        }
        List<Edge<Edge<Edge<Edge<E>>>>> toList = this.edges[edge.getTo()];
        if (toList == null) {
            toList = new ArrayList<Edge<E>>();
            this.edges[edge.getTo()] = toList;
        }
        this.addEdgeHelper(edge, toList);
    }

    @Override
    public List<Edge<E>> getEdgesOut(int vertex) {
        if (this.edges[vertex] == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Edge<E>>(this.edges[vertex]);
    }

    @Override
    public int getVertexDegree(int vertex) {
        if (this.edges[vertex] == null) {
            return 0;
        }
        return this.edges[vertex].size();
    }

    @Override
    public Vertex<V> getRandomConnectedVertex(int vertex, Random rng) throws NoEdgesException {
        if (vertex < 0 || vertex >= this.vertices.size()) {
            throw new IllegalArgumentException("Invalid vertex index: " + vertex);
        }
        if (this.edges[vertex] == null || this.edges[vertex].isEmpty()) {
            throw new NoEdgesException("Cannot generate random connected vertex: vertex " + vertex + " has no outgoing/undirected edges");
        }
        int connectedVertexNum = rng.nextInt(this.edges[vertex].size());
        Edge<E> edge = this.edges[vertex].get(connectedVertexNum);
        if (edge.getFrom() == vertex) {
            return this.vertices.get(edge.getTo());
        }
        return this.vertices.get(edge.getFrom());
    }

    @Override
    public List<Vertex<V>> getConnectedVertices(int vertex) {
        if (vertex < 0 || vertex >= this.vertices.size()) {
            throw new IllegalArgumentException("Invalid vertex index: " + vertex);
        }
        if (this.edges[vertex] == null) {
            return Collections.emptyList();
        }
        ArrayList<Vertex<V>> list = new ArrayList<Vertex<V>>(this.edges[vertex].size());
        for (Edge<E> edge : this.edges[vertex]) {
            list.add(this.vertices.get(edge.getTo()));
        }
        return list;
    }

    @Override
    public int[] getConnectedVertexIndices(int vertex) {
        int[] out = new int[this.edges[vertex] == null ? 0 : this.edges[vertex].size()];
        if (out.length == 0) {
            return out;
        }
        for (int i = 0; i < out.length; ++i) {
            Edge<E> e = this.edges[vertex].get(i);
            out[i] = e.getFrom() == vertex ? e.getTo() : e.getFrom();
        }
        return out;
    }

    private void addEdgeHelper(Edge<E> edge, List<Edge<E>> list) {
        if (!this.allowMultipleEdges) {
            boolean duplicate = false;
            if (edge.isDirected()) {
                for (Edge<Edge<Edge<E>>> edge2 : list) {
                    if (edge2.getTo() != edge.getTo()) continue;
                    duplicate = true;
                    break;
                }
            } else {
                for (Edge<Edge<Edge<E>>> edge3 : list) {
                    if ((edge3.getFrom() != edge.getFrom() || edge3.getTo() != edge.getTo()) && (edge3.getTo() != edge.getFrom() || edge3.getFrom() != edge.getTo())) continue;
                    duplicate = true;
                    break;
                }
            }
            if (!duplicate) {
                list.add(edge);
            }
        } else {
            list.add(edge);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Graph {");
        sb.append("\nVertices {");
        for (Vertex<V> v : this.vertices) {
            sb.append("\n\t").append(v);
        }
        sb.append("\n}");
        sb.append("\nEdges {");
        for (int i = 0; i < this.edges.length; ++i) {
            sb.append("\n\t");
            if (this.edges[i] == null) continue;
            sb.append(i).append(":");
            for (Edge<E> e : this.edges[i]) {
                sb.append(" ").append(e);
            }
        }
        sb.append("\n}");
        sb.append("\n}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Graph)) {
            return false;
        }
        Graph g = (Graph)o;
        if (this.allowMultipleEdges != g.allowMultipleEdges) {
            return false;
        }
        if (this.edges.length != g.edges.length) {
            return false;
        }
        if (this.vertices.size() != g.vertices.size()) {
            return false;
        }
        for (int i = 0; i < this.edges.length; ++i) {
            if (this.edges[i].equals(g.edges[i])) continue;
            return false;
        }
        return this.vertices.equals(g.vertices);
    }

    public int hashCode() {
        int result = 23;
        result = 31 * result + (this.allowMultipleEdges ? 1 : 0);
        result = 31 * result + Arrays.hashCode(this.edges);
        result = 31 * result + this.vertices.hashCode();
        return result;
    }
}

