/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.graph.iterator;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import org.deeplearning4j.graph.VertexSequence;
import org.deeplearning4j.graph.api.Edge;
import org.deeplearning4j.graph.api.IGraph;
import org.deeplearning4j.graph.api.IVertexSequence;
import org.deeplearning4j.graph.api.NoEdgeHandling;
import org.deeplearning4j.graph.exception.NoEdgesException;
import org.deeplearning4j.graph.iterator.GraphWalkIterator;

public class WeightedRandomWalkIterator<V>
implements GraphWalkIterator<V> {
    private final IGraph<V, ? extends Number> graph;
    private final int walkLength;
    private final NoEdgeHandling mode;
    private final int firstVertex;
    private final int lastVertex;
    private int position;
    private Random rng;
    private int[] order;

    public WeightedRandomWalkIterator(IGraph<V, ? extends Number> graph, int walkLength) {
        this(graph, walkLength, System.currentTimeMillis(), NoEdgeHandling.EXCEPTION_ON_DISCONNECTED);
    }

    public WeightedRandomWalkIterator(IGraph<V, ? extends Number> graph, int walkLength, long rngSeed) {
        this(graph, walkLength, rngSeed, NoEdgeHandling.EXCEPTION_ON_DISCONNECTED);
    }

    public WeightedRandomWalkIterator(IGraph<V, ? extends Number> graph, int walkLength, long rngSeed, NoEdgeHandling mode) {
        this(graph, walkLength, rngSeed, mode, 0, graph.numVertices());
    }

    public WeightedRandomWalkIterator(IGraph<V, ? extends Number> graph, int walkLength, long rngSeed, NoEdgeHandling mode, int firstVertex, int lastVertex) {
        this.graph = graph;
        this.walkLength = walkLength;
        this.rng = new Random(rngSeed);
        this.mode = mode;
        this.firstVertex = firstVertex;
        this.lastVertex = lastVertex;
        this.order = new int[lastVertex - firstVertex];
        for (int i = 0; i < this.order.length; ++i) {
            this.order[i] = firstVertex + i;
        }
        this.reset();
    }

    @Override
    public IVertexSequence<V> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int currVertexIdx = this.order[this.position++];
        int[] indices = new int[this.walkLength + 1];
        indices[0] = currVertexIdx;
        if (this.walkLength == 0) {
            return new VertexSequence<V>(this.graph, indices);
        }
        block4: for (int i = 1; i <= this.walkLength; ++i) {
            List<Edge<? extends Number>> edgeList = this.graph.getEdgesOut(currVertexIdx);
            if (edgeList == null || edgeList.isEmpty()) {
                switch (this.mode) {
                    case SELF_LOOP_ON_DISCONNECTED: {
                        for (int j = i; j < this.walkLength; ++j) {
                            indices[j] = currVertexIdx;
                        }
                        return new VertexSequence<V>(this.graph, indices);
                    }
                    case EXCEPTION_ON_DISCONNECTED: {
                        throw new NoEdgesException("Cannot conduct random walk: vertex " + currVertexIdx + " has no outgoing edges.  Set NoEdgeHandling mode to NoEdgeHandlingMode.SELF_LOOP_ON_DISCONNECTED to self loop instead of throwing an exception in this situation.");
                    }
                }
                throw new RuntimeException("Unknown/not implemented NoEdgeHandling mode: " + this.mode);
            }
            double totalWeight = 0.0;
            for (Edge<? extends Number> edge : edgeList) {
                totalWeight += edge.getValue().doubleValue();
            }
            double d = this.rng.nextDouble();
            double threshold = d * totalWeight;
            double sumWeight = 0.0;
            for (Edge<? extends Number> edge : edgeList) {
                if (!((sumWeight += edge.getValue().doubleValue()) >= threshold)) continue;
                currVertexIdx = edge.isDirected() ? edge.getTo() : (edge.getFrom() == currVertexIdx ? edge.getTo() : edge.getFrom());
                indices[i] = currVertexIdx;
                continue block4;
            }
        }
        return new VertexSequence<V>(this.graph, indices);
    }

    @Override
    public boolean hasNext() {
        return this.position < this.order.length;
    }

    @Override
    public void reset() {
        this.position = 0;
        for (int i = this.order.length - 1; i > 0; --i) {
            int j = this.rng.nextInt(i + 1);
            int temp = this.order[j];
            this.order[j] = this.order[i];
            this.order[i] = temp;
        }
    }

    @Override
    public int walkLength() {
        return this.walkLength;
    }
}

