/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.graph.data.impl;

import org.deeplearning4j.graph.api.Edge;
import org.deeplearning4j.graph.data.EdgeLineProcessor;

public class WeightedEdgeLineProcessor
implements EdgeLineProcessor<Double> {
    private final String delimiter;
    private final String[] skipLinesStartingWith;
    private final boolean directed;

    public WeightedEdgeLineProcessor(String delimiter, boolean directed) {
        this(delimiter, directed, null);
    }

    public WeightedEdgeLineProcessor(String delimiter, boolean directed, String ... skipLinesStartingWith) {
        this.delimiter = delimiter;
        this.skipLinesStartingWith = skipLinesStartingWith;
        this.directed = directed;
    }

    @Override
    public Edge<Double> processLine(String line) {
        String[] split;
        if (this.skipLinesStartingWith != null) {
            for (String s : this.skipLinesStartingWith) {
                if (!line.startsWith(s)) continue;
                return null;
            }
        }
        if ((split = line.split(this.delimiter)).length != 3) {
            throw new IllegalArgumentException("Invalid line: expected format \"0" + this.delimiter + "1" + this.delimiter + "weight\"; received \"" + line + "\"");
        }
        int from = Integer.parseInt(split[0]);
        int to = Integer.parseInt(split[1]);
        double weight = Double.parseDouble(split[2]);
        return new Edge<Double>(from, to, weight, this.directed);
    }
}

