/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.graph.api;

public class Edge<T> {
    private final int from;
    private final int to;
    private final T value;
    private final boolean directed;

    public Edge(int from, int to, T value, boolean directed) {
        this.from = from;
        this.to = to;
        this.value = value;
        this.directed = directed;
    }

    public String toString() {
        return "edge(" + (this.directed ? "directod" : "undirected") + "," + this.from + (this.directed ? "->" : "--") + this.to + "," + (this.value != null ? this.value : "") + ")";
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public T getValue() {
        return this.value;
    }

    public boolean isDirected() {
        return this.directed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Edge)) {
            return false;
        }
        Edge other = (Edge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFrom() != other.getFrom()) {
            return false;
        }
        if (this.getTo() != other.getTo()) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        return this.isDirected() == other.isDirected();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Edge;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFrom();
        result = result * 59 + this.getTo();
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 0 : $value.hashCode());
        result = result * 59 + (this.isDirected() ? 79 : 97);
        return result;
    }
}

