/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.base;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.deeplearning4j.common.resources.DL4JResources;
import org.deeplearning4j.common.resources.ResourceType;
import org.nd4j.resources.Downloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MnistFetcher {
    private static final Logger log = LoggerFactory.getLogger(MnistFetcher.class);
    protected static final String LOCAL_DIR_NAME = "MNIST";
    private File fileDir;
    private static final String TRAINING_FILES_URL_RELATIVE = "datasets/mnist/train-images-idx3-ubyte.gz";
    private static final String TRAINING_FILES_MD_5 = "f68b3c2dcbeaaa9fbdd348bbdeb94873";
    private static final String TRAINING_FILES_FILENAME = "train-images-idx3-ubyte.gz";
    public static final String TRAINING_FILES_FILENAME_UNZIPPED = "train-images-idx3-ubyte";
    private static final String TRAINING_FILE_LABELS_URL_RELATIVE = "datasets/mnist/train-labels-idx1-ubyte.gz";
    private static final String TRAINING_FILE_LABELS_MD_5 = "d53e105ee54ea40749a09fcbcd1e9432";
    private static final String TRAINING_FILE_LABELS_FILENAME = "train-labels-idx1-ubyte.gz";
    public static final String TRAINING_FILE_LABELS_FILENAME_UNZIPPED = "train-labels-idx1-ubyte";
    private static final String TEST_FILES_URL_RELATIVE = "datasets/mnist/t10k-images-idx3-ubyte.gz";
    private static final String TEST_FILES_MD_5 = "9fb629c4189551a2d022fa330f9573f3";
    private static final String TEST_FILES_FILENAME = "t10k-images-idx3-ubyte.gz";
    public static final String TEST_FILES_FILENAME_UNZIPPED = "t10k-images-idx3-ubyte";
    private static final String TEST_FILE_LABELS_URL_RELATIVE = "datasets/mnist/t10k-labels-idx1-ubyte.gz";
    private static final String TEST_FILE_LABELS_MD_5 = "ec29112dd5afa0611ce80d1b7f02629c";
    private static final String TEST_FILE_LABELS_FILENAME = "t10k-labels-idx1-ubyte.gz";
    public static final String TEST_FILE_LABELS_FILENAME_UNZIPPED = "t10k-labels-idx1-ubyte";

    public String getName() {
        return LOCAL_DIR_NAME;
    }

    public File getBaseDir() {
        return DL4JResources.getDirectory((ResourceType)ResourceType.DATASET, (String)this.getName());
    }

    public String getTrainingFilesURL() {
        return DL4JResources.getURLString((String)TRAINING_FILES_URL_RELATIVE);
    }

    public String getTrainingFilesMD5() {
        return TRAINING_FILES_MD_5;
    }

    public String getTrainingFilesFilename() {
        return TRAINING_FILES_FILENAME;
    }

    public String getTrainingFilesFilename_unzipped() {
        return TRAINING_FILES_FILENAME_UNZIPPED;
    }

    public String getTrainingFileLabelsURL() {
        return DL4JResources.getURLString((String)TRAINING_FILE_LABELS_URL_RELATIVE);
    }

    public String getTrainingFileLabelsMD5() {
        return TRAINING_FILE_LABELS_MD_5;
    }

    public String getTrainingFileLabelsFilename() {
        return TRAINING_FILE_LABELS_FILENAME;
    }

    public String getTrainingFileLabelsFilename_unzipped() {
        return TRAINING_FILE_LABELS_FILENAME_UNZIPPED;
    }

    public String getTestFilesURL() {
        return DL4JResources.getURLString((String)TEST_FILES_URL_RELATIVE);
    }

    public String getTestFilesMD5() {
        return TEST_FILES_MD_5;
    }

    public String getTestFilesFilename() {
        return TEST_FILES_FILENAME;
    }

    public String getTestFilesFilename_unzipped() {
        return TEST_FILES_FILENAME_UNZIPPED;
    }

    public String getTestFileLabelsURL() {
        return DL4JResources.getURLString((String)TEST_FILE_LABELS_URL_RELATIVE);
    }

    public String getTestFileLabelsMD5() {
        return TEST_FILE_LABELS_MD_5;
    }

    public String getTestFileLabelsFilename() {
        return TEST_FILE_LABELS_FILENAME;
    }

    public String getTestFileLabelsFilename_unzipped() {
        return TEST_FILE_LABELS_FILENAME_UNZIPPED;
    }

    public File downloadAndUntar() throws IOException {
        if (this.fileDir != null) {
            return this.fileDir;
        }
        File baseDir = this.getBaseDir();
        if (!baseDir.isDirectory() && !baseDir.mkdir()) {
            throw new IOException("Could not mkdir " + baseDir);
        }
        log.info("Downloading {}...", (Object)this.getName());
        File trainFeatures = new File(baseDir, this.getTrainingFilesFilename());
        File testFeatures = new File(baseDir, this.getTestFilesFilename());
        Downloader.downloadAndExtract((String)LOCAL_DIR_NAME, (URL)new URL(this.getTrainingFilesURL()), (File)trainFeatures, (File)baseDir, (String)this.getTrainingFilesMD5(), (int)3);
        Downloader.downloadAndExtract((String)LOCAL_DIR_NAME, (URL)new URL(this.getTestFilesURL()), (File)testFeatures, (File)baseDir, (String)this.getTestFilesMD5(), (int)3);
        File trainLabels = new File(baseDir, this.getTrainingFileLabelsFilename());
        File testLabels = new File(baseDir, this.getTestFileLabelsFilename());
        Downloader.downloadAndExtract((String)LOCAL_DIR_NAME, (URL)new URL(this.getTrainingFileLabelsURL()), (File)trainLabels, (File)baseDir, (String)this.getTrainingFileLabelsMD5(), (int)3);
        Downloader.downloadAndExtract((String)LOCAL_DIR_NAME, (URL)new URL(this.getTestFileLabelsURL()), (File)testLabels, (File)baseDir, (String)this.getTestFileLabelsMD5(), (int)3);
        this.fileDir = baseDir;
        return this.fileDir;
    }

    public File getFileDir() {
        return this.fileDir;
    }

    public void setFileDir(File fileDir) {
        this.fileDir = fileDir;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MnistFetcher)) {
            return false;
        }
        MnistFetcher other = (MnistFetcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$fileDir = this.getFileDir();
        File other$fileDir = other.getFileDir();
        return !(this$fileDir == null ? other$fileDir != null : !((Object)this$fileDir).equals(other$fileDir));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MnistFetcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $fileDir = this.getFileDir();
        result = result * 59 + ($fileDir == null ? 43 : ((Object)$fileDir).hashCode());
        return result;
    }

    public String toString() {
        return "MnistFetcher(fileDir=" + this.getFileDir() + ")";
    }
}

