/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.base;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.nd4j.util.ArchiveUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MnistFetcher {
    protected static final Logger log = LoggerFactory.getLogger(MnistFetcher.class);
    protected File BASE_DIR = new File(System.getProperty("user.home"));
    protected static final String LOCAL_DIR_NAME = "MNIST";
    protected File FILE_DIR = new File(this.BASE_DIR, "MNIST");
    private File fileDir;
    private static final String TRAINING_FILES_URL = "http://deeplearning4j-resources.westus2.cloudapp.azure.com/mnist/train-images-idx3-ubyte.gz";
    private static final String TRAINING_FILES_MD_5 = "f68b3c2dcbeaaa9fbdd348bbdeb94873";
    private static final String TRAINING_FILES_FILENAME = "train-images-idx3-ubyte.gz";
    public static final String TRAINING_FILES_FILENAME_UNZIPPED = "train-images-idx3-ubyte";
    private static final String TRAINING_FILE_LABELS_URL = "http://deeplearning4j-resources.westus2.cloudapp.azure.com/mnist/train-labels-idx1-ubyte.gz";
    private static final String TRAINING_FILE_LABELS_MD_5 = "d53e105ee54ea40749a09fcbcd1e9432";
    private static final String TRAINING_FILE_LABELS_FILENAME = "train-labels-idx1-ubyte.gz";
    public static final String TRAINING_FILE_LABELS_FILENAME_UNZIPPED = "train-labels-idx1-ubyte";
    private static final String TEST_FILES_URL = "http://deeplearning4j-resources.westus2.cloudapp.azure.com/mnist/t10k-images-idx3-ubyte.gz";
    private static final String TEST_FILES_MD_5 = "9fb629c4189551a2d022fa330f9573f3";
    private static final String TEST_FILES_FILENAME = "t10k-images-idx3-ubyte.gz";
    public static final String TEST_FILES_FILENAME_UNZIPPED = "t10k-images-idx3-ubyte";
    private static final String TEST_FILE_LABELS_URL = "http://deeplearning4j-resources.westus2.cloudapp.azure.com/mnist/t10k-labels-idx1-ubyte.gz";
    private static final String TEST_FILE_LABELS_MD_5 = "ec29112dd5afa0611ce80d1b7f02629c";
    private static final String TEST_FILE_LABELS_FILENAME = "t10k-labels-idx1-ubyte.gz";
    public static final String TEST_FILE_LABELS_FILENAME_UNZIPPED = "t10k-labels-idx1-ubyte";

    public String getName() {
        return LOCAL_DIR_NAME;
    }

    public File getBaseDir() {
        return this.FILE_DIR;
    }

    public String getTrainingFilesURL() {
        return TRAINING_FILES_URL;
    }

    public String getTrainingFilesMD5() {
        return TRAINING_FILES_MD_5;
    }

    public String getTrainingFilesFilename() {
        return TRAINING_FILES_FILENAME;
    }

    public String getTrainingFilesFilename_unzipped() {
        return TRAINING_FILES_FILENAME_UNZIPPED;
    }

    public String getTrainingFileLabelsURL() {
        return TRAINING_FILE_LABELS_URL;
    }

    public String getTrainingFileLabelsMD5() {
        return TRAINING_FILE_LABELS_MD_5;
    }

    public String getTrainingFileLabelsFilename() {
        return TRAINING_FILE_LABELS_FILENAME;
    }

    public String getTrainingFileLabelsFilename_unzipped() {
        return TRAINING_FILE_LABELS_FILENAME_UNZIPPED;
    }

    public String getTestFilesURL() {
        return TEST_FILES_URL;
    }

    public String getTestFilesMD5() {
        return TEST_FILES_MD_5;
    }

    public String getTestFilesFilename() {
        return TEST_FILES_FILENAME;
    }

    public String getTestFilesFilename_unzipped() {
        return TEST_FILES_FILENAME_UNZIPPED;
    }

    public String getTestFileLabelsURL() {
        return TEST_FILE_LABELS_URL;
    }

    public String getTestFileLabelsMD5() {
        return TEST_FILE_LABELS_MD_5;
    }

    public String getTestFileLabelsFilename() {
        return TEST_FILE_LABELS_FILENAME;
    }

    public String getTestFileLabelsFilename_unzipped() {
        return TEST_FILE_LABELS_FILENAME_UNZIPPED;
    }

    public File downloadAndUntar() throws IOException {
        if (this.fileDir != null) {
            return this.fileDir;
        }
        File baseDir = this.getBaseDir();
        if (!baseDir.isDirectory() && !baseDir.mkdir()) {
            throw new IOException("Could not mkdir " + baseDir);
        }
        log.info("Downloading {}...", (Object)this.getName());
        File trainFeatures = new File(baseDir, this.getTrainingFilesFilename());
        File testFeatures = new File(baseDir, this.getTestFilesFilename());
        this.downloadAndExtract(new URL(this.getTrainingFilesURL()), trainFeatures, baseDir, this.getTrainingFilesMD5());
        this.downloadAndExtract(new URL(this.getTestFilesURL()), testFeatures, baseDir, this.getTestFilesMD5());
        File trainLabels = new File(baseDir, this.getTrainingFileLabelsFilename());
        File testLabels = new File(baseDir, this.getTestFileLabelsFilename());
        this.downloadAndExtract(new URL(this.getTrainingFileLabelsURL()), trainLabels, baseDir, this.getTrainingFileLabelsMD5());
        this.downloadAndExtract(new URL(this.getTestFileLabelsURL()), testLabels, baseDir, this.getTestFileLabelsMD5());
        this.fileDir = baseDir;
        return this.fileDir;
    }

    private void downloadAndExtract(URL url, File f, File extractToDir, String targetMD5) throws IOException {
        this.downloadAndExtract(0, url, f, extractToDir, targetMD5);
    }

    private void downloadAndExtract(int attempt, URL url, File f, File extractToDir, String targetMD5) throws IOException {
        boolean isCorrectFile;
        int maxTries = 3;
        boolean bl = isCorrectFile = f.exists() && f.isFile() && this.checkMD5OfFile(targetMD5, f);
        if (attempt < maxTries) {
            if (!isCorrectFile) {
                FileUtils.copyURLToFile((URL)url, (File)f);
                if (!this.checkMD5OfFile(targetMD5, f)) {
                    f.delete();
                    this.downloadAndExtract(attempt + 1, url, f, extractToDir, targetMD5);
                }
            }
            try {
                ArchiveUtils.unzipFileTo((String)f.getAbsolutePath(), (String)extractToDir.getAbsolutePath());
            }
            catch (Throwable t) {
                log.warn("Error extracting MNIST files from file {} - retrying...", (Object)f.getAbsolutePath(), (Object)t);
                f.delete();
                this.downloadAndExtract(attempt + 1, url, f, extractToDir, targetMD5);
            }
        } else if (!isCorrectFile) {
            throw new IOException("Could not download and extract " + url.getPath() + "\n properly despite trying " + maxTries + " times, check your connection. File info:\nTarget MD5: " + targetMD5 + "\nHash matches: " + this.checkMD5OfFile(targetMD5, f) + "\nIs valid file: " + f.isFile());
        }
    }

    private boolean checkMD5OfFile(String targetMD5, File file) throws IOException {
        FileInputStream in = FileUtils.openInputStream((File)file);
        String trueMd5 = DigestUtils.md5Hex((InputStream)in);
        IOUtils.closeQuietly((InputStream)in);
        return targetMD5.equals(trueMd5);
    }

    public static void gunzipFile(File baseDir, File gzFile) throws IOException {
        String s;
        log.info("gunzip'ing File: " + gzFile.toString());
        Process p = Runtime.getRuntime().exec(String.format("gunzip %s", gzFile.getAbsolutePath()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        log.info("Here is the standard error of the command (if any):\n");
        while ((s = stdError.readLine()) != null) {
            log.info(s);
        }
        stdError.close();
    }

    public File getBASE_DIR() {
        return this.BASE_DIR;
    }

    public File getFILE_DIR() {
        return this.FILE_DIR;
    }

    public File getFileDir() {
        return this.fileDir;
    }

    public void setBASE_DIR(File BASE_DIR) {
        this.BASE_DIR = BASE_DIR;
    }

    public void setFILE_DIR(File FILE_DIR) {
        this.FILE_DIR = FILE_DIR;
    }

    public void setFileDir(File fileDir) {
        this.fileDir = fileDir;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MnistFetcher)) {
            return false;
        }
        MnistFetcher other = (MnistFetcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$BASE_DIR = this.getBASE_DIR();
        File other$BASE_DIR = other.getBASE_DIR();
        if (this$BASE_DIR == null ? other$BASE_DIR != null : !((Object)this$BASE_DIR).equals(other$BASE_DIR)) {
            return false;
        }
        File this$FILE_DIR = this.getFILE_DIR();
        File other$FILE_DIR = other.getFILE_DIR();
        if (this$FILE_DIR == null ? other$FILE_DIR != null : !((Object)this$FILE_DIR).equals(other$FILE_DIR)) {
            return false;
        }
        File this$fileDir = this.getFileDir();
        File other$fileDir = other.getFileDir();
        return !(this$fileDir == null ? other$fileDir != null : !((Object)this$fileDir).equals(other$fileDir));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MnistFetcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $BASE_DIR = this.getBASE_DIR();
        result = result * 59 + ($BASE_DIR == null ? 43 : ((Object)$BASE_DIR).hashCode());
        File $FILE_DIR = this.getFILE_DIR();
        result = result * 59 + ($FILE_DIR == null ? 43 : ((Object)$FILE_DIR).hashCode());
        File $fileDir = this.getFileDir();
        result = result * 59 + ($fileDir == null ? 43 : ((Object)$fileDir).hashCode());
        return result;
    }

    public String toString() {
        return "MnistFetcher(BASE_DIR=" + this.getBASE_DIR() + ", FILE_DIR=" + this.getFILE_DIR() + ", fileDir=" + this.getFileDir() + ")";
    }
}

