/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.fetchers;

import java.io.File;
import java.util.LinkedList;
import java.util.Random;
import org.datavec.api.io.filters.PathFilter;
import org.datavec.api.io.filters.RandomPathFilter;
import org.datavec.api.io.labels.ParentPathLabelGenerator;
import org.datavec.api.io.labels.PathLabelGenerator;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.split.FileSplit;
import org.datavec.api.split.InputSplit;
import org.datavec.image.loader.BaseImageLoader;
import org.datavec.image.recordreader.ImageRecordReader;
import org.datavec.image.transform.ImageTransform;
import org.datavec.image.transform.MultiImageTransform;
import org.datavec.image.transform.ResizeImageTransform;
import org.deeplearning4j.datasets.fetchers.CacheableExtractableDataSetFetcher;
import org.deeplearning4j.datasets.fetchers.DataSetType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TinyImageNetFetcher
extends CacheableExtractableDataSetFetcher {
    private File fileDir;
    private static Logger log = LoggerFactory.getLogger(TinyImageNetFetcher.class);
    public static int INPUT_WIDTH = 64;
    public static int INPUT_HEIGHT = 64;
    public static int INPUT_CHANNELS = 3;
    public static int NUM_LABELS = 200;
    public static int NUM_EXAMPLES = NUM_LABELS * 500;

    @Override
    public String remoteDataUrl(DataSetType set) {
        return "http://blob.deeplearning4j.org/datasets/tinyimagenet_200_dl4j.v1.zip";
    }

    @Override
    public String localCacheName() {
        return "TINYIMAGENET_200";
    }

    @Override
    public long expectedChecksum(DataSetType set) {
        return 33822361L;
    }

    @Override
    public RecordReader getRecordReader(long rngSeed, int[] imgDim, DataSetType set, ImageTransform imageTransform) {
        File datasetPath;
        if (this.LOCAL_CACHE.exists() && this.LOCAL_CACHE.listFiles().length < 1) {
            this.LOCAL_CACHE.delete();
        }
        try {
            if (!this.LOCAL_CACHE.exists()) {
                this.downloadAndExtract();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not download TinyImageNet", e);
        }
        Random rng = new Random(rngSeed);
        switch (set) {
            case TRAIN: {
                datasetPath = new File(this.LOCAL_CACHE, "/train/");
                break;
            }
            case TEST: {
                datasetPath = new File(this.LOCAL_CACHE, "/test/");
                break;
            }
            case VALIDATION: {
                throw new IllegalArgumentException("You will need to manually iterate the /validation/images/ directory, TinyImageNet does not provide labels");
            }
            default: {
                datasetPath = new File(this.LOCAL_CACHE, "/train/");
            }
        }
        RandomPathFilter pathFilter = new RandomPathFilter(rng, BaseImageLoader.ALLOWED_FORMATS);
        FileSplit filesInDir = new FileSplit(datasetPath, BaseImageLoader.ALLOWED_FORMATS, rng);
        InputSplit[] filesInDirSplit = filesInDir.sample((PathFilter)pathFilter, new double[]{1.0});
        LinkedList<ImageTransform> transforms = new LinkedList<ImageTransform>();
        if (imgDim.length > 0) {
            new ResizeImageTransform(imgDim[0], imgDim[1]);
        }
        if (imageTransform != null) {
            transforms.add(imageTransform);
        }
        ImageRecordReader rr = new ImageRecordReader(INPUT_HEIGHT, INPUT_WIDTH, INPUT_CHANNELS, (PathLabelGenerator)new ParentPathLabelGenerator(), (ImageTransform)new MultiImageTransform(transforms.toArray(new ImageTransform[transforms.size()])));
        try {
            rr.initialize(filesInDirSplit[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return rr;
    }
}

