/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.common.config;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.ServiceLoader;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.config.ND4JClassLoading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DL4JClassLoading {
    private static final Logger log = LoggerFactory.getLogger(DL4JClassLoading.class);
    private static ClassLoader dl4jClassloader = ND4JClassLoading.getNd4jClassloader();

    private DL4JClassLoading() {
    }

    public static ClassLoader getDl4jClassloader() {
        return dl4jClassloader;
    }

    public static void setDl4jClassloaderFromClass(Class<?> clazz) {
        DL4JClassLoading.setDl4jClassloader(clazz.getClassLoader());
    }

    public static void setDl4jClassloader(ClassLoader dl4jClassloader) {
        DL4JClassLoading.dl4jClassloader = dl4jClassloader;
        log.debug("Global class-loader for DL4J was changed.");
    }

    public static boolean classPresentOnClasspath(String className) {
        return DL4JClassLoading.classPresentOnClasspath(className, dl4jClassloader);
    }

    public static boolean classPresentOnClasspath(String className, ClassLoader classLoader) {
        return DL4JClassLoading.loadClassByName(className, false, classLoader) != null;
    }

    public static <T> Class<T> loadClassByName(String className) {
        return DL4JClassLoading.loadClassByName(className, true, dl4jClassloader);
    }

    public static <T> Class<T> loadClassByName(String className, boolean initialize, ClassLoader classLoader) {
        try {
            return Class.forName(className, initialize, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.error(String.format("Cannot find class [%s] of provided class-loader.", className));
            return null;
        }
    }

    public static <T> T createNewInstance(String className) {
        return (T)DL4JClassLoading.createNewInstance(className, Object.class, new Object[0]);
    }

    public static <T> T createNewInstance(String className, Object[] args) {
        return (T)DL4JClassLoading.createNewInstance(className, Object.class, args);
    }

    public static <T> T createNewInstance(String className, Class<? super T> superclass) {
        return DL4JClassLoading.createNewInstance(className, superclass, new Class[0], new Object[0]);
    }

    public static <T> T createNewInstance(String className, Class<? super T> superclass, Object[] args) {
        Class[] parameterTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            Objects.requireNonNull(arg);
            parameterTypes[i] = arg.getClass();
        }
        return DL4JClassLoading.createNewInstance(className, superclass, parameterTypes, args);
    }

    public static <T> T createNewInstance(String className, Class<? super T> superclass, Class<?>[] parameterTypes, Object[] args) {
        try {
            Class<T> loadedClass = DL4JClassLoading.loadClassByName(className);
            Preconditions.checkNotNull(loadedClass, (String)("Attempted to load class " + className + " but failed. No class found with this name."));
            return loadedClass.asSubclass(superclass).getDeclaredConstructor(parameterTypes).newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException instantiationException) {
            log.error(String.format("Cannot create instance of class '%s'.", className), (Throwable)instantiationException);
            throw new RuntimeException(instantiationException);
        }
    }

    public static <S> ServiceLoader<S> loadService(Class<S> serviceClass) {
        return DL4JClassLoading.loadService(serviceClass, dl4jClassloader);
    }

    public static <S> ServiceLoader<S> loadService(Class<S> serviceClass, ClassLoader classLoader) {
        return ServiceLoader.load(serviceClass, classLoader);
    }
}

