/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.s2dao.valuetype.basic;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.TimeZone;
import org.dbflute.bhv.core.context.ResourceContext;
import org.dbflute.s2dao.valuetype.TnAbstractValueType;
import org.dbflute.s2dao.valuetype.basic.TimestampType;
import org.dbflute.system.DBFluteSystem;
import org.dbflute.util.DfTypeUtil;

public class LocalDateAsTimestampType
extends TnAbstractValueType {
    protected final TimestampType _timestampType = new TimestampType();

    public LocalDateAsTimestampType() {
        super(93);
    }

    @Override
    public Object getValue(ResultSet rs, int index) throws SQLException {
        return this.toLocalDate(this._timestampType.getValue(rs, index));
    }

    @Override
    public Object getValue(ResultSet rs, String columnName) throws SQLException {
        return this.toLocalDate(this._timestampType.getValue(rs, columnName));
    }

    @Override
    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return this.toLocalDate(this._timestampType.getValue(cs, index));
    }

    @Override
    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return this.toLocalDate(this._timestampType.getValue(cs, parameterName));
    }

    @Override
    public void bindValue(Connection conn, PreparedStatement ps, int index, Object value) throws SQLException {
        this._timestampType.bindValue(conn, ps, index, (Object)this.toTimestamp(value));
    }

    @Override
    public void bindValue(Connection conn, CallableStatement cs, String parameterName, Object value) throws SQLException {
        this._timestampType.bindValue(conn, cs, parameterName, (Object)this.toTimestamp(value));
    }

    protected Object toLocalDate(Object date) {
        return DfTypeUtil.toLocalDate(date, this.getTimeZone());
    }

    protected Timestamp toTimestamp(Object date) {
        return DfTypeUtil.toTimestamp(date, this.getTimeZone());
    }

    protected TimeZone getTimeZone() {
        TimeZone provided;
        if (ResourceContext.isExistResourceContextOnThread() && (provided = ResourceContext.provideMappingDateTimeZone()) != null) {
            return provided;
        }
        return DBFluteSystem.getFinalTimeZone();
    }
}

