/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.s2dao.extension;

import java.util.Arrays;
import java.util.TimeZone;
import org.dbflute.Entity;
import org.dbflute.dbmeta.DBMeta;
import org.dbflute.exception.RelationEntityNotFoundException;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.optional.SerializableOptionalThingExceptionThrower;
import org.dbflute.system.DBFluteSystem;
import org.dbflute.twowaysql.DisplaySqlBuilder;
import org.dbflute.twowaysql.style.BoundDateDisplayStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TnRelationRowOptionalNullThrower
extends SerializableOptionalThingExceptionThrower {
    private static final long serialVersionUID = 1L;
    private static final Logger _log = LoggerFactory.getLogger(TnRelationRowOptionalNullThrower.class);
    protected final Object _row;
    protected final String _propertyName;
    protected final String _invokePath;
    protected final String _sql;
    protected final Object[] _args;

    public TnRelationRowOptionalNullThrower(Object row, String propertyName, String invokePath, String sql, Object[] args) {
        this._row = row;
        this._propertyName = propertyName;
        this._invokePath = invokePath;
        this._sql = sql;
        this._args = args;
    }

    @Override
    public void throwNotFoundException() {
        this.throwRelationEntityNotFoundException();
    }

    protected void throwRelationEntityNotFoundException() {
        ExceptionMessageBuilder br;
        block12: {
            String localSuffix;
            String localTable;
            Entity entity;
            br = new ExceptionMessageBuilder();
            br.addNotice("Not found the relation entity.");
            br.addItem("Advice");
            br.addElement("Confirm the existence in your business rule.");
            br.addElement("If the relation entity might not exist, check it.");
            br.addElement("For example:");
            br.addElement("  (x):");
            br.addElement("    List<Member> memberList = memberBhv.selectList(cb -> {");
            br.addElement("        cb.setupSelect_MemberServiceAsOne();");
            br.addElement("    });");
            br.addElement("    for (Member member : memberList) {");
            br.addElement("        ... = member.getMemberServiceAsOne().alwaysPresent(...); // *No");
            br.addElement("    }");
            br.addElement("  (o):");
            br.addElement("    List<Member> memberList = memberBhv.selectList(cb -> {");
            br.addElement("        cb.setupSelect_MemberServiceAsOne();");
            br.addElement("    });");
            br.addElement("    for (Member member : memberList) {");
            br.addElement("        member.getMemberServiceAsOne().ifPresent(service -> {  // OK");
            br.addElement("            ... = service.getServicePointCount();");
            br.addElement("        });");
            br.addElement("    }");
            br.addItem("Your Operation");
            if (this._row instanceof Entity) {
                entity = (Entity)this._row;
                DBMeta dbmeta = entity.asDBMeta();
                localTable = dbmeta.getTableDispName();
                localSuffix = dbmeta.extractPrimaryKeyMap(entity).toString();
            } else {
                localTable = this._row != null ? this._row.getClass().getSimpleName() : null;
                localSuffix = "{" + this._row + "}";
            }
            br.addElement(localTable + ":" + localSuffix + " => " + this._propertyName);
            if (this._row instanceof Entity) {
                entity = (Entity)this._row;
                br.addItem("Local Entity");
                try {
                    br.addElement(entity.toStringWithRelation());
                }
                catch (RuntimeException continued) {
                    String tableDbName = entity.asTableDbName();
                    String msg = "*Failed to build string from the entity for debug: " + tableDbName;
                    if (_log.isDebugEnabled()) {
                        _log.debug(msg);
                    }
                    br.addElement(msg);
                }
            } else {
                br.addItem("Local Entity");
                br.addElement(this._row);
            }
            if (this._invokePath != null) {
                br.addItem("Behavior");
                br.addElement(this._invokePath);
            }
            if (this._sql != null) {
                br.addItem("ConditionBean");
                try {
                    TimeZone finalTimeZone = this.getFinalTimeZone();
                    DisplaySqlBuilder displaySqlBuilder = this.createDisplaySqlBuilder(finalTimeZone);
                    br.addElement(displaySqlBuilder.buildDisplaySql(this._sql, this._args));
                    br.addElement("");
                    br.addElement("(using DBFlute system time-zone: " + finalTimeZone.getID() + ")");
                }
                catch (RuntimeException continued) {
                    String msg = "*Failed to get display SQL from the condition-bean for debug.";
                    if (_log.isDebugEnabled()) {
                        _log.debug("*Failed to get display SQL from the condition-bean for debug.");
                    }
                    br.addElement(this._sql);
                    if (this._args == null) break block12;
                    br.addElement(Arrays.asList(this._args));
                }
            }
        }
        String msg = br.buildExceptionMessage();
        throw new RelationEntityNotFoundException(msg);
    }

    protected TimeZone getFinalTimeZone() {
        return DBFluteSystem.getFinalTimeZone();
    }

    protected DisplaySqlBuilder createDisplaySqlBuilder(TimeZone finalTimeZone) {
        return new DisplaySqlBuilder(this.createBoundDateDisplayStyle(finalTimeZone));
    }

    protected BoundDateDisplayStyle createBoundDateDisplayStyle(TimeZone finalTimeZone) {
        String datePattern = "yyyy/MM/dd";
        String timestampPattern = "yyyy/MM/dd HH:mm:ss.SSS";
        String timePattern = "HH:mm:ss";
        return new BoundDateDisplayStyle("yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss.SSS", "HH:mm:ss", () -> finalTimeZone);
    }
}

