/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.outsidesql.executor;

import org.dbflute.bhv.exception.BehaviorExceptionThrower;
import org.dbflute.cbean.coption.StatementConfigCall;
import org.dbflute.cbean.result.ListResultBean;
import org.dbflute.cbean.result.PagingResultBean;
import org.dbflute.exception.IllegalConditionBeanOperationException;
import org.dbflute.jdbc.CursorHandler;
import org.dbflute.jdbc.StatementConfig;
import org.dbflute.optional.OptionalEntity;
import org.dbflute.outsidesql.OutsideSqlOption;
import org.dbflute.outsidesql.ProcedurePmb;
import org.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;
import org.dbflute.outsidesql.executor.OutsideSqlTraditionalExecutor;
import org.dbflute.outsidesql.typed.AutoPagingHandlingPmb;
import org.dbflute.outsidesql.typed.CursorHandlingPmb;
import org.dbflute.outsidesql.typed.EntityHandlingPmb;
import org.dbflute.outsidesql.typed.ExecuteHandlingPmb;
import org.dbflute.outsidesql.typed.ListHandlingPmb;
import org.dbflute.outsidesql.typed.ManualPagingHandlingPmb;
import org.dbflute.outsidesql.typed.PagingHandlingPmb;

public class OutsideSqlAllFacadeExecutor<BEHAVIOR> {
    protected final OutsideSqlBasicExecutor<BEHAVIOR> _basicExecutor;

    public OutsideSqlAllFacadeExecutor(OutsideSqlBasicExecutor<BEHAVIOR> basicExecutor) {
        this._basicExecutor = basicExecutor;
    }

    public <ENTITY> OptionalEntity<ENTITY> selectEntity(EntityHandlingPmb<BEHAVIOR, ENTITY> pmb) {
        return OptionalEntity.ofNullable(this._basicExecutor.entityHandling().selectEntity(pmb), () -> this.createBhvExThrower().throwSelectEntityAlreadyDeletedException(pmb));
    }

    public <ENTITY> ListResultBean<ENTITY> selectList(ListHandlingPmb<BEHAVIOR, ENTITY> pmb) {
        return this._basicExecutor.selectList(pmb);
    }

    public <ENTITY> PagingResultBean<ENTITY> selectPage(PagingHandlingPmb<BEHAVIOR, ENTITY> pmb) {
        if (pmb instanceof ManualPagingHandlingPmb) {
            return this._basicExecutor.manualPaging().selectPage((ManualPagingHandlingPmb)pmb);
        }
        if (pmb instanceof AutoPagingHandlingPmb) {
            return this._basicExecutor.autoPaging().selectPage((AutoPagingHandlingPmb)pmb);
        }
        String msg = "Unknown paging handling parameter-bean: " + pmb;
        throw new IllegalStateException(msg);
    }

    public <ENTITY> ListResultBean<ENTITY> selectPagedListOnly(PagingHandlingPmb<BEHAVIOR, ENTITY> pmb) {
        if (pmb instanceof ManualPagingHandlingPmb) {
            return this._basicExecutor.manualPaging().selectList((ManualPagingHandlingPmb)pmb);
        }
        if (pmb instanceof AutoPagingHandlingPmb) {
            return this._basicExecutor.autoPaging().selectList((AutoPagingHandlingPmb)pmb);
        }
        String msg = "Unknown paging handling parameter-bean: " + pmb;
        throw new IllegalStateException(msg);
    }

    public <ENTITY> Object selectCursor(CursorHandlingPmb<BEHAVIOR, ENTITY> pmb, CursorHandler handler) {
        return this._basicExecutor.cursorHandling().selectCursor(pmb, handler);
    }

    public int execute(ExecuteHandlingPmb<BEHAVIOR> pmb) {
        return this._basicExecutor.execute(pmb);
    }

    public void call(ProcedurePmb pmb) {
        this._basicExecutor.call(pmb);
    }

    public OutsideSqlTraditionalExecutor<BEHAVIOR> traditionalStyle() {
        return new OutsideSqlTraditionalExecutor<BEHAVIOR>(this._basicExecutor);
    }

    public OutsideSqlAllFacadeExecutor<BEHAVIOR> removeBlockComment() {
        this._basicExecutor.removeBlockComment();
        return this;
    }

    public OutsideSqlAllFacadeExecutor<BEHAVIOR> removeLineComment() {
        this._basicExecutor.removeLineComment();
        return this;
    }

    public OutsideSqlAllFacadeExecutor<BEHAVIOR> formatSql() {
        this._basicExecutor.formatSql();
        return this;
    }

    public OutsideSqlAllFacadeExecutor<BEHAVIOR> configure(StatementConfigCall<StatementConfig> confLambda) {
        if (confLambda == null) {
            throw new IllegalArgumentException("The argument 'confLambda' should not be null.");
        }
        this.assertStatementConfigNotDuplicated(confLambda);
        this._basicExecutor.configure(this.createStatementConfig(confLambda));
        return this;
    }

    protected void assertStatementConfigNotDuplicated(StatementConfigCall<StatementConfig> configCall) {
        StatementConfig existingConfig;
        OutsideSqlOption option = this._basicExecutor.getOutsideSqlOption();
        if (option != null && (existingConfig = option.getStatementConfig()) != null) {
            String msg = "Already registered the configuration: existing=" + existingConfig + ", new=" + configCall;
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected StatementConfig createStatementConfig(StatementConfigCall<StatementConfig> configCall) {
        if (configCall == null) {
            throw new IllegalArgumentException("The argument 'confLambda' should not be null.");
        }
        StatementConfig config = this.newStatementConfig();
        configCall.callback(config);
        return config;
    }

    protected StatementConfig newStatementConfig() {
        return new StatementConfig();
    }

    protected BehaviorExceptionThrower createBhvExThrower() {
        return this._basicExecutor.createBhvExThrower();
    }

    public OutsideSqlBasicExecutor<BEHAVIOR> xbasicExecutor() {
        return this._basicExecutor;
    }
}

