/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.jdbc;

import java.io.Serializable;

public class StatementConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Integer _resultSetType;
    protected Integer _queryTimeout;
    protected Integer _fetchSize;
    protected Integer _maxRows;
    protected boolean _suppressDefault;

    public StatementConfig typeForwardOnly() {
        this._resultSetType = 1003;
        return this;
    }

    public StatementConfig typeScrollInsensitive() {
        this._resultSetType = 1004;
        return this;
    }

    public StatementConfig typeScrollSensitive() {
        this._resultSetType = 1005;
        return this;
    }

    public StatementConfig queryTimeout(Integer queryTimeout) {
        this._queryTimeout = queryTimeout;
        return this;
    }

    public StatementConfig fetchSize(Integer fetchSize) {
        this._fetchSize = fetchSize;
        return this;
    }

    public StatementConfig maxRows(Integer maxRows) {
        this._maxRows = maxRows;
        return this;
    }

    public StatementConfig suppressDefault() {
        this._suppressDefault = true;
        return this;
    }

    public boolean hasResultSetType() {
        return this._resultSetType != null;
    }

    public boolean hasStatementOptions() {
        return this.hasQueryTimeout() || this.hasFetchSize() || this.hasMaxRows();
    }

    public boolean hasQueryTimeout() {
        return this._queryTimeout != null;
    }

    public boolean hasFetchSize() {
        return this._fetchSize != null;
    }

    public boolean hasMaxRows() {
        return this._maxRows != null;
    }

    public boolean isSuppressDefault() {
        return this._suppressDefault;
    }

    public StatementConfig createSnapshot() {
        StatementConfig config = new StatementConfig();
        config._resultSetType = this._resultSetType;
        config._queryTimeout = this._queryTimeout;
        config._fetchSize = this._fetchSize;
        config._maxRows = this._maxRows;
        config._suppressDefault = this._suppressDefault;
        return config;
    }

    public String buildResultSetTypeDisp() {
        if (this._resultSetType == null) {
            return "default";
        }
        String typeDisp = this._resultSetType == 1003 ? "forward" : (this._resultSetType == 1004 ? "scroll(ins)" : (this._resultSetType == 1005 ? "scroll(sen)" : "unknown"));
        return typeDisp;
    }

    public String toString() {
        return "{" + this.buildResultSetTypeDisp() + ", " + this._queryTimeout + ", " + this._fetchSize + ", " + this._maxRows + "}";
    }

    public Integer getResultSetType() {
        return this._resultSetType;
    }

    public Integer getQueryTimeout() {
        return this._queryTimeout;
    }

    public Integer getFetchSize() {
        return this._fetchSize;
    }

    public Integer getMaxRows() {
        return this._maxRows;
    }
}

