/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.infra.doc.hacomment;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dbflute.helper.HandyDate;
import org.dbflute.helper.dfmap.DfMapFile;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.infra.doc.hacomment.DfHacoMapDiffPart;
import org.dbflute.infra.doc.hacomment.DfHacoMapPickup;
import org.dbflute.infra.doc.hacomment.DfHacoMapPiece;
import org.dbflute.infra.doc.hacomment.DfHacoMapPropertyPart;
import org.dbflute.infra.doc.hacomment.exception.DfHacoMapFileReadFailureException;
import org.dbflute.infra.doc.hacomment.exception.DfHacoMapFileWriteFailureException;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfStringUtil;
import org.dbflute.util.DfTypeUtil;

public class DfHacoMapFile {
    private static final String BASE_HACOMMENT_DIR_PATH = "/schema/hacomment/";
    private static final String BASE_PIECE_DIR_PATH = "/schema/hacomment/piece/";
    private static final String BASE_PICKUP_FILE_PATH = "/schema/hacomment/pickup/hacomment-pickup.dfmap";
    private static final Map<String, String> REPLACE_CHAR_MAP;
    private static final Map<String, String> REPLACE_MAP_FOR_HACOMMENT_ID;
    private final Supplier<LocalDateTime> currentDatetimeSupplier;

    public DfHacoMapFile(Supplier<LocalDateTime> currentDatetimeSupplier) {
        this.currentDatetimeSupplier = currentDatetimeSupplier;
    }

    public List<DfHacoMapPiece> readPieceList(String clientDirPath) {
        this.assertClientDirPath(clientDirPath);
        String pieceDirPath = this.buildPieceDirPath(clientDirPath);
        if (Files.notExists(Paths.get(pieceDirPath, new String[0]), new LinkOption[0])) {
            return Collections.emptyList();
        }
        try {
            return Files.list(Paths.get(pieceDirPath, new String[0])).filter(path -> path.toString().endsWith(".dfmap")).filter(path -> path.toString().contains("-piece-")).map(path -> this.doReadPiece((Path)path)).collect(Collectors.toList());
        }
        catch (IOException e) {
            this.throwHacomMapReadFailureException(pieceDirPath, e);
            return Collections.emptyList();
        }
    }

    private DfHacoMapPiece doReadPiece(Path path) {
        DfMapFile mapFile = new DfMapFile();
        try {
            Map<String, Object> map = mapFile.readMap(Files.newInputStream(path, new OpenOption[0]));
            return this.mappingToDecoMapPiece(map);
        }
        catch (IOException | RuntimeException e) {
            this.throwHacomMapReadFailureException(path.toString(), e);
            return null;
        }
    }

    private DfHacoMapPiece mappingToDecoMapPiece(Map<String, Object> map) {
        String diffCode = (String)map.get("diffCode");
        String diffdate = (String)map.get("diffDate");
        String hacomment = (String)map.get("hacomment");
        String diffComment = (String)map.get("diffComment");
        List authorList = (List)map.get("authorList");
        String pieceCode = (String)map.get("pieceCode");
        LocalDateTime pieceDatetime = new HandyDate((String)map.get("pieceDatetime")).getLocalDateTime();
        String pieceOwner = (String)map.get("pieceOwner");
        List previousPieceList = (List)map.get("previousPieceList");
        return new DfHacoMapPiece(diffCode, diffdate, hacomment, diffComment, authorList, pieceCode, pieceOwner, pieceDatetime, previousPieceList);
    }

    public OptionalThing<DfHacoMapPickup> readPickup(String clientDirPath) {
        this.assertClientDirPath(clientDirPath);
        String filePath = this.buildPickupFilePath(clientDirPath);
        if (Files.notExists(Paths.get(filePath, new String[0]), new LinkOption[0])) {
            return OptionalThing.empty();
        }
        return OptionalThing.ofNullable(this.doReadPickup(Paths.get(filePath, new String[0])), () -> {});
    }

    private DfHacoMapPickup doReadPickup(Path path) {
        DfMapFile mapFile = new DfMapFile();
        try {
            Map<String, Object> map = mapFile.readMap(Files.newInputStream(path, new OpenOption[0]));
            return this.mappingToHacoMapPickup(map);
        }
        catch (IOException | RuntimeException e) {
            this.throwHacomMapReadFailureException(path.toString(), e);
            return null;
        }
    }

    private DfHacoMapPickup mappingToHacoMapPickup(Map<String, Object> map) {
        LocalDateTime pickupDatetime = DfTypeUtil.toLocalDateTime(map.get("pickupDatetime"));
        String formatVersion = (String)map.get("formatVersion");
        DfHacoMapPickup pickup = new DfHacoMapPickup(formatVersion);
        pickup.setPickupDatetime(pickupDatetime);
        Map hacoMap = (Map)((Object)map.getOrDefault("hacoMap", new ArrayList()));
        if (hacoMap.isEmpty()) {
            return pickup;
        }
        List diffMapList = hacoMap.getOrDefault("diffList", new ArrayList());
        List<DfHacoMapDiffPart> diffList = diffMapList.stream().map(diffMap -> new DfHacoMapDiffPart((Map<String, Object>)diffMap)).collect(Collectors.toList());
        pickup.addAllDiffList(diffList);
        return pickup;
    }

    protected void throwHacomMapReadFailureException(String path, Exception cause) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to read the haco-map file or directory.");
        br.addItem("path");
        br.addElement(path);
        String msg = br.buildExceptionMessage();
        throw new DfHacoMapFileReadFailureException(msg, cause);
    }

    public void writePiece(String clientDirPath, DfHacoMapPiece piece) {
        this.assertClientDirPath(clientDirPath);
        String piecePath = this.buildPieceDirPath(clientDirPath) + this.buildPieceFileName(piece);
        this.doWritePiece(piecePath, piece);
    }

    private void doWritePiece(String pieceFilePath, DfHacoMapPiece piece) {
        File pieceMapFile = new File(pieceFilePath);
        if (pieceMapFile.exists()) {
            pieceMapFile.delete();
        }
        this.createPieceMapFile(pieceMapFile);
        Map<String, Object> hacoMap = piece.convertToMap();
        this.createMapFile(pieceFilePath, pieceMapFile, hacoMap);
    }

    protected void createPieceMapFile(File pieceMapFile) {
        try {
            Files.createDirectories(Paths.get(pieceMapFile.getParentFile().getAbsolutePath(), new String[0]), new FileAttribute[0]);
            Files.createFile(Paths.get(pieceMapFile.getAbsolutePath(), new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            this.throwHacoMapWriteFailureException(pieceMapFile.getPath(), e);
        }
    }

    public void writePickup(String clientDirPath, DfHacoMapPickup pickup) {
        this.assertClientDirPath(clientDirPath);
        this.doWritePickup(this.buildPickupFilePath(clientDirPath), pickup);
    }

    protected void doWritePickup(String pickupFilePath, DfHacoMapPickup pickup) {
        File pickupMapFile = new File(pickupFilePath);
        if (pickupMapFile.exists()) {
            pickupMapFile.delete();
        }
        this.createPickupMapFile(pickupMapFile);
        Map<String, Object> hacoMap = pickup.convertToMap();
        this.createMapFile(pickupFilePath, pickupMapFile, hacoMap);
    }

    protected void createPickupMapFile(File pickupMapFile) {
        try {
            Files.createDirectories(Paths.get(pickupMapFile.getParentFile().getAbsolutePath(), new String[0]), new FileAttribute[0]);
            Files.createFile(Paths.get(pickupMapFile.getAbsolutePath(), new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            this.throwHacoMapWriteFailureException(pickupMapFile.getPath(), e);
        }
    }

    private void createMapFile(String mappingFilePath, File mappingMapFile, Map<String, Object> hacoMap) {
        DfMapFile mapFile = new DfMapFile();
        try (FileOutputStream ous = new FileOutputStream(mappingMapFile);){
            try {
                mapFile.writeMap(ous, hacoMap);
            }
            catch (IOException e) {
                this.throwHacoMapWriteFailureException(mappingFilePath, e);
            }
        }
        catch (IOException e) {
            this.throwHacoMapResourceReleaseFailureException(mappingFilePath, hacoMap, e);
        }
    }

    public String buildPieceFileName(DfHacoMapPiece piece) {
        String diffDateStr = this.generatePieceFileName(piece);
        String filteredOwner = DfStringUtil.replaceBy(piece.getPieceOwner(), REPLACE_CHAR_MAP);
        return "hacomment-piece-" + diffDateStr + "-" + this.getCurrentDateStr() + "-" + filteredOwner + "-" + piece.pieceCode + ".dfmap";
    }

    private String generatePieceFileName(DfHacoMapPiece piece) {
        return "diffdate" + this.generateDiffCode(piece.getDiffDate());
    }

    protected String getCurrentDateStr() {
        return DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss-SSS").format(this.getCurrentLocalDateTime());
    }

    protected void throwHacoMapWriteFailureException(String path, Exception cause) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to create the haco-map file.");
        br.addItem("Path");
        br.addElement(path);
        String msg = br.buildExceptionMessage();
        throw new DfHacoMapFileWriteFailureException(msg, cause);
    }

    protected void throwHacoMapResourceReleaseFailureException(String path, Map<String, Object> hacoMap, Exception cause) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Maybe... fail to execute \"outputStream.close()\".");
        br.addItem("Path");
        br.addElement(path);
        br.addItem("HacoMap");
        br.addElement(hacoMap);
        String msg = br.buildExceptionMessage();
        throw new DfHacoMapFileWriteFailureException(msg, cause);
    }

    public DfHacoMapPickup merge(OptionalThing<DfHacoMapPickup> optPickup, List<DfHacoMapPiece> pieces) {
        Set<String> pieceCodeSet = this.extractAllMergedPieceCode(optPickup, pieces);
        DfHacoMapPickup mergedPickup = this.doMerge(optPickup, pieces, pieceCodeSet);
        return mergedPickup;
    }

    private Set<String> extractAllMergedPieceCode(OptionalThing<DfHacoMapPickup> pickupOpt, List<DfHacoMapPiece> pieces) {
        Stream pickupPieceCodeStream = pickupOpt.map(pickup -> pickup.getDiffList().stream().flatMap(diffPart -> diffPart.getPropertyList().stream().flatMap(property -> property.getPreviousPieceList().stream()))).orElse(Stream.empty());
        Stream previousPieceCodeStream = pieces.stream().flatMap(piece -> piece.previousPieceList.stream());
        return Stream.concat(pickupPieceCodeStream, previousPieceCodeStream).collect(Collectors.toSet());
    }

    private DfHacoMapPickup doMerge(OptionalThing<DfHacoMapPickup> pickupOpt, List<DfHacoMapPiece> pieces, Set<String> mergedPieceCodeSet) {
        Stream<DfHacoMapDiffPart> piecesDiffPartStream = pieces.stream().map(piece -> this.mappingPieceToDiffPart((DfHacoMapPiece)piece));
        Stream pickupDiffPartStream = pickupOpt.map(pickup -> pickup.getDiffList().stream()).orElse(Stream.empty());
        Map<String, List<DfHacoMapDiffPart>> diffPartMap = Stream.concat(piecesDiffPartStream, pickupDiffPartStream).collect(Collectors.groupingBy(diffPart -> diffPart.diffCode));
        List<DfHacoMapDiffPart> filteredDiffPartList = diffPartMap.entrySet().stream().map(diffPartEntry -> {
            String diffDate = ((List)diffPartEntry.getValue()).stream().findFirst().map(diffPart -> diffPart.diffDate).orElseThrow(() -> new IllegalStateException("Diffdate is null. \n" + diffPartEntry));
            List<DfHacoMapPropertyPart> filteredPropertyPartList = ((List)diffPartEntry.getValue()).stream().flatMap(hacoMapDiffPart -> hacoMapDiffPart.getPropertyList().stream()).filter(propertyPart -> !mergedPieceCodeSet.contains(propertyPart.pieceCode)).collect(Collectors.toList());
            return new DfHacoMapDiffPart((String)diffPartEntry.getKey(), diffDate, filteredPropertyPartList);
        }).collect(Collectors.toList());
        DfHacoMapPickup newPickup = new DfHacoMapPickup();
        newPickup.addAllDiffList(filteredDiffPartList);
        newPickup.setPickupDatetime(this.getCurrentLocalDateTime());
        return newPickup;
    }

    private DfHacoMapDiffPart mappingPieceToDiffPart(DfHacoMapPiece piece) {
        DfHacoMapPropertyPart propertyPart = new DfHacoMapPropertyPart(piece.hacomment, piece.diffComment, piece.authorList, piece.pieceCode, piece.pieceOwner, piece.pieceDatetime, piece.previousPieceList);
        return new DfHacoMapDiffPart(piece.diffCode, piece.diffDate, propertyPart);
    }

    public void deletePiece(String clientPath) {
        String pieceDirPath = this.buildPieceDirPath(clientPath);
        this.doDeletePiece(pieceDirPath);
    }

    private void doDeletePiece(String piecePath) {
        File pieceDir = new File(piecePath);
        if (pieceDir.isDirectory()) {
            for (File pieceFile : Objects.requireNonNull(pieceDir.listFiles())) {
                if (pieceFile.isFile()) {
                    pieceFile.delete();
                    continue;
                }
                this.doDeletePiece(pieceFile.getAbsolutePath());
            }
        }
    }

    public String generateDiffCode(String diffDate) {
        return DfStringUtil.replaceBy(diffDate, REPLACE_MAP_FOR_HACOMMENT_ID);
    }

    protected String buildPieceDirPath(String clientDirPath) {
        return clientDirPath + BASE_PIECE_DIR_PATH;
    }

    protected String buildPickupFilePath(String clientDirPath) {
        return clientDirPath + BASE_PICKUP_FILE_PATH;
    }

    protected void assertClientDirPath(String clientDirPath) {
        if (clientDirPath == null || clientDirPath.trim().length() == 0) {
            String msg = "The argument 'clientDirPath' should not be null or empty: " + clientDirPath;
            throw new IllegalArgumentException(msg);
        }
    }

    protected LocalDateTime getCurrentLocalDateTime() {
        return this.currentDatetimeSupplier.get();
    }

    static {
        List<String> notAvailableCharList = Arrays.asList("/", "\\", "<", ">", "*", "?", "\"", "|", ":", ";", "\u0000", " ");
        String replaceChar = "_";
        REPLACE_CHAR_MAP = notAvailableCharList.stream().collect(Collectors.toMap(ch -> ch, ch -> replaceChar));
        REPLACE_MAP_FOR_HACOMMENT_ID = Stream.of("/", " ", ":").collect(Collectors.toMap(ch -> ch, ch -> ""));
    }
}

