/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.dbmeta.info;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.dbflute.Entity;
import org.dbflute.dbmeta.DBMeta;
import org.dbflute.dbmeta.info.ForeignInfo;
import org.dbflute.dbmeta.info.ReferrerInfo;
import org.dbflute.dbmeta.name.ColumnSqlName;
import org.dbflute.dbmeta.property.PropertyGateway;
import org.dbflute.dbmeta.property.PropertyMethodFinder;
import org.dbflute.jdbc.Classification;
import org.dbflute.jdbc.ClassificationMeta;
import org.dbflute.util.DfReflectionUtil;
import org.dbflute.util.DfTypeUtil;
import org.dbflute.util.Srl;

public class ColumnInfo {
    protected static final List<String> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    protected static final String JAVA8_JUST_DATE_TYPE = LocalDate.class.getName();
    protected static final String JAVA8_JUST_TIMESTAMP_TYPE = LocalDateTime.class.getName();
    protected static final String JAVA8_JUST_TIME_TYPE = LocalTime.class.getName();
    protected static final Set<String> JAVA8_DATE_TYPE_SET;
    protected final DBMeta _dbmeta;
    protected final String _columnDbName;
    protected final ColumnSqlName _columnSqlName;
    protected final String _columnSynonym;
    protected final String _columnAlias;
    protected final String _propertyName;
    protected final Class<?> _objectNativeType;
    protected final Class<?> _propertyAccessType;
    protected final boolean _primary;
    protected final boolean _autoIncrement;
    protected final boolean _notNull;
    protected final String _columnDbType;
    protected final Integer _columnSize;
    protected final Integer _decimalDigits;
    protected final Integer _datetimePrecision;
    protected final String _defaultValue;
    protected final boolean _commonColumn;
    protected final DBMeta.OptimisticLockType _optimisticLockType;
    protected final String _columnComment;
    protected final List<String> _foreignPropList;
    protected final List<String> _referrerPropList;
    protected final boolean _foreignKey;
    protected final ClassificationMeta _classificationMeta;
    protected final boolean _canBeNullObject;
    protected final PropertyGateway _propertyGateway;
    protected final PropertyMethodFinder _propertyMethodFinder;
    protected final Method _readMethod;
    protected final Method _writeMethod;

    public ColumnInfo(DBMeta dbmeta, String columnDbName, String columnSqlName, String columnSynonym, String columnAlias, Class<?> objectNativeType, String propertyName, Class<?> propertyAccessType, boolean primary, boolean autoIncrement, boolean notNull, String columnDbType, Integer columnSize, Integer decimalDigits, Integer datetimePrecision, String defaultValue, boolean commonColumn, DBMeta.OptimisticLockType optimisticLockType, String columnComment, List<String> foreignPropList, List<String> referrerPropList, ClassificationMeta classificationMeta, boolean canBeNullObject, PropertyMethodFinder propertyMethodFinder) {
        this.assertObjectNotNull("dbmeta", dbmeta);
        this.assertObjectNotNull("columnDbName", columnDbName);
        this.assertObjectNotNull("columnSqlName", columnSqlName);
        this.assertObjectNotNull("objectNativeType", objectNativeType);
        this.assertObjectNotNull("propertyName", propertyName);
        this.assertObjectNotNull("propertyAccessType", propertyAccessType);
        this.assertObjectNotNull("propertyMethodFinder", propertyMethodFinder);
        this._dbmeta = dbmeta;
        this._columnDbName = columnDbName;
        this._columnSqlName = new ColumnSqlName(columnSqlName);
        this._columnSynonym = columnSynonym;
        this._columnAlias = columnAlias;
        this._objectNativeType = objectNativeType;
        this._propertyName = propertyName;
        this._propertyAccessType = propertyAccessType;
        this._primary = primary;
        this._autoIncrement = autoIncrement;
        this._notNull = notNull;
        this._columnSize = columnSize;
        this._columnDbType = columnDbType;
        this._decimalDigits = decimalDigits;
        this._datetimePrecision = datetimePrecision;
        this._defaultValue = defaultValue;
        this._commonColumn = commonColumn;
        this._optimisticLockType = optimisticLockType != null ? optimisticLockType : DBMeta.OptimisticLockType.NONE;
        this._columnComment = columnComment;
        this._foreignPropList = foreignPropList != null ? foreignPropList : EMPTY_LIST;
        this._referrerPropList = referrerPropList != null ? referrerPropList : EMPTY_LIST;
        this._foreignKey = foreignPropList != null && !foreignPropList.isEmpty();
        this._classificationMeta = classificationMeta;
        this._canBeNullObject = canBeNullObject;
        this._propertyGateway = this.findPropertyGateway();
        this._propertyMethodFinder = propertyMethodFinder;
        this._readMethod = this.findReadMethod();
        this._writeMethod = this.findWriteMethod();
    }

    public PropertyGateway getPropertyGateway() {
        return this._propertyGateway;
    }

    public <PROPERTY> PROPERTY read(Entity entity) {
        return (PROPERTY)this._propertyGateway.read(entity);
    }

    public Method getReadMethod() {
        return this._readMethod;
    }

    public void write(Entity entity, Object value) {
        this._propertyGateway.write(entity, value);
    }

    public Method getWriteMethod() {
        return this._writeMethod;
    }

    public Class<?> getGenericType() {
        return DfReflectionUtil.getGenericFirstClass(this.getReadMethod().getGenericReturnType());
    }

    protected PropertyGateway findPropertyGateway() {
        PropertyGateway gateway = this._dbmeta.findPropertyGateway(this._propertyName);
        if (gateway == null) {
            String msg = "Not found the property gateway by the name: " + this._propertyName;
            throw new IllegalStateException(msg);
        }
        return gateway;
    }

    protected Method findReadMethod() {
        Class<? extends Entity> entityType = this._dbmeta.getEntityType();
        return this._propertyMethodFinder.findReadMethod(entityType, this._propertyName, this._propertyAccessType);
    }

    protected Method findWriteMethod() {
        Class<? extends Entity> entityType = this._dbmeta.getEntityType();
        return this._propertyMethodFinder.findWriteMethod(entityType, this._propertyName, this._propertyAccessType);
    }

    public <VALUE> VALUE convertToObjectNativeType(Object value) {
        Object result;
        if (value instanceof Collection) {
            Collection valueList = (Collection)value;
            ArrayList<VALUE> resultList = new ArrayList<VALUE>(valueList.size());
            for (Object obj : valueList) {
                resultList.add(this.doConvertToObjectNativeType(obj));
            }
            result = resultList;
        } else {
            result = this.doConvertToObjectNativeType(value);
        }
        return result;
    }

    protected <VALUE> VALUE doConvertToObjectNativeType(Object value) {
        if (value != null && value instanceof Classification) {
            value = ((Classification)value).code();
        }
        if (value == null) {
            return null;
        }
        Class<?> nativeType = this._objectNativeType;
        Object converted = Number.class.isAssignableFrom(nativeType) ? DfTypeUtil.toNumber(value, nativeType) : (Timestamp.class.isAssignableFrom(nativeType) ? DfTypeUtil.toTimestamp(value) : (Time.class.isAssignableFrom(nativeType) ? DfTypeUtil.toTime(value) : (Date.class.isAssignableFrom(nativeType) ? DfTypeUtil.toDate(value) : (Boolean.class.isAssignableFrom(nativeType) ? DfTypeUtil.toBoolean(value) : (byte[].class.isAssignableFrom(nativeType) ? (value instanceof Serializable ? (Object)DfTypeUtil.toBinary((Serializable)value) : value) : (UUID.class.isAssignableFrom(nativeType) ? DfTypeUtil.toUUID(value) : value))))));
        Number result = converted;
        return (VALUE)result;
    }

    public void diveIntoFlexibleMap(Map<String, ColumnInfo> flexibleMap) {
        List<String> flexibleKeyList = this.getFlexibleKeyList();
        for (String flexibleKey : flexibleKeyList) {
            flexibleMap.put(flexibleKey, this);
        }
    }

    protected List<String> getFlexibleKeyList() {
        return ColumnInfo.generateFlexibleKeyList(this._columnDbName, this._columnSynonym, this._propertyName);
    }

    public static List<String> generateFlexibleKeyList(String columnDbName, String columnSynonym, String propertyName) {
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.add(columnDbName);
        if (columnSynonym != null) {
            keyList.add(columnSynonym);
        }
        keyList.add(propertyName);
        return keyList;
    }

    protected String initCap(String name) {
        return Srl.initCap(name);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    public int hashCode() {
        return this._dbmeta.hashCode() + this._columnDbName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ColumnInfo)) {
            return false;
        }
        ColumnInfo target = (ColumnInfo)obj;
        if (!this._dbmeta.equals(target.getDBMeta())) {
            return false;
        }
        return this._columnDbName.equals(target.getColumnDbName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._dbmeta.getTableDbName());
        sb.append(".").append(this._columnDbName);
        sb.append(":{");
        sb.append(this._columnDbType);
        if (this._columnSize != null) {
            sb.append("(");
            sb.append(this._columnSize);
            if (this._decimalDigits != null) {
                sb.append(", ").append(this._decimalDigits);
            }
            if (this._datetimePrecision != null) {
                sb.append(", ").append(this._datetimePrecision);
            }
            sb.append(")");
        } else if (this._datetimePrecision != null) {
            sb.append("(").append(this._datetimePrecision).append(")");
        }
        sb.append(", ").append(this._objectNativeType.getName());
        sb.append("}");
        return sb.toString();
    }

    public DBMeta getDBMeta() {
        return this._dbmeta;
    }

    public String getColumnDbName() {
        return this._columnDbName;
    }

    public ColumnSqlName getColumnSqlName() {
        return this._columnSqlName;
    }

    public String getColumnSynonym() {
        return this._columnSynonym;
    }

    public String getColumnAlias() {
        return this._columnAlias;
    }

    public Class<?> getObjectNativeType() {
        return this._objectNativeType;
    }

    public boolean isObjectNativeTypeString() {
        return String.class.isAssignableFrom(this._objectNativeType);
    }

    public boolean isObjectNativeTypeNumber() {
        return Number.class.isAssignableFrom(this._objectNativeType);
    }

    public boolean isObjectNativeTypeDate() {
        return this.assignableObjectNativeTypeUtilDate() || this.assignableObjectNativeTypeJava8Date();
    }

    protected boolean assignableObjectNativeTypeUtilDate() {
        return Date.class.isAssignableFrom(this._objectNativeType);
    }

    protected boolean assignableObjectNativeTypeJava8Date() {
        return JAVA8_DATE_TYPE_SET.contains(this._objectNativeType.getName());
    }

    public boolean isObjectNativeTypeJustDate() {
        return this.justObjectNativeTypeUtilDate() || this.justObjectNativeJava8Date();
    }

    protected boolean justObjectNativeTypeUtilDate() {
        return Date.class.equals(this._objectNativeType);
    }

    protected boolean justObjectNativeJava8Date() {
        return this._objectNativeType.getName().equals(JAVA8_JUST_DATE_TYPE);
    }

    public boolean isObjectNativeTypeJustTimestamp() {
        return this.justObjectNativeTypeUtilTimestamp() || this.justObjectNativeJava8Timestamp();
    }

    protected boolean justObjectNativeTypeUtilTimestamp() {
        return Timestamp.class.equals(this._objectNativeType);
    }

    protected boolean justObjectNativeJava8Timestamp() {
        return this._objectNativeType.getName().equals(JAVA8_JUST_TIMESTAMP_TYPE);
    }

    public boolean isObjectNativeTypeJustTime() {
        return this.justObjectNativeTypeUtilTime() || this.justObjectNativeJava8Time();
    }

    protected boolean justObjectNativeTypeUtilTime() {
        return Time.class.equals(this._objectNativeType);
    }

    protected boolean justObjectNativeJava8Time() {
        return this._objectNativeType.getName().equals(JAVA8_JUST_TIME_TYPE);
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public Class<?> getPropertyAccessType() {
        return this._propertyAccessType;
    }

    public boolean isPrimary() {
        return this._primary;
    }

    public boolean isAutoIncrement() {
        return this._autoIncrement;
    }

    public boolean isNotNull() {
        return this._notNull;
    }

    public String getColumnDbType() {
        return this._columnDbType;
    }

    public Integer getColumnSize() {
        return this._columnSize;
    }

    public Integer getDecimalDigits() {
        return this._decimalDigits;
    }

    public Integer getDatetimePrecision() {
        return this._datetimePrecision;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public boolean isCommonColumn() {
        return this._commonColumn;
    }

    public boolean isOptimisticLock() {
        return this.isVersionNo() || this.isUpdateDate();
    }

    public boolean isVersionNo() {
        return DBMeta.OptimisticLockType.VERSION_NO == this._optimisticLockType;
    }

    public boolean isUpdateDate() {
        return DBMeta.OptimisticLockType.UPDATE_DATE == this._optimisticLockType;
    }

    public String getColumnComment() {
        return this._columnComment;
    }

    public List<ForeignInfo> getForeignInfoList() {
        ArrayList<ForeignInfo> foreignInfoList = new ArrayList<ForeignInfo>();
        for (String foreignProp : this._foreignPropList) {
            foreignInfoList.add(this.getDBMeta().findForeignInfo(foreignProp));
        }
        return Collections.unmodifiableList(foreignInfoList);
    }

    public List<ReferrerInfo> getReferrerInfoList() {
        ArrayList<ReferrerInfo> referrerInfoList = new ArrayList<ReferrerInfo>();
        for (String fkProp : this._referrerPropList) {
            referrerInfoList.add(this.getDBMeta().findReferrerInfo(fkProp));
        }
        return Collections.unmodifiableList(referrerInfoList);
    }

    public boolean isForeignKey() {
        return this._foreignKey;
    }

    public ClassificationMeta getClassificationMeta() {
        return this._classificationMeta;
    }

    public boolean canBeNullObject() {
        return this._canBeNullObject;
    }

    static {
        HashSet<String> tmpSet = new HashSet<String>();
        tmpSet.add(JAVA8_JUST_DATE_TYPE);
        tmpSet.add(JAVA8_JUST_TIMESTAMP_TYPE);
        tmpSet.add(JAVA8_JUST_TIME_TYPE);
        JAVA8_DATE_TYPE_SET = Collections.unmodifiableSet(tmpSet);
    }
}

