/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.dbmeta;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.dbflute.Entity;
import org.dbflute.FunCustodial;
import org.dbflute.dbmeta.DBMeta;
import org.dbflute.dbmeta.info.ColumnInfo;
import org.dbflute.dbmeta.info.ForeignInfo;
import org.dbflute.dbmeta.info.PrimaryInfo;
import org.dbflute.dbmeta.info.ReferrerInfo;
import org.dbflute.dbmeta.info.RelationInfo;
import org.dbflute.dbmeta.info.UniqueInfo;
import org.dbflute.dbmeta.property.DelegatingPropertyGateway;
import org.dbflute.dbmeta.property.PropertyGateway;
import org.dbflute.dbmeta.property.PropertyMethodFinder;
import org.dbflute.dbmeta.property.PropertyReader;
import org.dbflute.dbmeta.property.PropertyWriter;
import org.dbflute.dbmeta.valuemap.MetaHandlingEntityToMapMapper;
import org.dbflute.dbmeta.valuemap.MetaHandlingMapToEntityMapper;
import org.dbflute.exception.DBMetaNotFoundException;
import org.dbflute.helper.StringKeyMap;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.jdbc.Classification;
import org.dbflute.jdbc.ClassificationMeta;
import org.dbflute.jdbc.ClassificationUndefinedHandlingType;
import org.dbflute.optional.OptionalObject;
import org.dbflute.system.DBFluteSystem;
import org.dbflute.util.DfAssertUtil;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfReflectionUtil;
import org.dbflute.util.DfTypeUtil;
import org.dbflute.util.Srl;

public abstract class AbstractDBMeta
implements DBMeta {
    protected static final Object DUMMY_VALUE = new Object();
    private volatile List<ColumnInfo> _columnInfoList;
    private volatile StringKeyMap<ColumnInfo> _columnInfoFlexibleMap;
    private volatile PrimaryInfo _primaryInfo;
    private volatile List<UniqueInfo> _uniqueInfoList;
    private volatile List<ForeignInfo> _foreignInfoList;
    private volatile Map<String, ForeignInfo> _foreignInfoFlexibleMap;
    private volatile Map<Integer, ForeignInfo> _foreignInfoRelationNoKeyMap;
    private volatile List<ReferrerInfo> _referrerInfoList;
    private volatile Map<String, ReferrerInfo> _referrerInfoFlexibleMap;

    protected void initializeInformationResource() {
        this.getColumnInfoList();
        this.getColumnInfoFlexibleMap();
        if (this.hasPrimaryKey()) {
            this.getPrimaryInfo();
        }
    }

    protected void setupEpg(Map<String, PropertyGateway> propertyGatewayMap, PropertyReader reader, PropertyWriter writer, String propertyName) {
        DelegatingPropertyGateway gateway = new DelegatingPropertyGateway(reader, writer);
        propertyGatewayMap.put(propertyName, gateway);
    }

    @Override
    public PropertyGateway findPropertyGateway(String propertyName) {
        return null;
    }

    protected <ENTITY extends Entity> PropertyGateway doFindEpg(Map<String, PropertyGateway> propertyGatewayMap, String propertyName) {
        return propertyGatewayMap.get(propertyName);
    }

    protected void setupEfpg(Map<String, PropertyGateway> propertyGatewayMap, PropertyReader reader, PropertyWriter writer, String foreignPropertyName) {
        DelegatingPropertyGateway gateway = new DelegatingPropertyGateway(reader, writer);
        propertyGatewayMap.put(foreignPropertyName, gateway);
    }

    @Override
    public PropertyGateway findForeignPropertyGateway(String propertyName) {
        return null;
    }

    protected <ENTITY extends Entity> PropertyGateway doFindEfpg(Map<String, PropertyGateway> propertyGatewayMap, String foreignPropertyName) {
        return propertyGatewayMap.get(foreignPropertyName);
    }

    protected static void ccls(Entity entity, ColumnInfo columnInfo, Object code) {
        if (code == null) {
            return;
        }
        ClassificationMeta meta = columnInfo.getClassificationMeta();
        if (meta == null) {
            return;
        }
        ClassificationUndefinedHandlingType undefinedHandlingType = meta.undefinedHandlingType();
        if (!undefinedHandlingType.isChecked()) {
            return;
        }
        Classification classification = AbstractDBMeta.gcls(entity, columnInfo, code);
        if (classification == null) {
            String tableDbName = columnInfo.getDBMeta().getTableDbName();
            String columnDbName = columnInfo.getColumnDbName();
            boolean allowedByOption = entity.myundefinedClassificationAccessAllowed();
            FunCustodial.handleUndefinedClassificationCode(tableDbName, columnDbName, meta, code, allowedByOption);
        }
    }

    protected static Classification gcls(Entity entity, ColumnInfo columnInfo, Object code) {
        if (code == null) {
            return null;
        }
        ClassificationMeta meta = columnInfo.getClassificationMeta();
        if (meta == null) {
            return null;
        }
        return meta.codeOf(code);
    }

    protected static Integer cti(Object value) {
        return DfTypeUtil.toInteger(value);
    }

    protected static Long ctl(Object value) {
        return DfTypeUtil.toLong(value);
    }

    protected static BigDecimal ctb(Object value) {
        return DfTypeUtil.toBigDecimal(value);
    }

    protected static <NUMBER extends Number> NUMBER ctn(Object value, Class<NUMBER> type) {
        return (NUMBER)DfTypeUtil.toNumber(value, type);
    }

    protected static LocalDate ctld(Object value) {
        return DfTypeUtil.toLocalDate(value);
    }

    protected static LocalDateTime ctldt(Object value) {
        return DfTypeUtil.toLocalDateTime(value);
    }

    protected static LocalTime ctlt(Object value) {
        return DfTypeUtil.toLocalTime(value);
    }

    protected static Date ctdt(Object value) {
        return DfTypeUtil.toDate(value);
    }

    protected static Timestamp cttp(Object value) {
        return DfTypeUtil.toTimestamp(value);
    }

    protected static Time cttm(Object value) {
        return DfTypeUtil.toTime(value);
    }

    @Override
    public String getTableAlias() {
        return null;
    }

    @Override
    public String getTableComment() {
        return null;
    }

    @Override
    public boolean hasColumn(String columnFlexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        return this.getColumnInfoFlexibleMap().containsKey(columnFlexibleName);
    }

    @Override
    public ColumnInfo findColumnInfo(String columnFlexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        Map<String, ColumnInfo> flexibleMap = this.getColumnInfoFlexibleMap();
        ColumnInfo columnInfo = flexibleMap.get(columnFlexibleName);
        if (columnInfo == null) {
            String notice = "The column info was not found.";
            String keyName = "Column";
            this.throwDBMetaNotFoundException("The column info was not found.", "Column", columnFlexibleName, flexibleMap.keySet());
        }
        return columnInfo;
    }

    protected ColumnInfo cci(String columnDbName, String columnSqlName, String columnSynonym, String columnAlias, Class<?> objectNativeType, String propertyName, Class<?> propertyAccessType, boolean primary, boolean autoIncrement, boolean notNull, String columnDbType, Integer columnSize, Integer decimalDigits, Integer datetimePrecision, String defaultValue, boolean commonColumn, DBMeta.OptimisticLockType optimisticLockType, String columnComment, String foreignListExp, String referrerListExp, ClassificationMeta classificationMeta, boolean canBeNullObject) {
        Class<?> realPt = this.chooseColumnPropertyAccessType(objectNativeType, propertyName, propertyAccessType);
        String delimiter = ",";
        List<String> foreignPropList = null;
        if (foreignListExp != null && foreignListExp.trim().length() > 0) {
            foreignPropList = this.splitListTrimmed(foreignListExp, ",");
        }
        List<String> referrerPropList = null;
        if (referrerListExp != null && referrerListExp.trim().length() > 0) {
            referrerPropList = this.splitListTrimmed(referrerListExp, ",");
        }
        PropertyMethodFinder propertyMethodFinder = this.createColumnPropertyMethodFinder();
        return new ColumnInfo(this, columnDbName, columnSqlName, columnSynonym, columnAlias, objectNativeType, propertyName, realPt, primary, autoIncrement, notNull, columnDbType, columnSize, decimalDigits, datetimePrecision, defaultValue, commonColumn, optimisticLockType, columnComment, foreignPropList, referrerPropList, classificationMeta, canBeNullObject, propertyMethodFinder);
    }

    protected Class<?> chooseColumnPropertyAccessType(Class<?> objectNativeType, String propertyName, Class<?> propertyAccessType) {
        return propertyAccessType != null ? propertyAccessType : objectNativeType;
    }

    protected PropertyMethodFinder createColumnPropertyMethodFinder() {
        return new PropertyMethodFinder(){

            @Override
            public Method findReadMethod(Class<?> beanType, String propertyName, Class<?> propertyAccessType) {
                return AbstractDBMeta.this.findPropertyReadMethod(beanType, propertyName, propertyAccessType);
            }

            @Override
            public Method findWriteMethod(Class<?> beanType, String propertyName, Class<?> propertyAccessType) {
                return AbstractDBMeta.this.findPropertyWriteMethod(beanType, propertyName, propertyAccessType);
            }
        };
    }

    protected Method findPropertyReadMethod(Class<?> beanType, String propertyName, Class<?> propertyAccessType) {
        String methodName = this.buildPropertyGetterMethodName(propertyName);
        Method method = this.doFindPropertyMethod(beanType, methodName, new Class[0]);
        if (method == null) {
            String msg = "Not found the read method by the name:";
            msg = msg + " " + beanType.getName() + "#" + methodName + "()";
            throw new IllegalStateException(msg);
        }
        return method;
    }

    protected Method findPropertyWriteMethod(Class<?> beanType, String propertyName, Class<?> propertyAccessType) {
        String methodName = this.buildPropertySetterMethodName(propertyName);
        Method method = this.doFindPropertyMethod(beanType, methodName, new Class[]{propertyAccessType});
        if (method == null) {
            String msg = "Not found the write method by the name and type:";
            msg = msg + " " + beanType.getName() + "#" + methodName + "(" + propertyAccessType.getName() + ")";
            throw new IllegalStateException(msg);
        }
        return method;
    }

    protected String buildPropertyGetterMethodName(String propertyName) {
        return "get" + this.initCap(propertyName);
    }

    protected String buildPropertySetterMethodName(String propertyName) {
        return "set" + this.initCap(propertyName);
    }

    protected Method doFindPropertyMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        return DfReflectionUtil.getAccessibleMethod(clazz, methodName, argTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ColumnInfo> getColumnInfoList() {
        if (this._columnInfoList != null) {
            return this._columnInfoList;
        }
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._columnInfoList != null) {
                return this._columnInfoList;
            }
            this._columnInfoList = Collections.unmodifiableList(this.ccil());
            return this._columnInfoList;
        }
    }

    protected abstract List<ColumnInfo> ccil();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, ColumnInfo> getColumnInfoFlexibleMap() {
        if (this._columnInfoFlexibleMap != null) {
            return this._columnInfoFlexibleMap;
        }
        List<ColumnInfo> columnInfoList = this.getColumnInfoList();
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._columnInfoFlexibleMap != null) {
                return this._columnInfoFlexibleMap;
            }
            this._columnInfoFlexibleMap = this.createFlexibleConcurrentMap();
            for (ColumnInfo columnInfo : columnInfoList) {
                columnInfo.diveIntoFlexibleMap(this._columnInfoFlexibleMap);
            }
            return this._columnInfoFlexibleMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrimaryInfo getPrimaryInfo() {
        if (this._primaryInfo != null) {
            return this._primaryInfo;
        }
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._primaryInfo != null) {
                return this._primaryInfo;
            }
            this._primaryInfo = new PrimaryInfo(this.cpui());
            return this._primaryInfo;
        }
    }

    protected abstract UniqueInfo cpui();

    @Override
    public UniqueInfo getPrimaryUniqueInfo() {
        return this.getPrimaryInfo().getUniqueInfo();
    }

    protected UniqueInfo hpcpui(ColumnInfo uniqueColumnInfo) {
        return this.hpcpui(Arrays.asList(uniqueColumnInfo));
    }

    protected UniqueInfo hpcpui(List<ColumnInfo> uniqueColumnInfoList) {
        return new UniqueInfo(this, uniqueColumnInfoList, true);
    }

    @Override
    public OptionalObject<PrimaryInfo> searchPrimaryInfo(Collection<ColumnInfo> columnInfoList) {
        PrimaryInfo primaryInfo = this.getPrimaryInfo();
        HashSet<ColumnInfo> colSet = new HashSet<ColumnInfo>(columnInfoList);
        List<ColumnInfo> pkList = primaryInfo.getPrimaryColumnList();
        for (ColumnInfo pk : pkList) {
            if (colSet.contains(pk)) continue;
            return OptionalObject.ofNullable(null, () -> this.throwSpecifiedColumnNotPrimaryException(columnInfoList, pkList));
        }
        return OptionalObject.of(primaryInfo);
    }

    protected void throwSpecifiedColumnNotPrimaryException(Collection<ColumnInfo> columnInfoList, List<ColumnInfo> pkList) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the primary key by the columns");
        br.addItem("Table");
        br.addElement(this.getTableDbName());
        br.addItem("Specified Column List");
        br.addElement(columnInfoList);
        br.addItem("Existing PrimaryKey");
        br.addElement(pkList);
        String msg = br.buildExceptionMessage();
        throw new DBMetaNotFoundException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UniqueInfo> getUniqueInfoList() {
        if (this._uniqueInfoList != null) {
            return this._uniqueInfoList;
        }
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._uniqueInfoList != null) {
                return this._uniqueInfoList;
            }
            Method[] methods = this.getClass().getMethods();
            ArrayList workingList = this.newArrayListSized(4);
            String prefix = "uniqueOf";
            Class<UniqueInfo> returnType = UniqueInfo.class;
            for (Method method : methods) {
                if (!method.getName().startsWith("uniqueOf") || !returnType.equals(method.getReturnType())) continue;
                workingList.add((UniqueInfo)DfReflectionUtil.invoke(method, this, null));
            }
            this._uniqueInfoList = Collections.unmodifiableList(workingList);
            return this._uniqueInfoList;
        }
    }

    protected UniqueInfo hpcui(ColumnInfo uniqueColumnInfo) {
        return this.hpcui(Arrays.asList(uniqueColumnInfo));
    }

    protected UniqueInfo hpcui(List<ColumnInfo> uniqueColumnInfoList) {
        return new UniqueInfo(this, uniqueColumnInfoList, false);
    }

    @Override
    public List<UniqueInfo> searchUniqueInfoList(Collection<ColumnInfo> columnInfoList) {
        return this.doSearchMetaInfoList(columnInfoList, this.getUniqueInfoList(), info -> info.getUniqueColumnList());
    }

    protected <INFO> List<INFO> doSearchMetaInfoList(Collection<ColumnInfo> columnInfoList, List<INFO> infoList, Function<INFO, Collection<ColumnInfo>> oneArgLambda) {
        if (infoList.isEmpty()) {
            return DfCollectionUtil.emptyList();
        }
        HashSet<ColumnInfo> specifiedColSet = new HashSet<ColumnInfo>(columnInfoList);
        ArrayList foundInfoList = this.newArrayListSized(infoList.size());
        for (INFO info : infoList) {
            Collection<ColumnInfo> columnList = oneArgLambda.apply(info);
            boolean notFound = false;
            for (ColumnInfo metaCol : columnList) {
                if (specifiedColSet.contains(metaCol)) continue;
                notFound = true;
                break;
            }
            if (notFound) continue;
            foundInfoList.add(info);
        }
        return Collections.unmodifiableList(foundInfoList);
    }

    @Override
    public RelationInfo findRelationInfo(String relationPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("relationPropertyName", relationPropertyName);
        return this.hasForeign(relationPropertyName) ? this.findForeignInfo(relationPropertyName) : this.findReferrerInfo(relationPropertyName);
    }

    @Override
    public boolean hasForeign(String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        return this.getForeignInfoFlexibleMap().containsKey(foreignPropertyName);
    }

    @Override
    public DBMeta findForeignDBMeta(String foreignPropertyName) {
        return this.findForeignInfo(foreignPropertyName).getForeignDBMeta();
    }

    @Override
    public ForeignInfo findForeignInfo(String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        Map<String, ForeignInfo> flexibleMap = this.getForeignInfoFlexibleMap();
        ForeignInfo foreignInfo = flexibleMap.get(foreignPropertyName);
        if (foreignInfo == null) {
            String notice = "The foreign info was not found.";
            String keyName = "Foreign Property";
            this.throwDBMetaNotFoundException("The foreign info was not found.", "Foreign Property", foreignPropertyName, flexibleMap.keySet());
        }
        return foreignInfo;
    }

    @Override
    public ForeignInfo findForeignInfo(int relationNo) {
        Map<Integer, ForeignInfo> relationNoKeyMap = this.getForeignInfoRelationNoKeyMap();
        ForeignInfo foreignInfo = relationNoKeyMap.get(relationNo);
        if (foreignInfo == null) {
            String notice = "The foreign info was not found.";
            String keyName = "Relation No";
            this.throwDBMetaNotFoundException("The foreign info was not found.", "Relation No", relationNo, relationNoKeyMap.keySet());
        }
        return foreignInfo;
    }

    protected ForeignInfo cfi(String constraintName, String foreignPropertyName, DBMeta localDbm, DBMeta foreignDbm, Map<ColumnInfo, ColumnInfo> localForeignColumnInfoMap, int relationNo, Class<?> propertyAccessType, boolean oneToOne, boolean bizOneToOne, boolean referrerAsOne, boolean additionalFK, String fixedCondition, List<String> dynamicParameterList, boolean fixedInline, String reversePropertyName, boolean canBeNullObject) {
        Class<?> realPt = this.chooseForeignPropertyAccessType(foreignDbm, propertyAccessType);
        PropertyMethodFinder propertyMethodFinder = this.createForeignPropertyMethodFinder();
        return new ForeignInfo(constraintName, foreignPropertyName, localDbm, foreignDbm, localForeignColumnInfoMap, relationNo, realPt, oneToOne, bizOneToOne, referrerAsOne, additionalFK, fixedCondition, dynamicParameterList, fixedInline, reversePropertyName, canBeNullObject, propertyMethodFinder);
    }

    protected Class<?> chooseForeignPropertyAccessType(DBMeta foreignDbm, Class<?> specifiedType) {
        return specifiedType != null ? specifiedType : foreignDbm.getEntityType();
    }

    protected PropertyMethodFinder createForeignPropertyMethodFinder() {
        return new PropertyMethodFinder(){

            @Override
            public Method findReadMethod(Class<?> beanType, String propertyName, Class<?> propertyAccessType) {
                return AbstractDBMeta.this.findPropertyReadMethod(beanType, propertyName, propertyAccessType);
            }

            @Override
            public Method findWriteMethod(Class<?> beanType, String propertyName, Class<?> propertyAccessType) {
                return AbstractDBMeta.this.findPropertyWriteMethod(beanType, propertyName, propertyAccessType);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ForeignInfo> getForeignInfoList() {
        if (this._foreignInfoList != null) {
            return this._foreignInfoList;
        }
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._foreignInfoList != null) {
                return this._foreignInfoList;
            }
            Method[] methods = this.getClass().getMethods();
            ArrayList workingList = this.newArrayList();
            String prefix = "foreign";
            Class<ForeignInfo> returnType = ForeignInfo.class;
            for (Method method : methods) {
                if (!method.getName().startsWith("foreign") || !returnType.equals(method.getReturnType())) continue;
                workingList.add((ForeignInfo)DfReflectionUtil.invoke(method, this, null));
            }
            this._foreignInfoList = Collections.unmodifiableList(workingList);
            return this._foreignInfoList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, ForeignInfo> getForeignInfoFlexibleMap() {
        if (this._foreignInfoFlexibleMap != null) {
            return this._foreignInfoFlexibleMap;
        }
        List<ForeignInfo> foreignInfoList = this.getForeignInfoList();
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._foreignInfoFlexibleMap != null) {
                return this._foreignInfoFlexibleMap;
            }
            StringKeyMap<ForeignInfo> map = this.createFlexibleConcurrentMap();
            for (ForeignInfo foreignInfo : foreignInfoList) {
                map.put(foreignInfo.getForeignPropertyName(), foreignInfo);
            }
            this._foreignInfoFlexibleMap = Collections.unmodifiableMap(map);
            return this._foreignInfoFlexibleMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Integer, ForeignInfo> getForeignInfoRelationNoKeyMap() {
        if (this._foreignInfoRelationNoKeyMap != null) {
            return this._foreignInfoRelationNoKeyMap;
        }
        List<ForeignInfo> foreignInfoList = this.getForeignInfoList();
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._foreignInfoRelationNoKeyMap != null) {
                return this._foreignInfoRelationNoKeyMap;
            }
            ConcurrentHashMap map = this.newConcurrentHashMap();
            for (ForeignInfo foreignInfo : foreignInfoList) {
                map.put(foreignInfo.getRelationNo(), foreignInfo);
            }
            this._foreignInfoRelationNoKeyMap = Collections.unmodifiableMap(map);
            return this._foreignInfoRelationNoKeyMap;
        }
    }

    @Override
    public List<ForeignInfo> searchForeignInfoList(Collection<ColumnInfo> columnInfoList) {
        return this.doSearchMetaInfoList(columnInfoList, this.getForeignInfoList(), info -> info.getLocalForeignColumnInfoMap().keySet());
    }

    @Override
    public boolean hasReferrer(String referrerPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("referrerPropertyName", referrerPropertyName);
        return this.getReferrerInfoFlexibleMap().containsKey(referrerPropertyName);
    }

    @Override
    public DBMeta findReferrerDBMeta(String referrerPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("referrerPropertyName", referrerPropertyName);
        return this.findReferrerInfo(referrerPropertyName).getReferrerDBMeta();
    }

    @Override
    public ReferrerInfo findReferrerInfo(String referrerPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("referrerPropertyName", referrerPropertyName);
        Map<String, ReferrerInfo> flexibleMap = this.getReferrerInfoFlexibleMap();
        ReferrerInfo referrerInfo = flexibleMap.get(referrerPropertyName);
        if (referrerInfo == null) {
            String notice = "The referrer info was not found.";
            String keyName = "Referrer Property";
            this.throwDBMetaNotFoundException("The referrer info was not found.", "Referrer Property", referrerPropertyName, flexibleMap.keySet());
        }
        return referrerInfo;
    }

    protected ReferrerInfo cri(String constraintName, String referrerPropertyName, DBMeta localDbm, DBMeta referrerDbm, Map<ColumnInfo, ColumnInfo> localReferrerColumnInfoMap, boolean oneToOne, String reversePropertyName) {
        Class<?> propertyAccessType = this.chooseReferrerPropertyAccessType(referrerDbm, oneToOne);
        PropertyMethodFinder propertyMethodFinder = this.createReferrerPropertyMethodFinder();
        return new ReferrerInfo(constraintName, referrerPropertyName, localDbm, referrerDbm, localReferrerColumnInfoMap, propertyAccessType, oneToOne, reversePropertyName, propertyMethodFinder);
    }

    protected Class<?> chooseReferrerPropertyAccessType(DBMeta referrerDbm, boolean oneToOne) {
        Class<?> listType;
        Class<Object> propertyType = oneToOne ? referrerDbm.getEntityType() : ((listType = this.getReferrerPropertyListType()) != null ? listType : List.class);
        return propertyType;
    }

    protected Class<?> getReferrerPropertyListType() {
        return null;
    }

    protected PropertyMethodFinder createReferrerPropertyMethodFinder() {
        return new PropertyMethodFinder(){

            @Override
            public Method findReadMethod(Class<?> beanType, String propertyName, Class<?> propertyAccessType) {
                return AbstractDBMeta.this.findPropertyReadMethod(beanType, propertyName, propertyAccessType);
            }

            @Override
            public Method findWriteMethod(Class<?> beanType, String propertyName, Class<?> propertyAccessType) {
                return AbstractDBMeta.this.findPropertyWriteMethod(beanType, propertyName, propertyAccessType);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ReferrerInfo> getReferrerInfoList() {
        if (this._referrerInfoList != null) {
            return this._referrerInfoList;
        }
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._referrerInfoList != null) {
                return this._referrerInfoList;
            }
            Method[] methods = this.getClass().getMethods();
            ArrayList workingList = this.newArrayList();
            String prefix = "referrer";
            Class<ReferrerInfo> returnType = ReferrerInfo.class;
            for (Method method : methods) {
                if (!method.getName().startsWith("referrer") || !returnType.equals(method.getReturnType())) continue;
                workingList.add((ReferrerInfo)DfReflectionUtil.invoke(method, this, null));
            }
            this._referrerInfoList = Collections.unmodifiableList(workingList);
            return this._referrerInfoList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, ReferrerInfo> getReferrerInfoFlexibleMap() {
        if (this._referrerInfoFlexibleMap != null) {
            return this._referrerInfoFlexibleMap;
        }
        List<ReferrerInfo> referrerInfoList = this.getReferrerInfoList();
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._referrerInfoFlexibleMap != null) {
                return this._referrerInfoFlexibleMap;
            }
            StringKeyMap<ReferrerInfo> map = this.createFlexibleConcurrentMap();
            for (ReferrerInfo referrerInfo : referrerInfoList) {
                map.put(referrerInfo.getReferrerPropertyName(), referrerInfo);
            }
            this._referrerInfoFlexibleMap = Collections.unmodifiableMap(map);
            return this._referrerInfoFlexibleMap;
        }
    }

    @Override
    public List<ReferrerInfo> searchReferrerInfoList(Collection<ColumnInfo> columnInfoList) {
        return this.doSearchMetaInfoList(columnInfoList, this.getReferrerInfoList(), info -> info.getLocalReferrerColumnInfoMap().keySet());
    }

    protected String buildRelationInfoGetterMethodNameInitCap(String targetName, String relationPropertyName) {
        return targetName + relationPropertyName.substring(0, 1).toUpperCase() + relationPropertyName.substring(1);
    }

    @Override
    public boolean hasIdentity() {
        return false;
    }

    @Override
    public boolean hasSequence() {
        return false;
    }

    @Override
    public String getSequenceName() {
        return null;
    }

    @Override
    public String getSequenceNextValSql() {
        if (!this.hasSequence()) {
            return null;
        }
        return this.getCurrentDBDef().dbway().buildSequenceNextValSql(this.getSequenceName());
    }

    @Override
    public Integer getSequenceIncrementSize() {
        return null;
    }

    @Override
    public Integer getSequenceCacheSize() {
        return null;
    }

    @Override
    public boolean hasOptimisticLock() {
        return this.hasVersionNo() || this.hasUpdateDate();
    }

    @Override
    public boolean hasVersionNo() {
        return false;
    }

    @Override
    public ColumnInfo getVersionNoColumnInfo() {
        return null;
    }

    @Override
    public boolean hasUpdateDate() {
        return false;
    }

    @Override
    public ColumnInfo getUpdateDateColumnInfo() {
        return null;
    }

    @Override
    public boolean hasCommonColumn() {
        return false;
    }

    @Override
    public List<ColumnInfo> getCommonColumnInfoList() {
        return DfCollectionUtil.emptyList();
    }

    @Override
    public List<ColumnInfo> getCommonColumnInfoBeforeInsertList() {
        return DfCollectionUtil.emptyList();
    }

    @Override
    public List<ColumnInfo> getCommonColumnInfoBeforeUpdateList() {
        return DfCollectionUtil.emptyList();
    }

    protected <ENTITY extends Entity> void doAcceptPrimaryKeyMap(ENTITY entity, Map<String, ? extends Object> primaryKeyMap) {
        this.assertObjectNotNull("entity", entity);
        if (primaryKeyMap == null || primaryKeyMap.isEmpty()) {
            String msg = "The argument 'primaryKeyMap' should not be null or empty: primaryKeyMap=" + primaryKeyMap;
            throw new IllegalArgumentException(msg);
        }
        this.doConvertToEntity(entity, primaryKeyMap, true);
    }

    protected <ENTITY extends Entity> void doAcceptAllColumnMap(ENTITY entity, Map<String, ? extends Object> allColumnMap) {
        this.assertObjectNotNull("entity", entity);
        if (allColumnMap == null || allColumnMap.isEmpty()) {
            String msg = "The argument 'allColumnMap' should not be null or empty: allColumnMap=" + allColumnMap;
            throw new IllegalArgumentException(msg);
        }
        this.doConvertToEntity(entity, allColumnMap, false);
    }

    protected <ENTITY extends Entity> void doConvertToEntity(ENTITY entity, Map<String, ? extends Object> columnMap, boolean pkOnly) {
        List<ColumnInfo> columnInfoList = pkOnly ? this.getPrimaryInfo().getPrimaryColumnList() : this.getColumnInfoList();
        MetaHandlingMapToEntityMapper mapper = this.createMetaHandlingMapToEntityMapper(columnMap);
        mapper.mappingToEntity(entity, columnMap, columnInfoList);
    }

    protected MetaHandlingMapToEntityMapper createMetaHandlingMapToEntityMapper(Map<String, ? extends Object> columnMap) {
        return new MetaHandlingMapToEntityMapper(columnMap);
    }

    protected Map<String, Object> doExtractPrimaryKeyMap(Entity entity) {
        this.assertObjectNotNull("entity", entity);
        return this.doConvertToColumnValueMap(entity, true);
    }

    protected Map<String, Object> doExtractAllColumnMap(Entity entity) {
        this.assertObjectNotNull("entity", entity);
        return this.doConvertToColumnValueMap(entity, false);
    }

    protected Map<String, Object> doConvertToColumnValueMap(Entity entity, boolean pkOnly) {
        List<ColumnInfo> columnInfoList = pkOnly ? this.getPrimaryInfo().getPrimaryColumnList() : this.getColumnInfoList();
        MetaHandlingEntityToMapMapper mapper = this.createMetaHandlingEntityToMapMapper(entity);
        return mapper.mappingToColumnValueMap(columnInfoList);
    }

    protected MetaHandlingEntityToMapMapper createMetaHandlingEntityToMapMapper(Entity entity) {
        return new MetaHandlingEntityToMapMapper(entity);
    }

    protected <ENTITY> ENTITY downcast(Entity entity) {
        this.checkDowncast(entity);
        return (ENTITY)entity;
    }

    protected void checkDowncast(Entity entity) {
        this.assertObjectNotNull("entity", entity);
        Class<? extends Entity> entityType = this.getEntityType();
        Class<?> targetType = entity.getClass();
        if (!entityType.isAssignableFrom(targetType)) {
            String titleName = DfTypeUtil.toClassTitle(entityType);
            String msg = "The entity should be " + titleName + " but it was: " + targetType;
            throw new IllegalStateException(msg);
        }
    }

    protected Map<String, String> setupKeyToLowerMap(boolean dbNameKey) {
        ConcurrentHashMap<String, String> map = dbNameKey ? this.newConcurrentHashMap(this.getTableDbName().toLowerCase(), this.getTablePropertyName()) : this.newConcurrentHashMap(this.getTablePropertyName().toLowerCase(), this.getTableDbName());
        Method[] methods = this.getClass().getMethods();
        String columnInfoMethodPrefix = "column";
        try {
            for (Method method : methods) {
                String name = method.getName();
                if (!name.startsWith("column")) continue;
                ColumnInfo columnInfo = (ColumnInfo)method.invoke((Object)this, new Object[0]);
                String dbName = columnInfo.getColumnDbName();
                String propertyName = columnInfo.getPropertyName();
                if (dbNameKey) {
                    map.put(dbName.toLowerCase(), propertyName);
                    continue;
                }
                map.put(propertyName.toLowerCase(), dbName);
            }
            return Collections.unmodifiableMap(map);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected void throwDBMetaNotFoundException(String notice, String keyName, Object value, Set<? extends Object> keySet) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice(notice);
        br.addItem("Table");
        br.addElement(this.getTableDbName());
        br.addItem(keyName);
        br.addElement(value);
        br.addItem("Existing KeySet");
        br.addElement(keySet);
        String msg = br.buildExceptionMessage();
        throw new DBMetaNotFoundException(msg);
    }

    protected final String replaceString(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    protected final List<String> splitListTrimmed(String str, String delimiter) {
        return Srl.splitListTrimmed(str, delimiter);
    }

    protected final String initCap(String str) {
        return Srl.initCap(str);
    }

    protected final String initUncap(String str) {
        return Srl.initUncap(str);
    }

    protected final String ln() {
        return DBFluteSystem.ln();
    }

    protected <KEY, VALUE> HashMap<KEY, VALUE> newHashMap() {
        return DfCollectionUtil.newHashMap();
    }

    protected <KEY, VALUE> ConcurrentHashMap<KEY, VALUE> newConcurrentHashMap() {
        return DfCollectionUtil.newConcurrentHashMap();
    }

    protected <KEY, VALUE> ConcurrentHashMap<KEY, VALUE> newConcurrentHashMap(KEY key, VALUE value) {
        ConcurrentHashMap<KEY, VALUE> map = this.newConcurrentHashMap();
        map.put(key, value);
        return map;
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap() {
        return DfCollectionUtil.newLinkedHashMap();
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap(KEY key, VALUE value) {
        LinkedHashMap<KEY, VALUE> map = this.newLinkedHashMap();
        map.put(key, value);
        return map;
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMapSized(int size) {
        return DfCollectionUtil.newLinkedHashMapSized(size);
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList() {
        return DfCollectionUtil.newArrayList();
    }

    @SafeVarargs
    protected final <ELEMENT> List<ELEMENT> newArrayList(ELEMENT ... elements) {
        ArrayList<ELEMENT> list = this.newArrayList();
        for (ELEMENT element : elements) {
            list.add(element);
        }
        return list;
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList(Collection<ELEMENT> collection) {
        return DfCollectionUtil.newArrayList(collection);
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayListSized(int size) {
        return DfCollectionUtil.newArrayListSized(size);
    }

    protected <VALUE> StringKeyMap<VALUE> createFlexibleConcurrentMap() {
        return StringKeyMap.createAsFlexibleConcurrent();
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        DfAssertUtil.assertObjectNotNull(variableName, value);
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        DfAssertUtil.assertStringNotNullAndNotTrimmedEmpty(variableName, value);
    }
}

