/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean.paging.numberlink.range;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.dbflute.cbean.paging.numberlink.PageNumberLink;
import org.dbflute.cbean.paging.numberlink.PageNumberLinkSetupper;
import org.dbflute.cbean.paging.numberlink.range.PageRangeOption;

public class PageRangeBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int _currentPageNumber;
    protected int _allPageCount;
    protected PageRangeOption _pageRangeOption;
    protected List<Integer> _cachedPageNumberList;

    public <LINK extends PageNumberLink> List<LINK> buildPageNumberLinkList(PageNumberLinkSetupper<LINK> manyArgLambda) {
        List<Integer> pageNumberList = this.createPageNumberList();
        ArrayList<LINK> pageNumberLinkList = new ArrayList<LINK>();
        for (Integer pageNumber : pageNumberList) {
            pageNumberLinkList.add(manyArgLambda.setup(pageNumber, pageNumber.equals(this._currentPageNumber)));
        }
        return pageNumberLinkList;
    }

    public List<Integer> createPageNumberList() {
        this.assertPageRangeValid();
        if (this._cachedPageNumberList != null) {
            return this._cachedPageNumberList;
        }
        int pageRangeSize = this._pageRangeOption.getPageRangeSize();
        int allPageCount = this._allPageCount;
        int currentPageNumber = this._currentPageNumber;
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        for (int i = currentPageNumber - pageRangeSize; i < currentPageNumber; ++i) {
            if (i < 1) continue;
            resultList.add(i);
        }
        resultList.add(currentPageNumber);
        int endPageNumber = currentPageNumber + pageRangeSize;
        for (int i = currentPageNumber + 1; i <= endPageNumber && i <= allPageCount; ++i) {
            resultList.add(i);
        }
        boolean fillLimit = this._pageRangeOption.isFillLimit();
        int limitSize = pageRangeSize * 2 + 1;
        if (fillLimit && !resultList.isEmpty() && resultList.size() < limitSize) {
            int i;
            Integer firstElements = (Integer)resultList.get(0);
            Integer lastElements = (Integer)resultList.get(resultList.size() - 1);
            if (firstElements > 1) {
                for (i = firstElements - 1; resultList.size() < limitSize && i > 0; --i) {
                    resultList.add(0, i);
                }
            }
            for (i = lastElements + 1; resultList.size() < limitSize && i <= allPageCount; ++i) {
                resultList.add(i);
            }
        }
        this._cachedPageNumberList = resultList;
        return this._cachedPageNumberList;
    }

    public boolean existsPreviousRange() {
        this.assertPageRangeValid();
        List<Integer> ls = this.createPageNumberList();
        if (ls.isEmpty()) {
            return false;
        }
        return ls.get(0) > 1;
    }

    public boolean existsNextRange() {
        this.assertPageRangeValid();
        List<Integer> ls = this.createPageNumberList();
        if (ls.isEmpty()) {
            return false;
        }
        return ls.get(ls.size() - 1) < this._allPageCount;
    }

    public boolean isExistPrePageRange() {
        return this.existsPreviousRange();
    }

    public boolean isExistNextPageRange() {
        return this.existsNextRange();
    }

    protected int[] convertListToIntArray(List<Integer> ls) {
        int[] resultArray = new int[ls.size()];
        int arrayIndex = 0;
        int[] nArray = resultArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int pageNumber;
            resultArray[arrayIndex] = pageNumber = nArray[i];
            ++arrayIndex;
        }
        return resultArray;
    }

    protected void assertPageRangeValid() {
        if (this._pageRangeOption == null) {
            String msg = "The pageRangeOption should not be null. Please call setPageRangeOption().";
            throw new IllegalStateException(msg);
        }
        int pageRangeSize = this._pageRangeOption.getPageRangeSize();
        if (pageRangeSize == 0) {
            String msg = "The pageRangeSize should be greater than 1. But the value is zero.";
            throw new IllegalStateException(msg);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("currentPageNumber=").append(this._currentPageNumber);
        sb.append(", allPageCount=").append(this._allPageCount);
        sb.append(", pageRangeOption=").append(this._pageRangeOption);
        sb.append("}");
        return sb.toString();
    }

    public void setCurrentPageNumber(int currentPageNumber) {
        this._currentPageNumber = currentPageNumber;
    }

    public void setAllPageCount(int allPageCount) {
        this._allPageCount = allPageCount;
    }

    public PageRangeOption getPageRangeOption() {
        return this._pageRangeOption;
    }

    public void setPageRangeOption(PageRangeOption pageRangeOption) {
        this._pageRangeOption = pageRangeOption;
    }

    public int getPreviousRangeNearestPageNumber() {
        if (!this.existsPreviousRange()) {
            String msg = "The previous page range should exist when you use previousRangeNearestPageNumber:";
            msg = msg + " currentPageNumber=" + this._currentPageNumber + " allPageCount=" + this._allPageCount;
            msg = msg + " pageRangeOption=" + this._pageRangeOption;
            throw new IllegalStateException(msg);
        }
        return this.createPageNumberList().get(0) - 1;
    }

    public int getNextRangeNearestPageNumber() {
        if (!this.existsNextRange()) {
            String msg = "The next page range should exist when you use nextRangeNearestPageNumber:";
            msg = msg + " currentPageNumber=" + this._currentPageNumber + " allPageCount=" + this._allPageCount;
            msg = msg + " pageRangeOption=" + this._pageRangeOption;
            throw new IllegalStateException(msg);
        }
        List<Integer> ls = this.createPageNumberList();
        return ls.get(ls.size() - 1) + 1;
    }

    public int getPreRangeNearestPageNumber() {
        return this.getPreviousRangeNearestPageNumber();
    }
}

