/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.bhv.logging.result;

import java.util.List;
import org.dbflute.Entity;
import org.dbflute.util.DfTraceViewUtil;

public class BehaviorResultBuilder {
    public <RESULT> String buildResultExp(Class<?> retType, Object ret, long before, long after) {
        try {
            return this.doBuildResultExp(retType, ret, before, after);
        }
        catch (RuntimeException e) {
            String msg = "Failed to build result expression for logging: retType=" + retType + " ret=" + ret;
            throw new IllegalStateException(msg, e);
        }
    }

    protected String doBuildResultExp(Class<?> retType, Object ret, long before, long after) {
        String resultExp;
        String prefix = "===========/ [" + DfTraceViewUtil.convertToPerformanceView(after - before) + " ";
        if (List.class.isAssignableFrom(retType)) {
            List ls;
            resultExp = ret == null ? prefix + "(null)]" : ((ls = (List)ret).isEmpty() ? prefix + "(0)]" : prefix + "(" + ls.size() + ") first=" + this.buildEntityExp(ls.get(0)) + "]");
        } else if (Entity.class.isAssignableFrom(retType)) {
            if (ret == null) {
                resultExp = prefix + "(null)]";
            } else {
                Entity entity = (Entity)ret;
                resultExp = prefix + "(1) entity=" + this.buildEntityExp(entity) + "]";
            }
        } else if (int[].class.isAssignableFrom(retType)) {
            if (ret == null) {
                resultExp = prefix + "(null)]";
            } else {
                int[] resultArray = (int[])ret;
                resultExp = this.buildBatchUpdateResultExp(prefix, resultArray);
            }
        } else {
            resultExp = prefix + "result=" + ret + "]";
        }
        return resultExp;
    }

    protected String buildEntityExp(Object obj) {
        if (obj instanceof Entity) {
            Entity entity = (Entity)obj;
            return entity.buildDisplayString(null, true, true);
        }
        return obj != null ? obj.toString() : "null";
    }

    protected String buildBatchUpdateResultExp(String prefix, int[] resultArray) {
        if (resultArray.length == 0) {
            return prefix + "all-updated=(0)]";
        }
        StringBuilder sb = new StringBuilder();
        boolean resultExpressionScope = true;
        int resultCount = 0;
        int loopCount = 0;
        for (int element : resultArray) {
            resultCount += element;
            if (resultExpressionScope) {
                if (loopCount <= 10) {
                    if (sb.length() == 0) {
                        sb.append(element);
                    } else {
                        sb.append(",").append(element);
                    }
                } else {
                    sb.append(",").append("...");
                    resultExpressionScope = false;
                }
            }
            ++loopCount;
        }
        sb.insert(0, "{").append("}");
        String result = sb.toString();
        String returnExp = resultCount >= 0 ? prefix + "all-updated=(" + resultCount + ") result=" + result + "]" : prefix + "result=" + result + "]";
        return returnExp;
    }
}

