/*
 * Copyright 2014-2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.dbflute.system.provider;

import java.util.Locale;

/**
 * @author jflute
 * @since 1.1.0 (2014/10/26 Sunday)
 */
@FunctionalInterface
public interface DfFinalLocaleProvider {

    /**
     * Provide the locale as final default. <br>
     * This might be called many times, so take care of performance.
     * @return The locale instance. (NullAllowed: if null, server locale might be used)
     */
    Locale provide();
}
