/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.util;

import java.math.BigDecimal;

public abstract class ArithmeticUtils {
    protected static boolean needPreciseCalculation(Number lNumber, Number rNumber) {
        return lNumber instanceof BigDecimal || rNumber instanceof BigDecimal;
    }

    protected static BigDecimal toBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        return new BigDecimal(number.toString());
    }

    public static Number add(Number v1, Number v2) {
        if (ArithmeticUtils.needPreciseCalculation(v1, v2)) {
            BigDecimal n1 = ArithmeticUtils.toBigDecimal(v1);
            BigDecimal n2 = ArithmeticUtils.toBigDecimal(v2);
            return n1.add(n2);
        }
        return v1.doubleValue() + v2.doubleValue();
    }

    public static Number subtract(Number v1, Number v2) {
        if (ArithmeticUtils.needPreciseCalculation(v1, v2)) {
            BigDecimal n1 = ArithmeticUtils.toBigDecimal(v1);
            BigDecimal n2 = ArithmeticUtils.toBigDecimal(v2);
            return n1.subtract(n2);
        }
        return v1.doubleValue() - v2.doubleValue();
    }

    public static Number divide(Number v1, Number v2) {
        if (v2.doubleValue() == 0.0) {
            return Double.NaN;
        }
        if (ArithmeticUtils.needPreciseCalculation(v1, v2)) {
            BigDecimal n1 = ArithmeticUtils.toBigDecimal(v1);
            BigDecimal n2 = ArithmeticUtils.toBigDecimal(v2);
            return n1.divide(n2, 6, 4);
        }
        return v1.doubleValue() / v2.doubleValue();
    }

    public static Number multiply(Number v1, Number v2) {
        if (ArithmeticUtils.needPreciseCalculation(v1, v2)) {
            BigDecimal n1 = ArithmeticUtils.toBigDecimal(v1);
            BigDecimal n2 = ArithmeticUtils.toBigDecimal(v2);
            return n1.multiply(n2);
        }
        return v1.doubleValue() * v2.doubleValue();
    }
}

