/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.variable;

import org.apache.commons.lang3.Validate;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.OperandType;
import org.datayoo.moql.operand.AbstractOperand;
import org.datayoo.moql.operand.variable.Variable;

public class SingleVariable
extends AbstractOperand
implements Variable {
    public SingleVariable(String name) {
        this.operandType = OperandType.VARIABLE;
        Validate.notEmpty((CharSequence)name, (String)"name is empty!", (Object[])new Object[0]);
        if (name.charAt(0) == '`') {
            name = name.substring(1, name.length() - 1);
        }
        this.name = name;
    }

    @Override
    public Object operate(EntityMap entityMap) {
        return entityMap.getEntity(this.name);
    }

    @Override
    public void clear() {
    }

    @Override
    public void bind(String[] entityNames) {
        for (int i = 0; i < entityNames.length; ++i) {
            if (!entityNames[i].equals(this.name)) continue;
            this.operandIndex = i;
            this.binded = true;
            return;
        }
        throw new IllegalArgumentException(String.format("There is no entity named '%s'!", this.name));
    }

    @Override
    public Object operate(Object[] entityArray) {
        return entityArray[this.operandIndex];
    }

    @Override
    public Operand setValue(Object[] entityArray, Object value) {
        entityArray[this.operandIndex] = value;
        return this;
    }

    @Override
    public Operand setValue(EntityMap entityMap, Object value) {
        entityMap.putEntity(this.name, value);
        return this;
    }
}

