/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.function.AggregationFunction;
import org.datayoo.moql.operand.function.Counter;

public class Mode
extends AggregationFunction {
    public static final String FUNCTION_NAME = "mode";
    protected Operand operand;
    protected Map<Object, InnerCounter> counters = new HashMap<Object, InnerCounter>();

    public Mode(List<Operand> parameters) {
        super(FUNCTION_NAME, 1, parameters);
        this.operand = parameters.get(0);
    }

    @Override
    public void increment(EntityMap entityMap) {
        Object obj = this.operand.operate(entityMap);
        if (obj == null) {
            return;
        }
        InnerCounter counter = this.counters.get(obj);
        if (counter == null) {
            counter = new InnerCounter(0L);
            counter.setObj(obj);
            this.counters.put(obj, counter);
        }
        counter.add(1L);
    }

    @Override
    public void increment(Object[] entityArray) {
        Object obj = this.operand.operate(entityArray);
        if (obj == null) {
            return;
        }
        InnerCounter counter = this.counters.get(obj);
        if (counter == null) {
            counter = new InnerCounter(0L);
            counter.setObj(obj);
            this.counters.put(obj, counter);
        }
        counter.add(1L);
    }

    @Override
    public Object getValue() {
        InnerCounter counter;
        if (this.counters.size() == 0) {
            return null;
        }
        ArrayList<InnerCounter> counterList = new ArrayList<InnerCounter>(this.counters.values());
        Collections.sort(counterList);
        Collections.reverse(counterList);
        int size = 0;
        long maxCount = ((InnerCounter)counterList.get(0)).getCount();
        Iterator iterator = counterList.iterator();
        while (iterator.hasNext() && (counter = (InnerCounter)iterator.next()).getCount() == maxCount) {
            ++size;
        }
        Object[] modeArray = new Object[size];
        for (int i = 0; i < size; ++i) {
            modeArray[i] = ((InnerCounter)counterList.get(i)).getObj();
        }
        return modeArray;
    }

    @Override
    public void clear() {
        this.counters.clear();
    }

    class InnerCounter
    extends Counter {
        private static final long serialVersionUID = 1L;
        protected Object obj;

        public InnerCounter(long value) {
            super(value);
        }

        public Object getObj() {
            return this.obj;
        }

        public void setObj(Object obj) {
            this.obj = obj;
        }
    }
}

