/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.function;

import java.math.BigDecimal;
import java.util.List;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.function.AggregationFunction;

public class Avg
extends AggregationFunction {
    public static final String FUNCTION_NAME = "avg";
    protected Operand operand;
    protected BigDecimal sum = new BigDecimal(0);
    protected long count = 0L;

    public Avg(List<Operand> parameters) {
        super(FUNCTION_NAME, 1, parameters);
        this.operand = parameters.get(0);
    }

    @Override
    public void increment(EntityMap entityMap) {
        Object obj = this.operand.operate(entityMap);
        ++this.count;
        if (obj == null) {
            return;
        }
        BigDecimal num = this.toBigDecimal(obj);
        this.sum = this.sum.add(num);
    }

    @Override
    public void increment(Object[] entityArray) {
        Object obj = this.operand.operate(entityArray);
        ++this.count;
        if (obj == null) {
            return;
        }
        BigDecimal num = this.toBigDecimal(obj);
        this.sum = this.sum.add(num);
    }

    @Override
    public Object getValue() {
        return this.sum.divide(new BigDecimal(this.count), 6, 4).doubleValue();
    }

    @Override
    public synchronized void clear() {
        this.sum = new BigDecimal(0);
        this.count = 0L;
    }
}

