/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.relation;

import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.metadata.OperatorType;
import org.datayoo.moql.operand.expression.RangeExpression;
import org.datayoo.moql.operand.expression.relation.AbstractRelationExpression;
import org.datayoo.moql.operand.expression.relation.RelationOperator;
import org.datayoo.moql.util.CompareHelper;

public class InRangeExpression
extends AbstractRelationExpression {
    protected boolean lClosure = false;
    protected boolean rClosure = false;
    protected Operand lRange;
    protected Operand rRange;

    public InRangeExpression(Operand lOperand, Operand rOperand) {
        super(OperatorType.BINARY, RelationOperator.IN, lOperand, rOperand);
        if (!(rOperand instanceof RangeExpression)) {
            throw new IllegalArgumentException("Invalid right operand!");
        }
        RangeExpression rangeExpression = (RangeExpression)rOperand;
        this.lClosure = rangeExpression.islClosure();
        this.rClosure = rangeExpression.isrClosure();
        this.lRange = rangeExpression.getOperands().get(0);
        this.rRange = rangeExpression.getOperands().get(1);
    }

    @Override
    public boolean booleanOperate(EntityMap entityMap) {
        Object lValue = this.lOperand.operate(entityMap);
        if (lValue == null) {
            return false;
        }
        Object lObj = this.lRange.operate(entityMap);
        int ret = CompareHelper.compare(lValue, lObj);
        if (ret < 0 || ret == 0 && !this.lClosure) {
            return false;
        }
        Object rObj = this.rRange.operate(entityMap);
        ret = CompareHelper.compare(lValue, rObj);
        return ret <= 0 && (ret != 0 || this.rClosure);
    }

    @Override
    public Object operate(Object[] entityArray) {
        Object lValue = this.lOperand.operate(entityArray);
        if (lValue == null) {
            return false;
        }
        Object lObj = this.lRange.operate(entityArray);
        int ret = CompareHelper.compare(lValue, lObj);
        if (ret < 0 || ret == 0 && !this.lClosure) {
            return false;
        }
        Object rObj = this.rRange.operate(this.entityMap);
        ret = CompareHelper.compare(lValue, rObj);
        if (ret > 0 || ret == 0 && !this.rClosure) {
            return false;
        }
        return true;
    }

    @Override
    public Object operate(EntityMap entityMap) {
        return this.booleanOperate(entityMap);
    }
}

