/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.relation;

import java.util.List;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.metadata.OperatorType;
import org.datayoo.moql.operand.expression.OperandsExpression;
import org.datayoo.moql.operand.expression.relation.AbstractRelationExpression;
import org.datayoo.moql.operand.expression.relation.RelationOperator;
import org.datayoo.moql.util.CompareHelper;

public class BetweenExpression
extends AbstractRelationExpression {
    protected List<Operand> rOperands;

    public BetweenExpression(Operand lOperand, Operand rOperand) {
        super(OperatorType.BINARY, RelationOperator.BETWEEN, lOperand, rOperand);
        if (!(rOperand instanceof OperandsExpression)) {
            throw new IllegalArgumentException("Parameter 'rOperand' is not an OperandsExpression class!");
        }
        this.rOperands = ((OperandsExpression)rOperand).getOperands();
        if (this.rOperands.size() != 2) {
            throw new IllegalArgumentException("Parameter 'rOperand' should has 2 operand!");
        }
        this.name = this.delayBuildNameString();
    }

    @Override
    protected String buildNameString() {
        return null;
    }

    protected String delayBuildNameString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.lOperand.toString());
        sbuf.append(' ');
        sbuf.append(this.operator.getOperator());
        sbuf.append(' ');
        sbuf.append(this.rOperands.get(0).toString());
        sbuf.append(' ');
        sbuf.append("and");
        sbuf.append(' ');
        sbuf.append(this.rOperands.get(1).toString());
        return sbuf.toString();
    }

    @Override
    public boolean booleanOperate(EntityMap entityMap) {
        Object lValue = this.lOperand.operate(entityMap);
        Object rLValue = this.rOperands.get(0).operate(entityMap);
        Object rGValue = this.rOperands.get(1).operate(entityMap);
        if (lValue == null || rLValue == null || rGValue == null) {
            return false;
        }
        int ret = CompareHelper.compare(lValue, rLValue);
        if (ret < 0) {
            return false;
        }
        ret = CompareHelper.compare(lValue, rGValue);
        return ret < 0;
    }

    @Override
    public Object operate(EntityMap entityMap) {
        return this.booleanOperate(entityMap);
    }

    public List<Operand> getrOperands() {
        return this.rOperands;
    }

    @Override
    public Object operate(Object[] entityArray) {
        Object lValue = this.lOperand.operate(entityArray);
        Object rLValue = this.rOperands.get(0).operate(entityArray);
        Object rGValue = this.rOperands.get(1).operate(entityArray);
        if (lValue == null || rLValue == null || rGValue == null) {
            return false;
        }
        int ret = CompareHelper.compare(lValue, rLValue);
        if (ret < 0) {
            return false;
        }
        ret = CompareHelper.compare(lValue, rGValue);
        return ret < 0;
    }
}

