/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.member;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.OperateException;
import org.datayoo.moql.operand.OperandContextArrayList;
import org.datayoo.moql.operand.OperandContextList;
import org.datayoo.moql.operand.expression.AbstractExpression;
import org.datayoo.moql.operand.expression.ExpressionType;
import org.datayoo.moql.operand.expression.member.MemberExpression;
import org.datayoo.moql.operand.expression.member.MemberVisitor;
import org.datayoo.moql.operand.variable.Variable;
import org.datayoo.moql.util.StringFormater;
import org.dom4j.Element;

public class MemberVariableExpression4M
extends AbstractExpression
implements MemberExpression {
    protected Variable variable;
    protected Operand target;
    protected Class<?> clazz;
    protected Method method;
    protected String getter;
    protected Map<Class<?>, Method> methodCache = new HashMap();
    protected Set<MemberVisitor> memberVisitors = null;

    public MemberVariableExpression4M(Operand target, Variable variable) {
        this(target, variable, null);
    }

    public MemberVariableExpression4M(Operand target, Variable variable, Set<MemberVisitor> memberVisitors) {
        this.expressionType = ExpressionType.MEMBER;
        Validate.notNull((Object)target, (String)"Parameter 'target' is null!", (Object[])new Object[0]);
        Validate.notNull((Object)variable, (String)"Parameter 'variable' is null!", (Object[])new Object[0]);
        this.target = target;
        this.variable = variable;
        this.name = this.buildNameString();
        this.memberVisitors = memberVisitors;
    }

    protected String buildNameString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.target.toString());
        sbuf.append('.');
        sbuf.append(this.variable.toString());
        return sbuf.toString();
    }

    protected String buildVariableGetter(boolean booleanType) {
        String name = this.variable.getName();
        StringBuffer sbuf = new StringBuffer();
        if (booleanType) {
            sbuf.append("is");
        } else {
            sbuf.append("get");
        }
        sbuf.append(Character.toUpperCase(name.charAt(0)));
        sbuf.append(name.substring(1));
        return sbuf.toString();
    }

    @Override
    public Operand getTarget() {
        return this.target;
    }

    @Override
    public Operand getMember() {
        return this.variable;
    }

    @Override
    public Object operate(EntityMap entityMap) {
        Object o = this.target.operate(entityMap);
        return this.operateProc(o);
    }

    protected Object operateProc(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof OperandContextList)) {
            if (o instanceof Map) {
                return this.operate((Map)o);
            }
            if (o instanceof JsonObject) {
                return this.operate((JsonObject)o);
            }
            if (o instanceof Element) {
                return this.operate((Element)o);
            }
            MemberVisitor memberVisitor = this.getVisitor(o);
            if (memberVisitor != null) {
                String name = this.variable.getName();
                return memberVisitor.operate(o, name);
            }
            return this.operate(o);
        }
        OperandContextList ctxList = (OperandContextList)o;
        OperandContextArrayList resultList = new OperandContextArrayList(ctxList.size());
        for (Object obj : ctxList) {
            Object ret = this.operate(obj);
            resultList.add(ret);
        }
        return resultList;
    }

    protected Object operate(Map map) {
        String name = this.variable.getName();
        return map.get(name);
    }

    protected Object operate(JsonObject jsonObject) {
        String name = this.variable.getName();
        JsonElement value = jsonObject.get(name);
        if (value.isJsonNull()) {
            return null;
        }
        if (value instanceof JsonPrimitive) {
            JsonPrimitive jp = (JsonPrimitive)value;
            if (jp.isString()) {
                return jp.getAsString();
            }
            if (jp.isBoolean()) {
                return jp.getAsBoolean();
            }
            if (jp.isNumber()) {
                return this.getNumber(jp);
            }
        }
        return value;
    }

    protected Object getNumber(JsonPrimitive value) {
        String v = value.getAsString();
        if (v.indexOf(46) == -1) {
            return value.getAsLong();
        }
        return value.getAsDouble();
    }

    protected Object operate(Element element) {
        String name = this.variable.getName();
        List list = element.elements(name);
        if (list.size() > 1) {
            return list;
        }
        return list.get(0);
    }

    protected MemberVisitor getVisitor(Object o) {
        if (this.memberVisitors == null) {
            return null;
        }
        for (MemberVisitor memberVisitor : this.memberVisitors) {
            if (!memberVisitor.isVisitable(o)) continue;
            return memberVisitor;
        }
        return null;
    }

    protected Object operate(Object o) {
        if (o instanceof Map) {
            return ((Map)o).get(this.variable.getName());
        }
        Method m = this.getMethod(o);
        try {
            return m.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            throw new OperateException(StringFormater.format((String)"Invoke field '{}' in class '{}' failed!", (Object[])new Object[]{this.variable.getName(), o.getClass().getName()}), e);
        }
    }

    protected Method getMethod(Object targetObject) {
        Class<?> objClazz = targetObject.getClass();
        if (this.clazz != null && objClazz.equals(this.clazz)) {
            return this.method;
        }
        Method m = this.methodCache.get(objClazz);
        if (m == null) {
            if (this.getter != null) {
                throw new OperateException(StringFormater.format((String)"Get field '{}' from class '{}' failed!", (Object[])new Object[]{this.variable.getName(), objClazz.getName()}));
            }
            try {
                this.getter = this.buildVariableGetter(false);
                m = objClazz.getMethod(this.getter, new Class[0]);
            }
            catch (Exception e) {
                this.getter = this.buildVariableGetter(true);
                try {
                    m = objClazz.getMethod(this.getter, new Class[0]);
                }
                catch (Exception e1) {
                    throw new OperateException(StringFormater.format((String)"Get field '{}' from class '{}' failed!", (Object[])new Object[]{this.variable.getName(), objClazz.getName()}), e1);
                }
            }
            this.methodCache.put(objClazz, m);
            this.clazz = objClazz;
            this.method = m;
        }
        return m;
    }

    @Override
    public void bind(String[] entityNames) {
        this.target.bind(entityNames);
        this.binded = true;
    }

    @Override
    public Object operate(Object[] entityArray) {
        Object o = this.target.operate(entityArray);
        return this.operateProc(o);
    }
}

