/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.member;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.OperateException;
import org.datayoo.moql.operand.OperandContextArrayList;
import org.datayoo.moql.operand.OperandContextList;
import org.datayoo.moql.operand.expression.AbstractExpression;
import org.datayoo.moql.operand.expression.ExpressionType;
import org.datayoo.moql.operand.expression.member.MemberExpression;
import org.datayoo.moql.operand.function.Function;
import org.datayoo.moql.operand.nativeFunc.AbstractNativeFunction;
import org.datayoo.moql.util.StringFormater;

public class MemberFunctionExpression
extends AbstractExpression
implements MemberExpression {
    protected Function function;
    protected Operand target;
    protected Class<?> clazz;
    protected Method method;
    protected Map<Class<?>, Method> methodCache = new HashMap();
    protected boolean nativeFunction = false;

    public MemberFunctionExpression(Operand target, Function function) {
        this.expressionType = ExpressionType.MEMBER;
        Validate.notNull((Object)target, (String)"Parameter 'target' is null!", (Object[])new Object[0]);
        Validate.notNull((Object)function, (String)"Parameter 'function' is null!", (Object[])new Object[0]);
        this.target = target;
        this.function = function;
        if (function instanceof AbstractNativeFunction) {
            this.nativeFunction = true;
        }
        this.name = this.buildNameString();
    }

    protected String buildNameString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.target.toString());
        sbuf.append('.');
        sbuf.append(this.function.toString());
        return sbuf.toString();
    }

    @Override
    public Object operate(EntityMap entityMap) {
        Object o = this.target.operate(entityMap);
        if (o == null) {
            return null;
        }
        if (!this.nativeFunction) {
            Object[] parameterObjects = this.getParameterObjects(entityMap);
            return this.operateProc(o, parameterObjects);
        }
        AbstractNativeFunction anf = (AbstractNativeFunction)this.function;
        anf.setTarget(o);
        return anf.operate(entityMap);
    }

    protected Object operateProc(Object o, Object[] parameterObjects) {
        if (!(o instanceof OperandContextList)) {
            return this.operate(o, parameterObjects);
        }
        OperandContextList ctxList = (OperandContextList)o;
        OperandContextArrayList resultList = new OperandContextArrayList(ctxList.size());
        for (Object obj : ctxList) {
            Object ret = this.operate(obj, parameterObjects);
            resultList.add(ret);
        }
        return resultList;
    }

    protected Object operate(Object o, Object[] parameterObjects) {
        Method m = this.getMethod(o, parameterObjects);
        try {
            return m.invoke(o, parameterObjects);
        }
        catch (Exception e) {
            throw new OperateException(StringFormater.format((String)"Invoke method '{}' in class '{}' failed!", (Object[])new Object[]{this.function.getName(), o.getClass().getName()}), e);
        }
    }

    protected Method getMethod(Object targetObject, Object[] parameterObjects) {
        Class<?> objClazz = targetObject.getClass();
        if (this.clazz != null && objClazz.equals(this.clazz)) {
            return this.method;
        }
        Method m = this.methodCache.get(objClazz);
        if (m == null) {
            block4: {
                Class<?>[] parameterTypes = this.getParameterTypes(parameterObjects);
                try {
                    m = objClazz.getMethod(this.function.getName(), parameterTypes);
                }
                catch (Exception e) {
                    m = this.derivationMethod(objClazz, this.function.getName(), parameterTypes);
                    if (m != null) break block4;
                    throw new OperateException(StringFormater.format((String)"Get method '{}' from class '{}' failed!", (Object[])new Object[]{this.function.getName(), objClazz.getName()}), e);
                }
            }
            this.methodCache.put(objClazz, m);
            this.clazz = objClazz;
            this.method = m;
        }
        return m;
    }

    protected Method derivationMethod(Class<?> objClazz, String methodName, Class<?>[] parameterTypes) {
        List<Method> methods = this.getMethods(objClazz, methodName, parameterTypes.length);
        methods.sort(new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                Class<?>[] o1ps = o1.getParameterTypes();
                Class<?>[] o2ps = o2.getParameterTypes();
                for (int i = 0; i < o1ps.length; ++i) {
                    if (o1ps[i].isAssignableFrom(o2ps[i])) {
                        return -1;
                    }
                    if (!o2ps[i].isAssignableFrom(o1ps[i])) continue;
                    return 1;
                }
                return 0;
            }
        });
        return this.getMethod(methods, parameterTypes);
    }

    protected Method getMethod(List<Method> methods, Class<?>[] parameterTypes) {
        if (methods.size() == 1) {
            return methods.get(0);
        }
        for (Method method : methods) {
            Class<?>[] pts = method.getParameterTypes();
            boolean matched = true;
            for (int i = 0; i < pts.length; ++i) {
                if (pts[i].isAssignableFrom(parameterTypes[i])) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return method;
        }
        return null;
    }

    protected List<Method> getMethods(Class<?> objClazz, String methodName, int paramCount) {
        LinkedList<Method> methods = new LinkedList<Method>();
        for (Method method : objClazz.getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameters().length != paramCount) continue;
            methods.add(method);
        }
        return methods;
    }

    protected Object[] getParameterObjects(EntityMap entityMap) {
        List<Operand> parameters = this.function.getParameters();
        Object[] parameterObjects = new Object[parameters.size()];
        int i = 0;
        for (Operand param : parameters) {
            Object o = param.operate(entityMap);
            parameterObjects[i++] = o;
        }
        return parameterObjects;
    }

    protected Class<?>[] getParameterTypes(Object[] parameterObjects) {
        Class[] parameterTypes = new Class[parameterObjects.length];
        for (int i = 0; i < parameterObjects.length; ++i) {
            parameterTypes[i] = parameterObjects[i] != null ? parameterObjects[i].getClass() : Object.class;
            parameterTypes[i] = this.adjustPrimitiveType(parameterTypes[i]);
        }
        return parameterTypes;
    }

    protected Class<?> adjustPrimitiveType(Class<?> clazz) {
        String name = clazz.getName();
        if (name.equals(Integer.class.getName())) {
            return Integer.TYPE;
        }
        if (name.equals(Long.class.getName())) {
            return Long.TYPE;
        }
        if (name.equals(Short.class.getName())) {
            return Short.TYPE;
        }
        if (name.equals(Byte.class.getName())) {
            return Byte.TYPE;
        }
        if (name.equals(Character.class.getName())) {
            return Character.TYPE;
        }
        if (name.equals(Double.class.getName())) {
            return Double.TYPE;
        }
        if (name.equals(Float.class.getName())) {
            return Float.TYPE;
        }
        if (name.equals(Boolean.class.getName())) {
            return Boolean.TYPE;
        }
        return clazz;
    }

    @Override
    public Operand getTarget() {
        return this.target;
    }

    @Override
    public Operand getMember() {
        return this.function;
    }

    @Override
    public void bind(String[] entityNames) {
        this.target.bind(entityNames);
        this.function.bind(entityNames);
        this.binded = true;
    }

    @Override
    public Object operate(Object[] entityArray) {
        Object o = this.target.operate(entityArray);
        if (o == null) {
            return null;
        }
        Object[] parameterObjects = this.getParameterObjects(entityArray);
        return this.operateProc(o, parameterObjects);
    }

    protected Object[] getParameterObjects(Object[] entityArray) {
        List<Operand> parameters = this.function.getParameters();
        Object[] parameterObjects = new Object[parameters.size()];
        int i = 0;
        for (Operand param : parameters) {
            Object o = param.operate(entityArray);
            parameterObjects[i++] = o;
        }
        return parameterObjects;
    }
}

