/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.bit;

import org.apache.commons.lang3.Validate;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.expression.OperationExpression;
import org.datayoo.moql.operand.expression.bit.BitwiseAndExpression;
import org.datayoo.moql.operand.expression.bit.BitwiseNotExpression;
import org.datayoo.moql.operand.expression.bit.BitwiseOrExpression;
import org.datayoo.moql.operand.expression.bit.BitwiseXorExpression;
import org.datayoo.moql.operand.expression.bit.LeftShiftExpression;
import org.datayoo.moql.operand.expression.bit.RightShiftExpression;
import org.datayoo.moql.util.StringFormater;

public class BitwiseExpressionFactory {
    public static OperationExpression createBitwiseExpression(String operator, Operand lOperand, Operand rOperand) {
        Validate.notEmpty((CharSequence)operator, (String)"Parameter 'operator' is empty!", (Object[])new Object[0]);
        if (operator.length() > 2) {
            throw new IllegalArgumentException(StringFormater.format((String)"Operator '{}' is invalid!", (Object[])new Object[]{operator}));
        }
        Validate.notNull((Object)rOperand, (String)"Parameter 'rOperand' is null!", (Object[])new Object[0]);
        if (operator.equals("~")) {
            return new BitwiseNotExpression(rOperand);
        }
        if (operator.equals("&")) {
            return new BitwiseAndExpression(lOperand, rOperand);
        }
        if (operator.equals("|")) {
            return new BitwiseOrExpression(lOperand, rOperand);
        }
        if (operator.equals("^")) {
            return new BitwiseXorExpression(lOperand, rOperand);
        }
        if (operator.equals("<<")) {
            return new LeftShiftExpression(lOperand, rOperand);
        }
        if (operator.equals(">>")) {
            return new RightShiftExpression(lOperand, rOperand);
        }
        throw new IllegalArgumentException(StringFormater.format((String)"Unsuppored operator '{}'!", (Object[])new Object[]{operator}));
    }
}

